#ifndef IMSVRARG_HH_
#define IMSVRARG_HH_
#include <map>
#include <string>
#include "basictype.hh"
#include "IMSvrCfg.hh"
#include "IMSvrCfgFile.hh"

class IMSvrCfgFile;

class IMSvrArg : public IMSvrCfg
{
    bool valid_flag;
    IMSvrCfgFile *pcfgfile;

    struct ArgVal {
	enum IMSvrCfg::IMSvrCfgOpt opt;
	bool specified;
	struct {
	    bool b;
	    int n;
	    string s;
	} arg;
	ArgVal(
	    enum IMSvrCfg::IMSvrCfgOpt x_opt
	) :  opt(x_opt)
	{
	    specified = false;
	}
    };

    typedef map<const char*, ArgVal, Functor_strcmp> IMSvrArgMap;
    IMSvrArgMap optmap;
    void show_usage();

    void addopt(
	enum IMSvrCfgOpt opt,
	const char* option
    );

    void initialize();
    bool parse_arguments(
	int argc,
	char **argv
    );
    bool set_argopt();

  public:
    virtual bool configure(
	IMSvr *pimsvr
    );

    IMSvrArg(
	int argc,
	char **argv
    );
    virtual ~IMSvrArg();
};

#endif /* not IMSVRARG_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
