#ifndef IMUSER_HH_
#define IMUSER_HH_
#include <string>
#include <list>
#include <functional>
#include "basictype.hh"
#include "IMDesktop.hh"

class IMConnection;

class IMUser
{
    u16string username;
    // int realid;

    typedef list<IMDesktop*> IMDesktopList;
    IMDesktopList desklist;

    // Special connection per user usually allocated
    // by IIIMXCF X backend client(aka. htt_xbe).
    IMConnection* paux_proxy_connection;

  public:
    IMDesktop* request_desktop(
	IMDesktop::IMDesktopAttr &attr
    );
    const u16string& get_username() const
    { return username; }

    IMUser(const u16string &username);
    ~IMUser();

  friend class IMUserMgr;
};

struct Functor_IMUser_username :
    public binary_function<IMUser*, IMUser*, bool> {
    bool operator()(
	const IMUser *pu1,
	const IMUser *pu2
    ) const
    {
	return pu1->get_username().compare(pu2->get_username()) < 0;
    }
};

#endif /* not IMUSER_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
