#ifndef LEMGR_HH_
#define LEMGR_HH_
#include <string>
#include <map>
#include <vector>
#include "basictype.hh"
#include "IMBasicObject.hh"
#include "LE.hh"

class IMInputContext;

class LEMgr
{
    string lepath;

    typedef map<string, LEBase*> LEBaseMap;
    typedef vector<string> LENameVec;
    LEBaseMap lemap;
    LEBase *psunim_default_lebase;
    LENameVec reload_les;

    bool ledata_inited;
    IMLangList langlist;
    IMDescriptorList imdesclist;
    IMObjectWithDescList imobjectdesclist;
    bool initialize_ledata();

    void check_new_LEs();
    void check_reloaded_LEs();
    void listup_LEs();

  public:
    const IMLangList* get_all_langlist();
    const IMDescriptorList* get_all_imdesclist();
    const IMObjectWithDescList* get_all_imobjectdesclist();
    LEContext *choose_LE(
	IMInputContext *pic
    );
    void reload();
    LEMgr(const char* lepath);
    virtual ~LEMgr();
};

#endif /* not IMSVRARG_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
