#include <config.h>
#include "IMBasicObject.hh"
#include "IMSignal.hh"
#include "IMSvr.hh"
#include "IMSvrArg.hh"
#include "IMLog.hh"
#include "IMUtil.hh"
#include "IMScheduler_MTPC.hh"

#ifdef HAVE_TLS
#include "IMTLS.hh"
#endif

int main(
    int argc,
    char **argv
)
{
    int exitcode;

    IMSvrArg arg(argc, argv);
    IMSvr svr(&arg);

    // Initialize singleton classes.

    //signal handling
    IMSignal *pimsignal = IMSignal::construct(&svr);
    if (!pimsignal) return IMSvr::IMSVR_SYSTEM_ERROR;
    //logging system
    IMLog *pimlog = IMLog::construct(argv[0]);
    if (!pimlog) return IMSvr::IMSVR_SYSTEM_ERROR;
    //scheduler
    IMScheduler *pimsch = IMScheduler_MTPC::construct();
    if (!pimsch) return IMSvr::IMSVR_SYSTEM_ERROR;
    //object manager
    IMObjectMgr *pimobjmgr = IMObjectMgr::construct();
    if (!pimobjmgr) return IMSvr::IMSVR_SYSTEM_ERROR;
#ifdef HAVE_TLS
    // tls manager
    IMTLS *ptls = IMTLS::construct();
    if (!ptls) return IMSvr::IMSVR_SYSTEM_ERROR;
#endif

    exitcode = svr.start();

    // cleanup
    IMSignal::cleanup();
    IMLog::cleanup();
    IMDaemon::cleanup();
#ifdef HAVE_TLS
    IMTLS::cleanup();
#endif

    return exitcode;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
