/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <Xm/Xm.h>

#include "xaux_locale.h"
#include "xaux_common.h"
#include "xaux_ext_common.h"
#include "CmnFunction.h"
#include "hzinput.h"
#include "PaletteAux.h"
#include "OptionConfig.h"

/* Define Aux class */
xaux_class_t *xc_ = 0;
int im_ = 0;
int ic_ = 0;

/* Define Aux class */
xaux_class_t xaux_class = {
	XAUX_PALETTE_CLASS_NAME, 1,
	NULL,
	(Window)0, (Window)0,
	(Atom)0, (Atom)0, (Atom)0,
	{ (Atom)0 }, ATOM_NUM_PALETTEAUX, 0,
	{ (Atom)0 }, ATOM_NUM_PALETTEAUX, 0,
	NULL,
};

/*  Auxiliary Window User Input Method Information  */
extern IMEListRec	AllIMEList, SelectedIMEList;
extern PaletteAuxData 	gPAData;
extern Display 	*gDisplay;
extern char 	gLocaleID;

extern int 		gIMEOptionsNum;
extern IMEOption_Item	*gIMEOptions[];

void xaux_ext_event_handler(Widget, XtPointer, XEvent *, Boolean *);

void PaletteAux_Set_Options_Request();
void PaletteAux_Connect_To_LE_Request();
void PaletteAux_Lost_Focus_Request();
void PaletteAux_Proc_LE_Notify();
void PaletteAux_Proc_LE_Set_IMEInfo_Notify();
void PaletteAux_Proc_LE_Update_IMEInfo_Notify();
void PaletteAux_Proc_LE_Switch_Conversion_Notify();
void PaletteAux_Proc_LE_Switch_IME_Notify();
void PaletteAux_Proc_LE_Switch_QjBj_Notify();
void PaletteAux_Proc_LE_Switch_Punct_Notify();
void PaletteAux_Proc_LE_Change_Focus_Notify();
void PaletteAux_Proc_LE_Set_IMEInfo_End_Notify(aux_ext_data_t *aux_ext_data);
void PaletteAux_Proc_LE_New_IMEInfo_Notify(aux_ext_data_t *aux_ext_data);
void PaletteAux_Proc_LE_Update_KeymapInfo_Notify(aux_ext_data_t *aux_ext_data);

/*   
	Event Handler 
*/
void xaux_ext_event_handler(Widget w, XtPointer client_data, XEvent * event, Boolean * b)
{
	switch (event->type) {
		case ClientMessage:
			xaux_ext_process_client_message(XtDisplay(w),
				(XClientMessageEvent *) event);
			break;
		case SelectionClear:
			PaletteAux_Lost_Focus_Request();
			break;
	}
	return;
}

/*
	xaux_ext_init_classes(): Initialize the Atom of Auxiliary Window.
	It is in ../xaux_common/xaux_ext_common.c
*/
int xaux_ext_register_classes(Widget shell)
{
	/* Register aux class */
	if (xaux_ext_init_classes(XtDisplay(shell), &xaux_class, XtWindow(shell)) == False)
		return(-1);

	/* Register event handler */
	XtAddEventHandler(shell, PropertyChangeMask, False,
		xaux_ext_event_handler, NULL);
	XtAddEventHandler(shell, NoEventMask, True,
		xaux_ext_event_handler, NULL);

	return(0);
}

/* 
Note:
     xaux_ext_Start(), xaux_ext_Draw(), xaux_ext_Done() 
     These three functions are all called by xaux_ext_process_client_message()

     xaux_ext_SetValue() will send auxiliary window information to language engine;
*/

/* Method - Start */
Bool xaux_ext_Start(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Start: im:%d, ic:%d\n", aux_ext_data->im, aux_ext_data->ic);
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

	/* inform Language Engine that PaletteAux has started. */
	PaletteAux_Connect_To_LE_Request(gLocaleID);

	/* Get Options Setting and send settings to Language engine. */
	OptionsList_Init();
	Get_OptionsList_From_Profile();
	PaletteAux_Set_Options_Request();
	OptionsList_Free();

	return True;
}

/* Method - Draw */
Bool xaux_ext_Draw(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Draw == im:0x%x, ic:0x%x\n",aux_ext_data->im, aux_ext_data->ic);
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

        PaletteAux_Proc_LE_Notify(aux_ext_data);
	return True;
}

/* Method - Done */
Bool xaux_ext_Done(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Done im:0x%x, ic_id:0x%x\n", aux_ext_data->im, aux_ext_data->ic);
	return True;
}


/* ================================================================= */
/*       Process Notify information From Language Engine             */
/* ================================================================= */
void PaletteAux_Proc_LE_Notify(aux_ext_data_t *aux_ext_data)
{
	int nIntegerCount, notifyType;

	nIntegerCount = aux_ext_data->integer_count;
	if (nIntegerCount <= 0) return;

	notifyType = aux_ext_data->integer_list[0];

	switch (notifyType)
	{
		case PALETTEAUX_SWITCH_CONVERSION_NOTIFY:
			DEBUG_printf("PALETTEAUX_SWITCH_CONVERSION_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Switch_Conversion_Notify(aux_ext_data);
			break;
		case PALETTEAUX_SWITCH_IME_NOTIFY:
			DEBUG_printf("PALETTEAUX_SWITCH_IME_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Switch_IME_Notify(aux_ext_data);
			break;
		case PALETTEAUX_SWITCH_QJBJ_NOTIFY:
			DEBUG_printf("PALETTEAUX_SWITCH_QJBJ_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Switch_QjBj_Notify(aux_ext_data);
			break;
		case PALETTEAUX_SWITCH_PUNCT_NOTIFY:
			DEBUG_printf("PALETTEAUX_SWITCH_PUNCT_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Switch_Punct_Notify(aux_ext_data);
			break;
		case PALETTEAUX_UPDATE_IMEINFO_NOTIFY:
			DEBUG_printf("PALETTEAUX_UPDATE_IMEINFO Notify Received\n");
			PaletteAux_Proc_LE_Update_IMEInfo_Notify(aux_ext_data);
			break;
		case COMMONAUX_CHANGE_FOCUS_NOTIFY:
			DEBUG_printf("COMMONAUX_CHANGE_FOCUS_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Change_Focus_Notify(aux_ext_data);
			break;
		case COMMONAUX_SET_IME_NEW_NOTIFY:
			DEBUG_printf("COMMONAUX_SET_IME_NEW_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_New_IMEInfo_Notify(aux_ext_data);
			break;
		case COMMONAUX_SET_IME_INFO_NOTIFY:
			DEBUG_printf("COMMONAUX_SET_IMEINFO Notify Received\n");
			PaletteAux_Proc_LE_Set_IMEInfo_Notify(aux_ext_data);
			break;
		case COMMONAUX_SET_IME_END_NOTIFY:
			DEBUG_printf("COMMONAUX_SET_IME_END_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Set_IMEInfo_End_Notify(aux_ext_data);
			break;
		case COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY:
			DEBUG_printf("PALETTEAUX_UPDATE_KEYMAPINFO_NOTIFY Notify Received\n");
			PaletteAux_Proc_LE_Update_KeymapInfo_Notify(aux_ext_data);
			break;
	}
}

void PaletteAux_Set_Selection_Owner()
{
	Widget shell = gPAData.wdtShell;
	Atom aux_atom = XInternAtom(XtDisplay(shell), "CH_PALETTEAUX_MODULE_ATOM", False);

	XSetSelectionOwner(XtDisplay(shell), aux_atom, XtWindow(shell), CurrentTime);
}

void PaletteAux_Proc_LE_New_IMEInfo_Notify(aux_ext_data_t *aux_ext_data)
{
	IMEList_Free();
}

void PaletteAux_Proc_LE_Set_IMEInfo_Notify(aux_ext_data_t *aux_ext_data)
{
	IMEBaseRec baseinfo;
	int i, nIntegerCount, engine_num;

	nIntegerCount = aux_ext_data->integer_count;
	if (nIntegerCount <= 0) return;

	DEBUG_printf("PaletteAux_Proc_LE_Set_IMEInfo_Notify\n");

	baseinfo.engine_id = aux_ext_data->integer_list[1];
	baseinfo.locale_id = aux_ext_data->integer_list[2];
	baseinfo.encode_id = aux_ext_data->integer_list[3];
	baseinfo.status = aux_ext_data->integer_list[4];

	baseinfo.ename = (char *)(aux_ext_data->string_list[0].ptr);
	baseinfo.cname = (char *)(aux_ext_data->string_list[1].ptr);

	Add_IME_To_AllList(&baseinfo);
}

void PaletteAux_Proc_LE_Set_IMEInfo_End_Notify(aux_ext_data_t *aux_ext_data)
{
	/* process user defined imes, such as user prefer IMEs*/
	Select_IMEs_From_Profile();

	/* create IME list menu */
	PaletteAux_CreateIMEListMenu();
}

void PaletteAux_Proc_LE_Update_IMEInfo_Notify(aux_ext_data_t *aux_ext_data)
{
	/* process user defined imes, such as user prefer IMEs*/
	Select_IMEs_From_Profile();

	/* create IME list menu */
	PaletteAux_CreateIMEListMenu();
}

void PaletteAux_Proc_LE_Update_KeymapInfo_Notify(aux_ext_data_t *aux_ext_data)
{
	int i, engine_id, ime_id;

	engine_id = aux_ext_data->integer_list[1];

	if (IMEVKB_Check_If_Exist(engine_id)) return;

	ime_id = get_ime_id_by_engine_id(&AllIMEList, engine_id);
	if (ime_id == -1) return;

	IMEVKB_Name_List_Add(engine_id, AllIMEList.arrIME_Base[ime_id]->cname);
}

void PaletteAux_Proc_LE_Switch_Conversion_Notify(aux_ext_data_t *aux_ext_data)
{
	int on_status;

	on_status = aux_ext_data->integer_list[1];

	gPAData.on = on_status;
	PaletteAux_UpdateStatus();
}

/* if find item by engine_id, return its index, else return -1 */
int get_ime_id_by_engine_id(IMEListRec *imelist, int engine_id)
{
	int i;

	for (i = 0; i < imelist->nIME_Num; i++) {
		if (imelist->arrIME_Base[i] && 
		    imelist->arrIME_Base[i]->engine_id == engine_id) 
			return(i);
	}
	return(-1);
}

void PaletteAux_Proc_LE_Switch_IME_Notify(aux_ext_data_t *aux_ext_data)
{
	int switch_type;
	int engine_id, ime_id, nIME_Num;
	
	switch_type = aux_ext_data->integer_list[1];

	nIME_Num = SelectedIMEList.nIME_Num;
	DEBUG_printf("SelectedIMEList.nIME_Num:%d\n", nIME_Num);
	if (nIME_Num <= 0) return;

	switch(switch_type)
	{
		case IME_ROUND_SWITCH:
			/* select next available IME */
			engine_id = gPAData.engine_id;
			ime_id = get_ime_id_by_engine_id(&SelectedIMEList, engine_id);
			DEBUG_printf("IME_ROUND_SWITCH == current ime_id:%d\n", ime_id);
			ime_id = (ime_id + 1) % nIME_Num;
			break;	

		case IME_SELECT_SWITCH:
			/* select a specific available IME */
			ime_id = aux_ext_data->integer_list[2];
			DEBUG_printf("IME_SELECT_SWITCH == ime_no:%d\n", ime_id);
			break;	
	}

	DEBUG_printf("IME_SWITCH == ime_id:%d\n", ime_id);

	/* Change IME logo on the control bar */
	/* and need notify LE to switch IME */
	PaletteAux_ChangeIME(ime_id, True);
}

void PaletteAux_Proc_LE_Switch_QjBj_Notify(aux_ext_data_t *aux_ext_data)
{
	/* Change auxiliary window Full_Width/half_Width information */
	gPAData.qjbj = aux_ext_data->integer_list[1];

	PaletteAux_ChangeQjBj(gPAData.qjbj);
}

void PaletteAux_Proc_LE_Switch_Punct_Notify(aux_ext_data_t *aux_ext_data)
{
	/* Change auxiliary window English/Chinese Punctuation information */
	gPAData.punct = aux_ext_data->integer_list[1];

	PaletteAux_ChangePunct(gPAData.punct);
}

void PaletteAux_Proc_LE_Change_Focus_Notify(aux_ext_data_t *aux_ext_data)
{
	gPAData.x 	= aux_ext_data->integer_list[1];
	gPAData.y 	= aux_ext_data->integer_list[2];
	gPAData.on 	= aux_ext_data->integer_list[3];
	gPAData.qjbj 	= aux_ext_data->integer_list[4];
	gPAData.punct 	= aux_ext_data->integer_list[5];
	gPAData.engine_id 	= aux_ext_data->integer_list[6];

	if (gPAData.on)
		PaletteAux_Set_Selection_Owner();

	PaletteAux_UpdateStatus();
}

/* ================================================================= */
/*             Send information to Language Engine                   */
/* ================================================================= */
void PaletteAux_Connect_To_LE_Request(int locale_id)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_CONNECT;
	pIntegerList[1] = locale_id;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Switch_LE_Conversion_Request(int on)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SWITCH_CONVERSION;
	pIntegerList[1] = on;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Switch_LE_Engine_Request(int engine_id)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SWITCH_IME;
	pIntegerList[1] = engine_id;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Switch_LE_QjBj_Request(int qjbj)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SWITCH_QJBJ;
	pIntegerList[1] = qjbj;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Switch_LE_Punct_Request(int punct)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SWITCH_PUNCT;
	pIntegerList[1] = punct;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Change_LE_Position_Request(int x, int y)
{
	int nIntegerCount, pIntegerList[3];

	nIntegerCount = 3;
	pIntegerList[0] = PALETTEAUX_CHANGE_POSITION;
	pIntegerList[1] = x;
	pIntegerList[2] = y;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Show_SelectAux_Request()
{
	int nIntegerCount, pIntegerList[1];

	nIntegerCount = 1;
	pIntegerList[0] = PALETTEAUX_SHOW_SELECTAUX;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Show_OptionAux_Request()
{
	int nIntegerCount, pIntegerList[1];

	nIntegerCount = 1;
	pIntegerList[0] = PALETTEAUX_SHOW_OPTIONAUX;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Show_KeyboardAux_Request(int nKeyboardID)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = PALETTEAUX_SHOW_KEYBOARDAUX;
	pIntegerList[1] = nKeyboardID;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Show_LookupAux_Request()
{
	int nIntegerCount, pIntegerList[1];

	nIntegerCount = 1;
	pIntegerList[0] = PALETTEAUX_SHOW_LOOKUPAUX;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_StartAction_Request(char *command)
{
	int nIntegerCount, pIntegerList[1];
	int nStringCount, pStringLen[1];
	char *pStringList[1];

	nIntegerCount = 1;
	pIntegerList[0] = PALETTEAUX_START_ACTION;
	nStringCount = 1;
	pStringLen[0] = strlen(command);
	pStringList[0] = command;

	NotifyStringListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList,
			nStringCount, pStringLen,
			pStringList);
}

void PaletteAux_Lost_Focus_Request()
{
	int nIntegerCount, pIntegerList[1];

	nIntegerCount = 1;
	pIntegerList[0] = COMMONAUX_LOST_FOCUS;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

void PaletteAux_Set_Options_Request()
{
	int nIntegerCount, pIntegerList[MAX_ENGINE_NUM + 1];
	int nStringCount, pStringLen[MAX_ENGINE_NUM];
	char *pStringList[MAX_ENGINE_NUM], *name;
	int i, nNum;

	if (gIMEOptionsNum <= 0) return;

	nNum = gIMEOptionsNum;
	if (nNum > MAX_ENGINE_NUM) nNum = MAX_ENGINE_NUM;

	nIntegerCount = nNum + 1;
	pIntegerList[0] = COMMONAUX_UPDATE_OPTIONSINFO;

	nStringCount = nNum;
	for (i=0; i<nNum; i++) {
		name = gIMEOptions[i]->ime_ename;
		pStringLen[i] = strlen(name);
		pStringList[i] = name;
		pIntegerList[i + 1] = gIMEOptions[i]->opt_value;
	}

	NotifyStringListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList,
			nStringCount, pStringLen,
			pStringList);
}

NotifyIntegerListDataToLanguageEngine(Display *display, 
int nIntegerCount, int *pIntegerList)
{
	aux_ext_data_t aux_ext_data;

	DEBUG_printf("im_:%d, ic_:%d\n", im_, ic_);

	if (!im_ || !ic_ || !xc_)
		return;

	aux_ext_data.im = im_;
	aux_ext_data.ic = ic_;
	aux_ext_data.integer_count = nIntegerCount;
	aux_ext_data.integer_list = pIntegerList;
	aux_ext_data.string_count = 0;
	aux_ext_data.string_list = NULL;
	aux_ext_data.string_ptr = NULL;
	aux_ext_data.point.x = 0;
	aux_ext_data.point.y = 0;

	xaux_ext_SetValue(display, xc_, &aux_ext_data);
	XFlush(display);
}

NotifyStringListDataToLanguageEngine(Display *display, 
int nIntegerCount, int *pIntegerList,
int nStringCount,  int *pStringLen,
char **pStringList)
{
	int i;

	aux_ext_data_t aux_ext_data;
	aux_ext_string_t *p;

	DEBUG_printf("im_:%d, ic_:%d\n", im_, ic_);

	if (!im_ || !ic_ || !xc_)
		return;

	aux_ext_data.im = im_;
	aux_ext_data.ic = ic_;
	aux_ext_data.integer_count = nIntegerCount;
	aux_ext_data.integer_list = pIntegerList;
	aux_ext_data.point.x = 0;
	aux_ext_data.point.y = 0;

	aux_ext_data.string_count = nStringCount;
	aux_ext_data.string_ptr = NULL;

	if (nStringCount > 0) {
		aux_ext_data.string_list = (aux_ext_string_t *) calloc(nStringCount, sizeof(aux_ext_string_t));
		for (i = 0; i < nStringCount; i++) {
			aux_ext_string_t *p = &aux_ext_data.string_list[i];
			p->length = pStringLen[i];
			p->ptr = (unsigned char *) (pStringList[i]);
		}
	}

	xaux_ext_SetValue(display, xc_, &aux_ext_data);
	XFlush(display);

	free(aux_ext_data.string_list);
}

