/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "encode.h"

#define  GB2312_NEIMA_NAME 	"GB"
#define  GBK_NEIMA_NAME		"GBK"
#define  GB18030_NEIMA_NAME	"GB18030"
#define  BIG5_NEIMA_NAME	"BIG5X"
#define  EUC_NEIMA_NAME 	"EUC"
#define  BIG5HK_NEIMA_NAME	"BIG5HKX"
#define  UNICODE_NEIMA_NAME	"UNICODE"

typedef struct _NeiMa_Encode_Name {
	int 	encode;
	char 	*name;
} NeiMa_Encode_Name;

NeiMa_Encode_Name nm_encode_name[] = {
	{ ENCODE_GB2312, 	GB2312_NEIMA_NAME },
	{ ENCODE_GBK,   	GBK_NEIMA_NAME    },
	{ ENCODE_GB18030,   	GB18030_NEIMA_NAME},
	{ ENCODE_BIG5, 		BIG5_NEIMA_NAME   },
	{ ENCODE_EUC_TW,  	EUC_NEIMA_NAME    },
	{ ENCODE_BIG5HK,  	BIG5HK_NEIMA_NAME },
	{ ENCODE_UTF8, 		UNICODE_NEIMA_NAME},
	{ 0,			NULL              }
};
 
char *get_neima_name_by_encode(int encode)
{
	NeiMa_Encode_Name *str_val = nm_encode_name;
        while (str_val->name) {
                if (str_val->encode == encode)
                        return ((char *)str_val->name);
                str_val++;
        }

	/* Default Name */
        return (GB2312_NEIMA_NAME);
}

int is_valid_code(int encode, unsigned char *int_code, int code_len)
{
	unsigned char code0, code1, code2, code3;
	
	code0 = int_code[0];
	code1 = int_code[1];

	switch (encode) {
		case ENCODE_GB2312:
			if (code0 < 0xA1 || code0 > 0xFE)
				return (-1);
			if (code1 < 0xA1 || code1 > 0xFE)
				return (-1);
			break;
			
		case ENCODE_GBK:
			if (code0 < 0x81 || code0 > 0xFE)
				return (-1);
			if (code1 < 0x40 || code1 > 0xFE || code1 == 0x7F)
				return (-1);
			break;

		case ENCODE_GB18030:
			if (code_len == 2) {
				if (code0 < 0x81 || code0 > 0xFE)
					return (-1);
				if (code1 < 0x40 || code1 > 0xFE || code1 == 0x7F)
					return (-1);
			} else if (code_len == 4) {
				code2 = int_code[2];
				code3 = int_code[3];
				if (code0 < 0x81 || code0 > 0xFE)
					return (-1);
				if (code1 < 0x30 || code1 > 0x39)
					return (-1);
				if (code2 < 0x81 || code2 > 0xFE)
					return (-1);
				if (code3 < 0x30 || code3 > 0x39)
					return (-1);
			}
			break;

		case ENCODE_BIG5:
#if 0
			/* define in lcbig5.c */
			if ((code0 >= 0xA1) && code0 <= 0xC5) || (code0 >= 0xC9 && code0 <= 0xF9)) {
				if (code1 < 0x40 || code1 == 0xFF || (code1 >= 0x7F && code1 <= 0xA0))
					return (-1);
				else
					return (0);
			} else {
				if (code0 == 0xC6 && (code1 >= 0x40 && code1 <= 0x7E))
					return (0);
				else
					return (-1);
			}
#endif
					
			if (code0 < 0xA1 || code0 > 0xFE)
				return (-1);
			if (code1 < 0x40 || code1 > 0xFE)
				return (-1);
			if (code1 > 0x7E && code1 < 0xA1)
				return (-1);
			break;

		case ENCODE_EUC_TW:
			if (code_len == 2) {
				if (code0 < 0x80 || code1 <0x80)
					return (-1);
			} if (code_len == 4) {
				code2 = int_code[2];
				code3 = int_code[3];
				if (code0 != 0x8E)
					return(-1);
				if (code1 < 0x80 || code2 < 0x80 || code3 < 0x80)
					return(-1);
			}
			break;

		case ENCODE_BIG5HK:
			if (code0 < 0x81 || code0 > 0xFE)
				return (-1);
			if (code1 < 0x40 || code1 > 0xFE)
				return (-1);
			break;

		case ENCODE_UTF8:
			break;
	}
	return(0);
}


