/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>

#include "le.h"
#include "wtt.h"
#include "encode.h"
#include "hzinput.h"
#include "xaux_locale.h"

char *pArrModeName[MODE_NUM] = {
	PASSTHROUGH_MODE_NAME,
	BASIC_MODE_NAME,
	STRICT_MODE_NAME
};

void le_commit_key(iml_session_t *s, unsigned char key);
void le_status_draw(iml_session_t *s);
int map_keyevent_to_immkey(IMKeyEventStruct *key_event);
int map_keyevent_to_imekey(IMKeyEventStruct *key_event);
void proc_key_output(iml_session_t *s, unsigned char key);
void proc_key_switch_conversion_event(iml_session_t *s, int on);

extern unsigned char _TAC_Keymap[97];

/* process the keyboard event */
void proc_key_event(iml_session_t *s, IMKeyListEvent *keylistevent)
{
	int ret, key_ret, mode_id;
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	IMKeyEventStruct *key_event = (IMKeyEventStruct *) keylistevent->keylist;

	DEBUG_printf(" proc_keyevent:   session:%x\n", s);

	key_ret = map_keyevent_to_immkey(key_event);

	switch (key_ret)
	{
		/* English status <----> Chinese status */
		case ENGLISH_CHINESE_SWITCH_KEY:
			proc_key_switch_conversion_event(s, CONVERSION_OFF);
			session_data->last_pressed_key = 0;
			return;

		/* Roundly Switch Input methods */
		case SWITCH_F2_KEY:
			mode_id = session_data->paletteaux_status.mode_id;
			mode_id = (mode_id + 1) % MODE_NUM;
			session_data->paletteaux_status.mode_id = mode_id;
			le_status_draw(s);
			le_switch_mode_notify(s, session_data->paletteaux_status.mode_id);
			return;
#if 0
		/* Switch to N-th Input method */
		case SWITCH_F3_KEY:
		case SWITCH_F4_KEY:
			session_data->paletteaux_status.mode_id = key_ret - SWITCH_F2_KEY;
			le_status_draw(s);
			le_switch_mode_notify(s, session_data->paletteaux_status.mode_id);
			return;
#endif
	}

	key_ret = map_keyevent_to_imekey(key_event);
	if (key_ret == IME_NOT_USED_KEY) {
		iml_sendback_key(s, key_event);
		session_data->last_pressed_key = 0;
		return;
	}

	proc_key_output(s, key_ret);
}

/* filter keys that used by Input Methods Manager */
int map_keyevent_to_immkey(IMKeyEventStruct *key_event) 
{
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	DEBUG_printf("keycode: 0x%x, keychar:0x%x, keystatus: 0x%x\n", keycode, keychar, keystatus);

	/* Function Keys */
	if (keycode == IM_VK_F2)
		return(SWITCH_F2_KEY);

	/* Ctrl + Space */
	if ((keycode == IM_VK_SPACE) && (keystatus & IM_CTRL_MASK))
		return(ENGLISH_CHINESE_SWITCH_KEY);

	return (IMM_NOT_USED_KEY);
}

/*  get the keys that IME will use */
int map_keyevent_to_imekey(IMKeyEventStruct *key_event) 
{
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	if (keycode >= IM_VK_COMMA && keycode <= IM_VK_CLOSE_BRACKET) {
		if (! (keystatus & IM_CTRL_MASK) &&
		    ! (keystatus & IM_META_MASK) &&
		    ! (keystatus & IM_ALT_MASK) &&
		    ! (keystatus & IM_ALT_GRAPH_MASK) )
			return(keychar);
	}

	return (IME_NOT_USED_KEY);
}

void proc_key_switch_conversion_event(iml_session_t *s, int on)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("ENGLISH_CHINESE SWITCH IME KEY, on:%d\n", on);

	session_data->paletteaux_status.on = on;
	if (on == CONVERSION_OFF) {
		le_status_draw(s);
		iml_conversion_off(s);
	} else {
		iml_conversion_on(s);
		le_status_draw(s);
	}

	le_change_focus_notify(s);
}

void le_status_draw(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char status_string[128];
	char *mode_string;
	int  mode_id;

	mode_id = session_data->paletteaux_status.mode_id;
        if (mode_id < 0 || mode_id >= MODE_NUM)
                mode_id = DEFAULT_MODE_ID;
        mode_string = pArrModeName[mode_id];

	if (session_data->paletteaux_status.on) {
		sprintf(status_string, "[ %s ] [ %s ]", (char *)THAI_LANG_NAME, mode_string);
	} else {
		sprintf(status_string, "[ %s ]", (char *)ENGLISH_LANG_NAME);
	}
	
	encode_draw_status(s, ENCODE_EUC_TH, status_string);
}

void le_commit_key(iml_session_t *s, unsigned char key)
{
	unsigned char key_string[2];
	key_string[0] = key;
	key_string[1] = 0;
	encode_commit(s, ENCODE_EUC_TH, key_string);
}

void proc_key_output(iml_session_t *s, unsigned char key)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	int Mode = session_data->paletteaux_status.mode_id;
	int ret;

	unsigned char following_key, leading_key;

	following_key = _TAC_Keymap[key-0x20];
	DEBUG_printf("key:%c, TAC_key:\\%o, 0x%x\n", key, following_key, following_key);
	leading_key = session_data->last_pressed_key;
	DEBUG_printf("leading_key:0x%x\n", leading_key);
	if (leading_key == 0) {
		session_data->last_pressed_key = following_key;
		DEBUG_printf("leading_key = 0, commit following_key:0x%x\n", following_key);
		le_commit_key(s, following_key);
	} else {
		ret = TACcomposible(Mode, following_key, leading_key);
		DEBUG_printf("leading_key != 0, Composible return:%d\n", ret);
		if (ret == _TAC_ACCEPT) {
			DEBUG_printf("Composible return(ACCEPT), commit following_key:0x%x\n", following_key);
			session_data->last_pressed_key = following_key;
			le_commit_key(s, following_key);
		} 
	}
}

