/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/* 
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

#include <stdio.h>

#include "thai_le.h"
#include "wtt_isc.h"

Bool if_le_OpenIF(iml_if_t *);
Bool if_le_CloseIF(iml_if_t *);
Bool if_le_GetIFValue(iml_if_t *, IMArgList, int);
Bool if_le_SetIFValue(iml_if_t *, IMArgList, int);
Bool if_le_OpenDesktop(iml_desktop_t *, IMArgList, int);
Bool if_le_CloseDesktop(iml_desktop_t *);
Bool if_le_CreateSC(iml_session_t *, IMArgList, int);
Bool if_le_DestroySC(iml_session_t *);
Bool if_le_GetSCValue(iml_session_t *, IMArgList, int);
Bool if_le_SetSCValue(iml_session_t *, IMArgList, int);
IMText *if_le_ResetSC(iml_session_t *);
void if_le_SetSCFocus(iml_session_t *);
void if_le_UnsetSCFocus(iml_session_t *);
void if_le_SendEvent(iml_session_t *, IMInputEvent * ev);

/* IF Method */
if_methods_t le_methods = {
	if_le_OpenIF,
	if_le_CloseIF,
	if_le_GetIFValue,
	if_le_SetIFValue,
	if_le_OpenDesktop,
	if_le_CloseDesktop,
	if_le_CreateSC,
	if_le_DestroySC,
	if_le_GetSCValue,
	if_le_SetSCValue,
	if_le_ResetSC,
	if_le_SetSCFocus,
	if_le_UnsetSCFocus,
	if_le_SendEvent
};

extern char lename_string[];
extern UTFCHAR lename_utf_string[];
extern IMLocale locales[];

static IMLEName lename = {lename_string, lename_utf_string };
static IMObjectDescriptorStruct *objects = NULL;

TThaiKeymapList gThaiKeymapList;

/* create an IM Object instantance */
void objects_init()
{
	char xaux_so_path[125];
	IMObjectDescriptorStruct *l;

	DEBUG_printf("init objects, objects:%x\n", objects);

	if (objects != NULL) return;

	objects = (IMObjectDescriptorStruct *) calloc(2, sizeof(IMObjectDescriptorStruct));
	if (objects == NULL) return;

	sprintf(xaux_so_path, "./locale/%s/aux.so", XAUX_LOCALE_NAME);
	l = objects;
	l->leid = lename_string;                   /* engine id */
	l->type = IM_DOWNLOADINGOBJECT_BINGUI_TYPE; /* object type */
	l->name = lename_utf_string;                   
	l->name_length = UTFCHARLen(lename_utf_string);
	l->domain = "com.sun";
	l->scope = lename_string;
	l->path = (char *)(strdup(xaux_so_path));    /* path for .so from /usr/lib/im/ */
	l->signature = "";
	l->basepath = NULL;         /* only for CCDEF */
	l->encoding = NULL;         /* only for CCDEF */
}

void objects_done()
{
	DEBUG_printf("free objects\n");

	if (objects == NULL) return;

	if (objects[0].path) free((char *)(objects[0].path));
	free(objects);
	objects = NULL;
}

/* htt_server get the IF information when start htt_server */
void if_GetIfInfo( IMArgList args, int num_args)
{
	int i;

	DEBUG_printf("if_GetIfInfo == num_args:%d\n", num_args);

	objects_init(); 
	for (i = 0; i < num_args; i++, args++) {
		switch (args->id) {
			case IF_VERSION:
                		args->value = (IMArgVal) "1.2";
                		break;
            		case IF_METHOD_TABLE:
                		args->value = (IMArgVal) & le_methods;
                		break;
            		case IF_LE_NAME:
                		args->value = (IMArgVal) & lename;
                		break;
            		case IF_SUPPORTED_LOCALES:
                		args->value = (IMArgVal) & locales;
                		break;
            		case IF_SUPPORTED_OBJECTS:
                		args->value = (IMArgVal) objects; 
                		break;
            		case IF_NEED_THREAD_LOCK:
                		args->value = (IMArgVal) True;
                		break;
            		default:
                		break;
            	}
    	}
}

/* Open the IF interface */
Bool if_le_OpenIF(iml_if_t * If)
{
	char *keymap_config_file = "/usr/lib/im/locale/th_TH/thai_keymap.cfg";
	TThaiKeymapList *pThaiKeymapList = &gThaiKeymapList;

    	DEBUG_printf("if_le_OpenIF ====\n");

	/* Get all Thai Keyboard mappings */
	ThaiKeymapList_Init(pThaiKeymapList);
	Thai_Read_Config(keymap_config_file, pThaiKeymapList);
/*
	ThaiKeymapList_Print(pThaiKeymapList);
*/
	
    	return True;
}

/* Close the IF interface */
Bool if_le_CloseIF(iml_if_t * If)
{
    	DEBUG_printf("if_le_CloseIF === \n");
    	objects_done();

	ThaiKeymapList_Free(&gThaiKeymapList);

    	return True;
}

Bool if_le_GetIFValue(iml_if_t * If, IMArgList args, int num_args)
{
    	DEBUG_printf("if_le_GetIFValue()\n");
    	return True;
}

Bool if_le_SetIFValue(iml_if_t * If, IMArgList args, int num_args)
{
    	DEBUG_printf("if_le_SetIFValue()\n");
    	return True;
}

Bool if_le_OpenDesktop(iml_desktop_t * desktop, IMArgList args, int num_args)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *)calloc(1,sizeof(MyDataPerDesktop));

    	DEBUG_printf("if_le_OpenDesktop()\n");

	desktop_data->pCurrentSession = 0;
	desktop_data->pRootSession = 0;

	desktop_data->bPaletteAux_Started = False;
	desktop_data->bPaletteAux_Ready = False;
	desktop_data->bKeyboardAux_Started = False;
	desktop_data->bOptionAux_Started = False;

	desktop_data->nDefault_InputMode_ID = WTT_ISC0;
	if (gThaiKeymapList.nNum_Keymaps > 0)
		desktop_data->nDefault_Keyboard_ID = 0;
	else
		desktop_data->nDefault_Keyboard_ID = 0xff;
	
    	desktop->specific_data = (void *) desktop_data;

    	return True;
}

Bool if_le_CloseDesktop(iml_desktop_t * desktop)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) desktop->specific_data;

    	DEBUG_printf("if_le_CloseDesktop()\n");
    	free(desktop_data);

    	return True;
}

Bool if_le_CreateSC(iml_session_t *s, IMArgList args, int num_args)
{
	int i, nProtocol_Type, nClient_Type;
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
    	MyDataPerSession *session_data = (MyDataPerSession *) calloc(1, sizeof(MyDataPerSession));

    	DEBUG_printf("if_le_CreateSC()\n");

	desktop_data->pCurrentSession = 0;
	session_data->tPaletteAux_Status.nXPos = 0;
	session_data->tPaletteAux_Status.nYPos = 0;
	session_data->tPaletteAux_Status.bShow = False;
	session_data->tPaletteAux_Status.nInputMode_ID = 0xff;
    
	session_data->tKeyboardAux_Status.nXPos = 0;
	session_data->tKeyboardAux_Status.nYPos = 0;
	session_data->tKeyboardAux_Status.bShow = False;
	session_data->tKeyboardAux_Status.nKeyboard_ID = 0xff;
	session_data->tKeyboardAux_Status.nKeyStatus = 0;

	session_data->tOptionAux_Status.bShow = False;

	/* Allocate memory for input method session context */
    	s->specific_data = (void*) session_data;

	/* set aux proxy data */
	nProtocol_Type = UNKNOWN_IMP;
	nClient_Type = UNKNOWN_CLIENT;
	for (i = 0; i < num_args; i++, args++) {
		switch (args->id) {
			case UI_PROTOCOL_TYPE:
				if (args->value) {
					DEBUG_printf("UI_PROTOCOL_TYPE: value: %s\n", args->value);
					if (!strcmp (UI_PROTOCOL_TYPE_XIMP, args->value))
						nProtocol_Type = XIMP;
				}
				break;
			case UI_CLIENT_TYPE:
				if (args->value) {
					DEBUG_printf("UI_CLIENT_TYPE: value: %s\n", args->value);
					if (!strcmp (UI_CLIENT_TYPE_X, args->value))
						nClient_Type = X11_CLIENT;
				}
				break;
		}
	}

	if (nProtocol_Type == XIMP && nClient_Type == X11_CLIENT)
		if (desktop_data->pRootSession == 0)
			desktop_data->pRootSession = s;

    	return True;
}

Bool if_le_DestroySC(iml_session_t * s)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
    	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

    	DEBUG_printf("if_le_DestroySC(s=%x)\n", s);

	if (session_data->tPaletteAux_Status.bShow) {
		session_data->tPaletteAux_Status.bShow = False;
		le_change_focus_notify(s);
	}

	desktop_data->pCurrentSession = 0;
    	free((char *) session_data);

	if (desktop_data->pRootSession == s)
		desktop_data->pRootSession = 0;

    	return True;
}

Bool if_le_GetSCValue(iml_session_t * s, IMArgList args, int num_args)
{
    	DEBUG_printf("if_le_GetSCValue(s=%x)\n\n", s);
    	return True;
}

Bool if_le_SetSCValue(iml_session_t * s, IMArgList args, int num_args)
{
    	int i;
    	IMArg *p = args;
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

    	DEBUG_printf("if_le_SetSCValue(), s:0x%x\n", s);

	desktop_data->pCurrentSession = s;

    	for (i = 0; i < num_args; i++, p++) {
        	switch (p->id) {
            		case SC_TRIGGER_ON_NOTIFY:
				DEBUG_printf("SC_TRIGGER_ON_NOTIFY\n");
				proc_key_switch_conversion_event(s, CONVERSION_ON);
                		break;
                
            		case SC_TRIGGER_OFF_NOTIFY:
				DEBUG_printf("SC_TRIGGER_OFF_NOTIFY\n");
				proc_key_switch_conversion_event(s, CONVERSION_OFF);
                		break;
                
            		case SC_REALIZE:
				DEBUG_printf("SC_REALIZE, pRootSession:0x%x\n", 
					desktop_data->pRootSession);

				le_start_paletteaux(s);
				le_status_draw(s);
				le_change_focus_notify(s);
                		break;

            		default:
                		break;
            	}
    	}
    	return True;
}

IMText *if_le_ResetSC(iml_session_t * s)
{
    	DEBUG_printf("if_le_ResetSC(s=%x)\n\n", s);
    	return (IMText *) NULL;
}

void if_le_SetSCFocus(iml_session_t * s)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

    	DEBUG_printf("if_le_SetSCFocus() s:%x, pCurrentSession:%x\n", s, desktop_data->pCurrentSession);

	desktop_data->pCurrentSession = s;

	le_status_draw(s);
	le_change_focus_notify(s);
}

void if_le_UnsetSCFocus(iml_session_t * s)
{
    	DEBUG_printf("if_le_UnsetSCFocus() s:%x\n", s);
}

void if_le_SendEvent(iml_session_t * s, IMInputEvent * ev)
{
    	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
	iml_session_t *s1;

    	DEBUG_printf("if_le_SendEvent session=%x\n", s);
    	if (ev) {
        	if (ev->type == IM_EventKeyList) {
			DEBUG_printf("Keyboard Event\n");
			proc_key_event(s, (IMKeyListEvent *)ev);
        	} else if (ev->type == IM_EventAux) {
			DEBUG_printf("Aux Event\n");
			s1 = desktop_data->pCurrentSession;
			if (!s1) s1 = s;
			proc_aux_event(s1, (IMAuxEvent *)ev);
        	} 
    	}
}

