/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <glib.h>
#include <signal.h>
#include <wait.h>
#include <sys/types.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "pixmap.h"
#include "hzinput.h"
#include "UtilityConfig.h"

#define		DEFAULT_FONT_DESC	     "Sans 10"

PangoFontDescription *default_font_desc      = 0;

GdkColor	_normal_bg;
GdkColor	_normal_text;
GdkColor	_active_bg;
GdkColor	_active_text;
 
GdkDisplay *	_current_display             = 0;
GdkScreen *	_current_screen              = 0;

GtkWidget *	_toolbar_window              = 0;
GtkWidget *	_status_button               = 0;
GtkWidget *	_full_width_punct_button     = 0;
GtkWidget *	_full_width_letter_button    = 0;
GtkWidget *	_virtual_keyboard_button     = 0;
GtkWidget *	_utility_button    = 0;

GtkWidget *     _ime_list_menu               = 0;
GtkWidget *     _utility_list_menu         = 0;

GtkTooltips *	_tooltips                    = 0;

gboolean	_toolbar_window_draging      = FALSE;
gint		_toolbar_window_drag_x       = 0;
gint		_toolbar_window_drag_y       = 0;

gint		_toolbar_window_pos_x 	     = 0;
gint		_toolbar_window_pos_y 	     = 0;

gboolean	_toolbar_window_show_status  = FALSE;
gboolean	_full_width_punct_status     = FALSE;
gboolean	_full_width_letter_status    = FALSE;

static void utility_register_signal_child_handler();
static void utility_signal_child_handler(int sig, siginfo_t * info, void * ucontext);

extern GdkFilterReturn xaux_ext_event_handler(GdkXEvent *gdk_xevent, 
                                      GdkEvent *event, gpointer user_data);

extern IMEListRec       AllIMEList, SelectedIMEList;
extern int              gUtilitiesNum;
extern Utility_Item     *gUtilitiesItem[];

int
ui_screen_width (void)
{
    return gdk_screen_width ();
}
                                                                                                                  
int
ui_screen_height (void)
{
    return gdk_screen_height ();
}

static GdkPixbuf *
ui_scale_pixbuf (GdkPixbuf *pixbuf,
                 int        width,
                 int        height)
{
    if (pixbuf) {
        if (gdk_pixbuf_get_width (pixbuf) != width ||
            gdk_pixbuf_get_height (pixbuf) != height) {
            GdkPixbuf *dest = gdk_pixbuf_scale_simple (pixbuf, width, height, GDK_INTERP_BILINEAR);
            gdk_pixbuf_unref (pixbuf);
            pixbuf = dest;
        }
    }
    return pixbuf;
}

static GtkWidget *
ui_create_icon_from_xpm (const char **xpm,
                         int          width,
                         int          height,
                         gboolean     force_create)
{
    GdkPixbuf *pixbuf = gdk_pixbuf_new_from_xpm_data (xpm);
                                                                                                                  
    if (!pixbuf && !force_create)
         return 0;
                                                                                                                  
    if (!pixbuf) {
        if (width <= 0 || height <= 0)
            return 0;
                                                                                                                  
        pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, width, height);
                                                                                                                  
        if (!pixbuf)
            return 0;
                                                                                                                  
        gdk_pixbuf_fill (pixbuf, 0);
    }
                                                                                                                  
    if (width <= 0) width = gdk_pixbuf_get_width (pixbuf);
    if (height <= 0) height = gdk_pixbuf_get_height (pixbuf);
                                                                                                                  
    pixbuf = ui_scale_pixbuf (pixbuf, width, height);
                                                                                                                  
    GtkWidget *icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_widget_show (icon);
                                                                                                                  
    gdk_pixbuf_unref (pixbuf);
                                                                                                                  
    return icon;
}

GtkWidget *ui_create_letter_icon(gboolean full_width_letter_status)
{
    GtkWidget *image;
    const char **xpm;

    if (full_width_letter_status == TRUE)
        xpm = (const char **)fullwidth_xpm;
    else
        xpm = (const char **)halfwidth_xpm;

    image = ui_create_icon_from_xpm(xpm, -1, -1, 1);
    return(image);
}

GtkWidget *ui_create_punct_icon(gboolean full_width_punct_status)
{
    GtkWidget *image;
    const char **xpm;

    if (full_width_punct_status == TRUE)
        xpm = (const char **)ch_punct_xpm;
    else
        xpm = (const char **)en_punct_xpm;

    image = ui_create_icon_from_xpm(xpm, -1, -1, 1);
    return(image);
}

void ui_toggle_letter(gboolean full_width_letter_status)
{
    if (_full_width_letter_status == full_width_letter_status)
        return;

    _full_width_letter_status = full_width_letter_status;

    GtkWidget *image;
                                                                                                 
    image = gtk_bin_get_child (GTK_BIN (_full_width_letter_button));
    gtk_container_remove (GTK_CONTAINER (_full_width_letter_button), image);
                                                                                                 
    image = ui_create_letter_icon (_full_width_letter_status);
    gtk_container_add (GTK_CONTAINER (_full_width_letter_button), image);
                                                                                                 
    if (_toolbar_window_show_status)
        gtk_widget_show (_full_width_letter_button);
}

void ui_toggle_punct(gboolean full_width_punct_status)
{
    if (_full_width_punct_status == full_width_punct_status)
        return;

    _full_width_punct_status = full_width_punct_status;

    GtkWidget *image;
                                                                                                 
    image = gtk_bin_get_child (GTK_BIN (_full_width_punct_button));
    gtk_container_remove (GTK_CONTAINER (_full_width_punct_button), image);
                                                                                                 
    image = ui_create_punct_icon (_full_width_punct_status);
    gtk_container_add (GTK_CONTAINER (_full_width_punct_button), image);
                                                                                                 
    if (_toolbar_window_show_status)
        gtk_widget_show (_full_width_punct_button);
}

void ui_toolbar_window_set_position (gint pos_x, gint pos_y)
{
    GtkRequisition ws;

    gtk_widget_size_request (_toolbar_window, &ws);
                                                                                                         
    if (pos_x <= 0) {
        pos_x = ui_screen_width () - 190;
    } else if (pos_x + ws.width > ui_screen_width ()) {
        pos_x = ui_screen_width () - ws.width;
    }

    if (pos_y <= 0) {
        pos_y = ui_screen_height () - 66;
    } else if (pos_y + ws.height > ui_screen_height ()) {
        pos_y = ui_screen_height () - ws.height;
    }
                                                                                                                  
    if (_toolbar_window_pos_x != pos_x || _toolbar_window_pos_y != pos_y) {
        gtk_window_move (GTK_WINDOW (_toolbar_window), pos_x, pos_y);
        _toolbar_window_pos_x = pos_x;
        _toolbar_window_pos_y = pos_y;
    }
}

void ui_change_ime(int nIME_id_new, gboolean bNeedNotifyLE)
{
    int nEngineID, nIME_Num;
    char *pIME_Name;

    DEBUG_printf("PaletteAux_ChangeIME: change to ime:%d\n", nIME_id_new);
    nIME_Num = SelectedIMEList.nIME_Num;
                                                                                                        
    if (nIME_Num <= 0) return;
    if (nIME_id_new < 0) return;
    if (nIME_id_new >= nIME_Num) return;
                                                                                                        
    if (bNeedNotifyLE) {
        PaletteAux_Switch_LE_Engine_Request(nIME_id_new);
        return;
    }

    pIME_Name = (char *)SelectedIMEList.arrIME_Base[nIME_id_new]->cname;
    gtk_label_set_text (GTK_LABEL(GTK_BIN (_status_button)->child), pIME_Name);

    ui_toolbar_window_set_position (_toolbar_window_pos_x, _toolbar_window_pos_y);
    return;
}

static void
gtk_item_factory_menu_pos (GtkMenu  *menu,
                           gint     *x,
                           gint     *y,
                           gboolean *push_in,
                           gpointer  func_data)
{
    GtkWidget *_button_widget = (GtkWidget *)func_data;
    GtkRequisition size_menu, size_widget;
    gint menu_pos_x, menu_pos_y;

    gtk_widget_size_request ((GtkWidget *)menu, &size_menu);

    if (_toolbar_window_pos_y - size_menu.height > 0) {
        menu_pos_y = _toolbar_window_pos_y - size_menu.height;
    } else {
        gtk_widget_size_request ((GtkWidget *)_toolbar_window, &size_widget);
        menu_pos_y = _toolbar_window_pos_y + size_widget.height;
    }

    menu_pos_x = _toolbar_window_pos_x + _button_widget->allocation.x;

    *x = menu_pos_x;
    *y = menu_pos_y;
}

static gint ui_status_button_click_cb( GtkWidget *widget,
                          GdkEvent *event )
{
    if (_ime_list_menu == 0) return TRUE;

    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event;

        gtk_menu_popup (GTK_MENU (_ime_list_menu), NULL, NULL, 
                        gtk_item_factory_menu_pos, _status_button,
                        bevent->button, bevent->time);
        /* Tell calling code that we have handled this event; the buck
         * stops here. */
        return TRUE;
    }
                                                                                                     
    /* Tell calling code that we have not handled this event; pass it on. */
    return FALSE;
}
                                                                                                     
                                                                                                     
static void ime_menuitem_response(gpointer data)
{
    int ime_id = GPOINTER_TO_INT(data);

    DEBUG_printf("ime_menuitem_response: data: %d, ime_id: %d\n", data, ime_id);
    ui_change_ime(ime_id, TRUE);
}

static gint ui_utility_button_click_cb( GtkWidget *widget,
                          GdkEvent *event )
{
    if (_utility_list_menu == 0) return TRUE;

    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event;

        gtk_menu_popup (GTK_MENU (_utility_list_menu), NULL, NULL, 
                        gtk_item_factory_menu_pos, _utility_button,
                        bevent->button, bevent->time);
        /* Tell calling code that we have handled this event; the buck
         * stops here. */
        return TRUE;
    }
                                                                                                     
    /* Tell calling code that we have not handled this event; pass it on. */
    return FALSE;
}
                                                                                                     
void utility_register_signal_child_handler()
{
    struct sigaction act;
                                                                                                                         
    act.sa_handler = NULL;
    act.sa_sigaction = utility_signal_child_handler;
    sigfillset(&act.sa_mask);
    act.sa_flags = SA_SIGINFO;
                                                                                                                         
    sigaction(SIGCHLD, &act, NULL);
}
                                                                                                                         
void utility_signal_child_handler(int sig, siginfo_t * info, void * ucontext)
{
    pid_t   pid;
    int     status;
                                                                                                                     
    while ((pid = waitpid(info->si_pid, &status, WNOHANG|WUNTRACED)) > 0) {
        printf("pid %d: die\n", pid);
    }
}
                                                                                                                         
static void utility_menuitem_response(gpointer data)
{
    int utility_id = GPOINTER_TO_INT(data);

    DEBUG_printf("utility_menuitem_response: data: %d, utility_id: %d\n", data, utility_id);
    int pid;
    char *command_str;

    if (utility_id < 0 || utility_id >= gUtilitiesNum) return;

    utility_register_signal_child_handler();
                                                                                                                         
    pid = fork();
    if (pid < 0) {
        return;
    } else if (pid == 0) {
        /* in child process */
        command_str = (char *)gUtilitiesItem[utility_id]->command_str;
        execl("/bin/sh", "sh", "-c", command_str, (char *)0);

        /* Exec failed. */
        fprintf (stderr, "Error: Could not exec %s!\n", command_str);
        _exit(1);
    }
    return;
}

GtkWidget *ui_create_IME_list_menu()
{
    GtkWidget *menu;
    GtkWidget *menuitem;

    char buf[256];

    int i, nIME_Num;
                                                                                                                             
    nIME_Num = SelectedIMEList.nIME_Num;
    if (nIME_Num <= 0) return NULL;

    menu = gtk_menu_new();

    for(i = 0; i < nIME_Num; i ++) {
        if (SelectedIMEList.arrIME_Base[i]->status == ENGINE_NOT_INSTALLED) continue;

	sprintf(buf, " %s ", (char *)SelectedIMEList.arrIME_Base[i]->cname);
        menuitem = gtk_menu_item_new_with_label(buf);
	gtk_widget_modify_font (GTK_BIN (menuitem)->child, default_font_desc);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
        g_signal_connect_swapped(G_OBJECT(menuitem), "activate",
		G_CALLBACK(ime_menuitem_response), (gpointer)i );
	gtk_widget_show(menuitem);
    }

    gtk_widget_show(menu);
    _ime_list_menu = menu;
    return(menu);
}

GtkWidget *ui_create_utility_list_menu()
{
    GtkWidget *menu;
    GtkWidget *menuitem;

    char buf[256];

    int i, nUtilities_Num;
                                                                                                                             
    nUtilities_Num = gUtilitiesNum;
    if (nUtilities_Num <= 0) return NULL;

    menu = gtk_menu_new();

    for(i = 0; i < nUtilities_Num; i ++) {
	sprintf(buf, " %s ", (char *)gUtilitiesItem[i]->label_str);
        menuitem = gtk_menu_item_new_with_label(buf);
	gtk_widget_modify_font (GTK_BIN (menuitem)->child, default_font_desc);
        gtk_menu_shell_append(GTK_MENU_SHELL(menu), menuitem);
        g_signal_connect_swapped(G_OBJECT(menuitem), "activate",
		G_CALLBACK(utility_menuitem_response), (gpointer)i );
	gtk_widget_show(menuitem);
    }

    gtk_widget_show(menu);
    _utility_list_menu = menu;
    return(menu);
}

static gint ui_full_width_punct_button_click_cb( GtkWidget *widget,
                          GdkEvent *event )
{
    gboolean full_width_punct_status = !_full_width_punct_status;

    ui_toggle_punct(full_width_punct_status);
    PaletteAux_Switch_LE_Punct_Request(full_width_punct_status);
}

static gint ui_full_width_letter_button_click_cb( GtkWidget *widget,
                          GdkEvent *event )
{
    gboolean full_width_letter_status = !_full_width_letter_status;

    ui_toggle_letter(full_width_letter_status);
    PaletteAux_Switch_LE_QjBj_Request(full_width_letter_status);
}

static gboolean
ui_toolbar_window_motion_cb (GtkWidget *window,
                             GdkEventMotion *event,
                             gpointer user_data)
{
    gint pos_x, pos_y;
    if ((event->state & (GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GDK_BUTTON3_MASK)) != 0 &&
        _toolbar_window_draging) {
        gtk_window_get_position (GTK_WINDOW (window), &pos_x, &pos_y);
        ui_toolbar_window_set_position(
            pos_x + ((gint) event->x_root - _toolbar_window_drag_x),
            pos_y + ((gint) event->y_root - _toolbar_window_drag_y));

        _toolbar_window_drag_x = (gint) event->x_root;
        _toolbar_window_drag_y = (gint) event->y_root;
                                                                                                          
        return TRUE;
    }
    return FALSE;
}
                                                                                                          
static gboolean
ui_toolbar_window_click_cb (GtkWidget *window,
                            GdkEventButton *event,
                            gpointer user_data)
{
    int click_type = GPOINTER_TO_INT (user_data);
    static gulong motion_handler;
    GdkCursor *cursor;
                                                                                                          
    if (click_type == 0 && event->button <= 1) {
        if (_toolbar_window_draging)
            return FALSE;
                                                                                                          
        // Connection pointer motion handler to this window.
        motion_handler = g_signal_connect (G_OBJECT (window), "motion-notify-event",
                                           G_CALLBACK (ui_toolbar_window_motion_cb),
                                           NULL);
                                                                                                          
        _toolbar_window_draging = TRUE;
        _toolbar_window_drag_x = (gint) event->x_root;
        _toolbar_window_drag_y = (gint) event->y_root;
                                                                                                          
        cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
                                                                                                          
        // Grab the cursor to prevent losing events.
        gdk_pointer_grab (window->window, TRUE,
                          (GdkEventMask) (GDK_BUTTON_RELEASE_MASK | GDK_POINTER_MOTION_MASK),
                          NULL, cursor, event->time);
        gdk_cursor_unref (cursor);
        return TRUE;
    } else if (click_type == 1 && event->button <= 1) {
        if (!_toolbar_window_draging)
            return FALSE;
                                                                                                          
        g_signal_handler_disconnect (G_OBJECT (window), motion_handler);
        gdk_pointer_ungrab (event->time);
        _toolbar_window_draging = FALSE;
	PaletteAux_Change_LE_Position_Request(_toolbar_window_pos_x, _toolbar_window_pos_y);
                                                                                                          
        return TRUE;
    } else if (click_type == 1 && event->button > 1) {
        return TRUE;
    }
    return FALSE;
}

int main(int argc, char **argv)
{
    gtk_init (&argc, &argv);

#if 0
    /* init threads */
    g_thread_init (NULL);
    gdk_threads_init ();
#endif

    // Read configurations.
    gdk_color_parse ("gray92",     &_normal_bg);
    gdk_color_parse ("black",      &_normal_text);
    gdk_color_parse ("light blue", &_active_bg);
    gdk_color_parse ("black",      &_active_text);

    _current_display = gdk_display_get_default ();
    _current_screen  = gdk_display_get_default_screen (_current_display);
  
    default_font_desc = pango_font_description_from_string (DEFAULT_FONT_DESC);                                                                                                     
    //Create toolbar window
    {
        GtkWidget *handle;
        GtkWidget *hbox;
        GtkWidget *frame;
        GtkWidget *image;
        GtkRequisition size;
                                                                                                          
        _toolbar_window = gtk_window_new (GTK_WINDOW_POPUP);
        gtk_window_set_policy (GTK_WINDOW (_toolbar_window), TRUE, TRUE, FALSE);
        gtk_window_set_resizable (GTK_WINDOW (_toolbar_window), FALSE);
        gtk_widget_add_events (_toolbar_window,GDK_BUTTON_PRESS_MASK);
        gtk_widget_add_events (_toolbar_window,GDK_BUTTON_RELEASE_MASK);
        gtk_widget_add_events (_toolbar_window,GDK_POINTER_MOTION_MASK);
        g_signal_connect (G_OBJECT (_toolbar_window), "button-press-event",
                          G_CALLBACK (ui_toolbar_window_click_cb),
                          GINT_TO_POINTER (0));
        g_signal_connect (G_OBJECT (_toolbar_window), "button-release-event",
                          G_CALLBACK (ui_toolbar_window_click_cb),
                          GINT_TO_POINTER (1));
                                                                                                          
        frame = gtk_frame_new (0);
        gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_OUT);
        gtk_container_add (GTK_CONTAINER (_toolbar_window), frame);
                                                                                                          
        hbox = gtk_hbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame), hbox);

        image = ui_create_icon_from_xpm ((const char **)move_xpm, -1, -1, 1);
        gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
                                                                                                          
        //New status button.
        _status_button = gtk_button_new_with_label ("NoIME");
	gtk_widget_modify_font (GTK_BIN (_status_button)->child, default_font_desc);
        gtk_button_set_relief (GTK_BUTTON (_status_button), GTK_RELIEF_NONE);
        gtk_box_pack_start (GTK_BOX (hbox), _status_button, TRUE, TRUE, 0);
        g_signal_connect_swapped (G_OBJECT (_status_button), "button_press_event",
                          G_CALLBACK (ui_status_button_click_cb),
                          NULL);

        //New full_width_letter button
        image = ui_create_letter_icon(_full_width_letter_status);;
        gtk_widget_size_request (image, &size);
        _full_width_letter_button = gtk_button_new ();
        gtk_button_set_relief (GTK_BUTTON (_full_width_letter_button), GTK_RELIEF_NONE);
        gtk_container_add (GTK_CONTAINER (_full_width_letter_button), image);
        gtk_widget_set_size_request (_full_width_letter_button, size.width + 4, size.height + 3);
        gtk_box_pack_start (GTK_BOX (hbox), _full_width_letter_button, TRUE, TRUE, 0);
        g_signal_connect (G_OBJECT (_full_width_letter_button), "clicked",
                          G_CALLBACK (ui_full_width_letter_button_click_cb),
                          0);
                                                                                                          
        //New full_width_punctuation button
        image = ui_create_punct_icon(_full_width_punct_status);;
        gtk_widget_size_request (image, &size);
        _full_width_punct_button = gtk_button_new ();
        gtk_button_set_relief (GTK_BUTTON (_full_width_punct_button), GTK_RELIEF_NONE);
        gtk_container_add (GTK_CONTAINER (_full_width_punct_button), image);
        gtk_widget_set_size_request (_full_width_punct_button, size.width + 4, size.height + 3);
        gtk_box_pack_start (GTK_BOX (hbox), _full_width_punct_button, TRUE, TRUE, 0);
        g_signal_connect (G_OBJECT (_full_width_punct_button), "clicked",
                          G_CALLBACK (ui_full_width_punct_button_click_cb),
                          0);
                                                                                                         
        //New keyboard button
/*
        image = ui_create_icon_from_xpm ((const char **)keyboard_xpm, -1, -1, 1);
        gtk_widget_size_request (image, &size);
        _virtual_keyboard_button = gtk_button_new ();
        gtk_button_set_relief (GTK_BUTTON (_virtual_keyboard_button), GTK_RELIEF_NONE);
        gtk_container_add (GTK_CONTAINER (_virtual_keyboard_button), image);
        gtk_widget_set_size_request (_virtual_keyboard_button, size.width + 4, size.height + 3);
        gtk_box_pack_start (GTK_BOX (hbox), _virtual_keyboard_button, TRUE, TRUE, 0);
        g_signal_connect (G_OBJECT (_virtual_keyboard_button), "clicked",
                          G_CALLBACK (ui_virtual_keyboard_button_click_cb),
                          0);
*/
                                                                                                         
        //New properties setting button
        image = ui_create_icon_from_xpm ((const char **)options_xpm, -1, -1, 1);
        gtk_widget_size_request (image, &size);
        _utility_button = gtk_button_new ();
        gtk_button_set_relief (GTK_BUTTON (_utility_button), GTK_RELIEF_NONE);
        gtk_container_add (GTK_CONTAINER (_utility_button), image);
        gtk_widget_set_size_request (_utility_button, size.width + 4, size.height + 3);
        gtk_box_pack_start (GTK_BOX (hbox), _utility_button, TRUE, TRUE, 0);
        g_signal_connect_swapped (G_OBJECT (_utility_button), "button_press_event",
                          G_CALLBACK (ui_utility_button_click_cb),
                          NULL);
                                                                                                         

	/* Create Utilities Menu List */
        Utilities_Init();
        ui_create_utility_list_menu();

	_toolbar_window_show_status = TRUE;
                                                                                                         
        ui_toolbar_window_set_position(0, 0);
        gtk_widget_show_all (_toolbar_window);
	gtk_widget_hide(_toolbar_window);
    }
                                                                                                         
    // Init the tooltips
    {
        _tooltips = gtk_tooltips_new ();
                                                                                                         
        gtk_tooltips_set_delay (_tooltips, 1000);
                                                                                                         
        gtk_tooltips_set_tip (_tooltips, _status_button,
                              "Click to move the toolbar",
                              NULL);
                                                                                                         
        gtk_tooltips_set_tip (_tooltips, _full_width_punct_button,
                              "Click to toggle between half and full punctuation",
                              NULL);
                                                                                                         
        gtk_tooltips_set_tip (_tooltips, _full_width_letter_button,
                              "Click to toggle between half and full letter status",
                              NULL);
                                                                                                         
    }

    gdk_window_add_filter(_toolbar_window->window, xaux_ext_event_handler, 0);
    xaux_ext_register_classes(_toolbar_window->window);    

#if 0
    gdk_threads_enter ();
#endif
    gtk_main ();
#if 0
    gdk_threads_leave ();
#endif

    if (default_font_desc)
        pango_font_description_free (default_font_desc);
                                                                                                         
}
