/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/* 
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */
#include <stdio.h>

#include "hzinput.h"
#include "codetable.h"
#include "dayi_im.h"
#include "dayi_data.h"

int  dayi_SetOptions(IMECore, char *);
int  dayi_SetValues(IMECore, IMEArgList, int);
int  dayi_Init(IMECore);
int  dayi_Open(IMECore, IMEBuffer);
int  dayi_Filter(IMECore, IMEKey, IMEArgList, IMEBuffer);
void dayi_Close(IMECore);

#ifdef	WIN32
#define EXPORT extern __declspec(dllexport)
EXPORT
#endif

/* IF Method */
IMEMethodsRec ime_methods = {
	dayi_SetOptions,
	dayi_SetValues,
	dayi_Init,
	dayi_Open,
	dayi_Filter,
	dayi_Close,
	NULL,
	NULL,
	NULL
};

/* Set options for codetable input method. */
int dayi_SetOptions(IMECore core, char *options)
{
	return (0);
}

int dayi_SetValues(IMECore core, IMEArgList arglist, int option_value)
{
	int i;
	char **args_name, *lang_name;

	DEBUG_printf("dayi_SetValues === \n");

	if (arglist == NULL) return(-1);

	lang_name = core->envinfo.lang_name;

	arglist->args_num = DAYI_ARGS_NUM;

	i = KEYBYKEY_MODE_ID;
	arglist->args[i].name = NULL;
	arglist->args[i].value = 0;
	arglist->args[i].type = 1;

	i = HELPINFO_MODE_ID;
	arglist->args[i].name = dayi_args_name_TW[i];
	arglist->args[i].value = 0;
	arglist->args[i].type = 1;

	i = AUTOSELECT_MODE_ID;
	arglist->args[i].name = dayi_args_name_TW[i];
	arglist->args[i].value = 1;
	arglist->args[i].type = 1;

	i = KEYPROMPT_MODE_ID;
	arglist->args[i].name = dayi_args_name_TW[i];
	arglist->args[i].value = 1;
	arglist->args[i].type = 1;

	if (option_value != -1) {
		int cur_bit_pos, cur_bit_len, mask, j;

		cur_bit_pos = 0;
		for (i = 0; i < arglist->args_num; i++) {
			if (arglist->args[i].name == NULL)
				continue;

			cur_bit_len = arglist->args[i].type;
			mask = 0;
			for (j=0; j<cur_bit_len; j++)
				mask |= (1<<j);
			arglist->args[i].value = (option_value >> cur_bit_pos) & mask;
			cur_bit_pos += cur_bit_len;
		}
	}

	return(0);
}

/* return the Chinese name and encode status and status of codetable IME */
int dayi_Init(IMECore core)
{
	int  		i, ret;
	char		file_name[256];
	TDayiData	*pDayiData;

	DEBUG_printf("dayi_Init ====\n");

	pDayiData = (TDayiData *)calloc(1, sizeof(TDayiData));
	if (pDayiData == NULL)
		return(-1);

	sprintf(file_name, "/usr/lib/im/locale/%s/common/dayi.cfg", core->envinfo.lang_name);
	ret = DayiData_Init(file_name, pDayiData);
	if (ret == DAYI_ERROR) {
		DayiData_Free(pDayiData);
		return (-1);
	}

	/* Return Information that needed by Input Method Manager */
	/* Such as Encode, Cname, Status */
	core->baseinfo.status = ENGINE_NOT_INITIATED;
	core->baseinfo.cname = (char *)strdup(pDayiData->pCodetableHeader->Cname);
	core->baseinfo.encode_id = pDayiData->pCodetableHeader->Encode;

	core->envinfo.data_ptr = (char *)pDayiData;
	
	return(0);
}


/* Load the codetable file int memory */
int dayi_Open(IMECore core, IMEBuffer ime_buffer)
{
	char		*file_name;
	int		i, ret;

	TDayiData	*pDayiData;
	CodeTableStruct *ctHeader;

	DEBUG_printf("dayi_Open ==== \n");

	ime_buffer->encode = 0;
	ime_buffer->return_status = 0;
	ime_buffer->preedit_len = 0;
	ime_buffer->commit_len  = 0;
	ime_buffer->lookup_num  = 0;
	ime_buffer->inputkey_len  = 0;
	ime_buffer->cur_lookup_pos = 0;

	if (core->baseinfo.status == ENGINE_NOT_INSTALLED)
        	return(-1);

	if (core->baseinfo.status == ENGINE_INITIATED)
		return 0;

	/* if IME engine is not initiated, would malloc dictionary buffer */

	core->baseinfo.status == ENGINE_NOT_INSTALLED;

	pDayiData = (TDayiData *)(core->envinfo.data_ptr);
	ret = DayiData_Open(pDayiData);
	if (ret == DAYI_ERROR) {
		return(-1);
	}

	core->baseinfo.status = ENGINE_INITIATED;

	/* if exist keymap setting */
	ctHeader = pDayiData->pCodetableHeader;
	if (GETBIT(ctHeader->bSectionsFlag, KEYPROMPT_SECTION)) {
		core->keymapinfo.bSet = 1;
		for (i=0; i<MAX_KEYMAP_KEY_NUM; i++) {
			core->keymapinfo.keymap[i] = (char *) strdup(ctHeader->keyprompt[i+0x20].prompt);
		}
	}

	return(0);
}

/* close IME, and free codetable pointers */
void dayi_Close(IMECore core)
{
	TDayiData	*pDayiData;
	int		i;

	DEBUG_printf("dayi_Close ==== \n");

	pDayiData = (TDayiData *)(core->envinfo.data_ptr);
	DayiData_Free(pDayiData);
	free((char *)pDayiData);

	if (core->baseinfo.cname)
		free((char *)core->baseinfo.cname);

	if (core->envinfo.data_path)
		free((char *)core->envinfo.data_path);

	if (core->keymapinfo.bSet == 1) {
		for (i=0; i<MAX_KEYMAP_KEY_NUM; i++) {
			if (core->keymapinfo.keymap[i])
				free((char *)core->keymapinfo.keymap[i]);
		}
	}
}

/* process key input event */
/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return this key to systerm directly */
/*                IME_USED_KEY:      if IME has used this key */
int  dayi_Filter(IMECore core, IMEKey  key_event, IMEArgList ime_args, IMEBuffer ime_buffer)
{
	int 		ret;
	TDayiData	*pDayiData;
	CodeTableStruct *ctHeader;
	IMEArgListRec  	real_ime_args;

	DEBUG_printf("dayi_Filter ==== \n");

	if (core->baseinfo.status != ENGINE_INITIATED)
		return(IME_NOT_USED_KEY);
		
	/* set ctHeader's argument setting */
	
	/* ctHeader's argument setting are always coveried by user defined data */
	pDayiData = (TDayiData *)(core->envinfo.data_ptr);

	/* if no user defined arguments, set with system arguments */
	ctHeader = pDayiData->pCodetableHeader;
	ctHeader->Output_Encode = core->envinfo.output_encode_id;
	ctHeader->nKeyByKeyMode = 0;
	ctHeader->nHelpInfoMode = 0;
	ctHeader->nAutoSelectMode = 1;
	ctHeader->nKeyPromptMode = 1;

	if (ime_args != NULL && ime_args->args_num > 0) {
		/* if has user defined arguments, set with user defined arguments */
		ctHeader->nHelpInfoMode = ime_args->args[HELPINFO_MODE_ID].value;
		ctHeader->nAutoSelectMode = ime_args->args[AUTOSELECT_MODE_ID].value;
		ctHeader->nKeyPromptMode = ime_args->args[KEYPROMPT_MODE_ID].value;
	}
		
	ret = dayi_filter(pDayiData, key_event, ime_buffer);
	return(ret);
}

