#ifndef __CHAR_TABLE_H__
#define __CHAR_TABLE_H__


G_BEGIN_DECLS
#define CHARTABLE_TYPE (chartable_get_type ())
#define CHARTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHARTABLE_TYPE, CharTable))
#define CHARTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHARTABLE_TYPE, CharTableClass))
#define IS_CHARTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHARTABLE_TYPE))
#define IS_CHARTABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHARTABLE_TYPE))
#define CHARTABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHARTABLE_TYPE, CharTableClass))

typedef struct _CharTable CharTable;
typedef struct _CharTableClass CharTableClass;

struct _CharTable
{
  GtkHBox parent;
  GdkPixmap *pixmap;
  GtkWidget *drawingarea;

  GtkObject *adjustment;
  gulong adjustment_changed_handler_id;
  
  guint _begin;
  guint _end;
  guint ncols;
  guint nrows;
  gchar *font_name;
  PangoFontMetrics *font_metrics;
  PangoLayout *pango_layout;
};

struct _CharTableClass
{
  GtkHBoxClass parent_class;
};

GtkWidget *chartable_new (void);
GtkWidget *chartable_new_with_range (guint begin, guint end);
void chartable_set_begin (CharTable *table, guint begin);
void chartable_set_end (CharTable *table, guint begin);



G_END_DECLS  
#endif
