/* $Id: im-aux-value.c,v 1.1.1.1 2002/08/31 04:18:05 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_aux_value_new(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card32	class_index,
    IIIMP_string *	input_method_name,
    IIIMP_card32_list *	integer_value,
    IIIMP_string *	string_value)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = opcode;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.aux_value.class_index = class_index;
    m->v.aux_value.input_method_name = input_method_name;
    m->v.aux_value.integer_value = integer_value;
    m->v.aux_value.string_value = string_value;
    return m;
}


void
iiimp_aux_value_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    if (NULL == m) return;
    iiimp_string_delete(data_s, m->v.aux_value.input_method_name);
    iiimp_card32_list_delete(data_s, m->v.aux_value.integer_value);
    iiimp_string_list_delete(data_s, m->v.aux_value.string_value);
    free(m);
    return;
}


uchar_t *
iiimp_aux_value_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card32	class_index,
    IIIMP_string *	input_method_name,
    IIIMP_card32_list *	integer_value,
    IIIMP_string *	string_value,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;
    size_t		integer_value_nbyte;
    size_t		string_value_nbyte;
    IIIMP_string *	s;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* input context id */
    nbyte += 4;	/* auxiliary window class index */
    nbyte += input_method_name->nbyte;	/* input method name */
    nbyte += 4;	/* byte length of integer value list */
    integer_value_nbyte = ((NULL != integer_value) ? integer_value->nbyte : 0);
    nbyte += integer_value_nbyte;	/* integer value list */
    nbyte += 4;	/* byte length of string value list */
    string_value_nbyte = 0;
    for (s = string_value; NULL != s; s = s->next) {
	string_value_nbyte += s->nbyte;
    }
    nbyte += string_value_nbyte;	/* string value list */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, opcode, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU32(class_index, rest, p, data_s->byte_swap);
    iiimp_string_pack(data_s, input_method_name, &rest, &p);
    PUTU32(integer_value_nbyte, rest, p, data_s->byte_swap);
    iiimp_card32_list_pack(data_s, integer_value, &rest, &p);
    PUTU32(string_value_nbyte, rest, p, data_s->byte_swap);
    iiimp_string_list_pack(data_s, string_value, &rest, &p);

    return buf;
}


IIIMP_message *
iiimp_aux_value_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *	m;
    IIIMP_aux_value_v *	v;
    size_t		rest;
    const uchar_t *	p;
    int			len;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 4 + 4)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.aux_value);

    m->opcode = opcode;
    v->input_method_name = NULL;
    v->integer_value = NULL;
    v->string_value = NULL;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GETU32(v->class_index, rest, p, data_s->byte_swap);

    m->opcode = opcode;

    v->input_method_name = iiimp_string_unpack(data_s, &rest, &p, rest);
    if (NULL == v->input_method_name) {
	free(m);
	return NULL;
    }

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	iiimp_aux_value_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    if (0 < len) {
	v->integer_value = iiimp_card32_list_unpack(data_s, &rest, &p, len);
	if (NULL == v->integer_value) {
	    iiimp_aux_value_delete(data_s, m);
	    return NULL;
	}
    }

    GET32(len, rest, p, data_s->byte_swap);
    if ((len < 0) || (rest < len)) {
	iiimp_aux_value_delete(data_s, m);
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    if (0 < len) {
	v->string_value = iiimp_string_list_unpack(data_s, &rest, &p, len);
	if (NULL == v->string_value) {
	    iiimp_aux_value_delete(data_s, m);
	    return NULL;
	}
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_aux_value_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    IIIMP_aux_value_v *	v;
    IIIMP_string *	s;

    v = &(m->v.aux_value);
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tindex=%d name=", v->class_index);
    iiimp_string_print(data_s, v->input_method_name);
    (void)fputc('\n', data_s->print_fp);
    iiimp_card32_list_print(data_s, v->integer_value);
    for (s = v->string_value; NULL != s; s = s->next) {
	(void)fprintf(data_s->print_fp, "       *");
	iiimp_string_print(data_s, s);
	(void)fputc('\n', data_s->print_fp);
    }
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
