/* $Id: im-lookup-choice-process.c,v 1.1.1.1 2002/08/31 04:18:06 himi Exp $ */


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"
#include "print-misc.h"


IIIMP_message *
iiimp_lookup_choice_process_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16	type,
    IIIMP_card16	value)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_LOOKUP_CHOICE_PROCESS;
    m->im_id = im_id;
    m->ic_id = ic_id;
    m->v.lookup_choice_process.type = type;
    m->v.lookup_choice_process.value = value;
    return m;
}


void
iiimp_lookup_choice_process_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
    if (NULL == m) return;
    free(m);
    return;
}


uchar_t *
iiimp_lookup_choice_process_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	ic_id,
    IIIMP_card16	type,
    IIIMP_card16	value,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0;
    nbyte += 2;	/* input method id */
    nbyte += 2;	/* input context id */
    nbyte += 2;	/* type */
    nbyte += 2;	/* INDEX or PAGE */

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_LOOKUP_CHOICE_PROCESS, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(ic_id, rest, p, data_s->byte_swap);
    PUTU16(type, rest, p, data_s->byte_swap);
    PUTU16(value, rest, p, data_s->byte_swap);

    return buf;
}


IIIMP_message *
iiimp_lookup_choice_process_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_lookup_choice_process_v *	v;
    size_t				rest;
    const uchar_t *			p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 2 + 2)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.lookup_choice_process);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    GETU16(m->ic_id, rest, p, data_s->byte_swap);
    GETU16(v->type, rest, p, data_s->byte_swap);
    switch (v->type) {
    case IM_LOOKUP_CHOICE_PROCESS_INDEX: /* INDEX */
	GET16(v->value, rest, p, data_s->byte_swap);
	break;
    case IM_LOOKUP_CHOICE_PROCESS_PAGE: /* PAGE */
    default:
	GETU16(v->value, rest, p, data_s->byte_swap);
	break;
    }

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_lookup_choice_process_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    IIIMP_lookup_choice_process_v *	v;

    v = &(m->v.lookup_choice_process);
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    switch (v->type) {
    case IM_LOOKUP_CHOICE_PROCESS_INDEX: /* index of selected choice */
	(void)fprintf(data_s->print_fp, "index=%d", v->value);
	break;
    case IM_LOOKUP_CHOICE_PROCESS_PAGE: /* page change */
	(void)fprintf(data_s->print_fp, "%s (%d)",
		      lookup_choice_process_page_string_get(v->value),
		      v->value);
	break;
    default:
	(void)fprintf(data_s->print_fp, "unknown operation type");
    }
    (void)fputc('\n', data_s->print_fp);
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
