/* $Id: request-reply.c,v 1.1.1.1 2002/08/31 04:18:02 himi Exp $ */


#include <stdlib.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp.h>

#include "request-reply.h"
#include "input-method.h"
#include "input-context.h"
#include "stream.h"
#include "opcode-reply.h"
#include "sequence.h"


static uchar_t *
message_reply_pack_nop(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(im, ic, opcode, m, nbyte))
#endif /* lint && HAVE_NOTE_H */
    return NULL;
}


static uchar_t *
message_simple_im_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(ic, m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_simple_pack(im->data_s, opcode, im->im_id, 0, nbyte);
}


static uchar_t *
message_simple_ic_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_simple_pack(im->data_s, opcode, im->im_id, ic->ic_id, nbyte);
}


static uchar_t *
message_im_connect_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(ic, opcode, m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_connect_reply_pack(im->data_s, im->im_id, im->language_list,
				    nbyte);
}


static uchar_t *
message_im_getimvalues_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(ic, opcode, m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_getimvalues_reply_pack(im->data_s, im->im_id, NULL, nbyte);
}


static uchar_t *
message_im_forward_event_with_operations_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(opcode, m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_forward_event_with_operations_reply_pack(im->data_s, im->im_id,
							  ic->ic_id, NULL,
							  nbyte);
}


static uchar_t *
message_im_geticvalues_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(opcode, m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_geticvalues_reply_pack(im->data_s, im->im_id, ic->ic_id, NULL,
					nbyte);
}


static uchar_t *
message_preedit_start_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(opcode, m))
#endif /* lint && HAVE_NOTE_H */
    return iiimp_preedit_start_reply_pack(im->data_s, im->im_id, ic->ic_id,
					  ic->preedit_maximum_length, nbyte);
}


static uchar_t *
message_aux_simple_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
    return iiimp_aux_simple_pack(im->data_s, opcode, im->im_id, ic->ic_id,
				 m->v.aux_simple.class_index,
				 m->v.aux_simple.input_method_name, nbyte);
}

static uchar_t *
message_aux_value_reply_pack(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    int			opcode,
    IIIMP_message *	m,
    size_t *		nbyte)
{
    return iiimp_aux_value_pack(im->data_s, opcode, im->im_id, ic->ic_id,
				m->v.aux_value.class_index,
				m->v.aux_value.input_method_name,
				m->v.aux_value.integer_value,
				m->v.aux_value.string_value,
				nbyte);
}

typedef uchar_t *	(* IIIMP_message_reply_pack_func)(
				IIIMF_im *	im,
				IIIMF_ic *	ic,
				int		opcode,
				IIIMP_message *	m,
				size_t *	nbyte);


static IIIMP_message_reply_pack_func message_reply_pack_func[] = {
	message_reply_pack_nop,		/* 0 */

	message_reply_pack_nop,		/* IM_CONNECT */
	message_im_connect_reply_pack,	/* IM_CONNECT_REPLY */
	message_reply_pack_nop,		/* IM_DISCONNECT */
	message_simple_im_reply_pack,	/* IM_DISCONNECT_REPLY */
	message_reply_pack_nop,		/* IM_REGISTER_TRIGGER_KEYS */
	message_reply_pack_nop,		/* IM_TRIGGER_NOTIFY */
	message_simple_ic_reply_pack,	/* IM_TRIGGER_NOTIFY_REPLY */
	message_reply_pack_nop,		/* IM_SETIMVALUES */
	message_simple_im_reply_pack,	/* IM_SETIMVALUES_REPLY */
	message_reply_pack_nop,		/* IM_GETIMVALUES */
	message_im_getimvalues_reply_pack,
					/* IM_GETIMVALUES_REPLY */

	message_reply_pack_nop,		/* IM_FORWARD_EVENT */
	message_simple_ic_reply_pack,	/* IM_FORWARD_EVENT_REPLY */
	message_reply_pack_nop,		/* IM_COMMIT_STRING */
	message_reply_pack_nop,		/* IM_FORWARD_EVENT_WITH_OPERATIONS */
	message_im_forward_event_with_operations_reply_pack,
				  /* IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY */

	message_reply_pack_nop,		/* 17 */
	message_reply_pack_nop,		/* 18 */
	message_reply_pack_nop,		/* 19 */

	message_reply_pack_nop,		/* IM_CREATEIC */
	message_simple_im_reply_pack,	/* IM_CREATEIC_REPLY */
	message_reply_pack_nop,		/* IM_DESTROYIC */
	message_simple_ic_reply_pack,	/* IM_DESTROYIC_REPLY */
	message_reply_pack_nop,		/* IM_SETICVALUES */
	message_simple_ic_reply_pack,	/* IM_SETICVALUES_REPLY */
	message_reply_pack_nop,		/* IM_GETICVALUES */
	message_im_geticvalues_reply_pack,
					/* IM_GETICVALUES_REPLY */
	message_reply_pack_nop,		/* IM_SETICFOCUS */
	message_simple_ic_reply_pack,	/* IM_SETICFOCUS_REPLY */
	message_reply_pack_nop,		/* IM_UNSETICFOCUS */
	message_simple_ic_reply_pack,	/* IM_UNSETICFOCUS_REPLY */
	message_reply_pack_nop,		/* IM_RESETIC */
	message_simple_ic_reply_pack,	/* IM_RESETIC_REPLY */

	message_reply_pack_nop,		/* 34 */
	message_reply_pack_nop,		/* 35 */
	message_reply_pack_nop,		/* 36 */
	message_reply_pack_nop,		/* 37 */
	message_reply_pack_nop,		/* 38 */
	message_reply_pack_nop,		/* 39 */

	message_reply_pack_nop,		/* IM_PREEDIT_START */
	message_preedit_start_reply_pack,
					/* IM_PREEDIT_START_REPLY */
	message_reply_pack_nop,		/* IM_PREEDIT_DRAW */
	message_simple_ic_reply_pack,	/* IM_PREEDIT_DRAW_REPLY */
	message_reply_pack_nop,		/* 44 */
	message_reply_pack_nop,		/* 45 */
	message_reply_pack_nop,		/* IM_PREEDIT_DONE */
	message_simple_ic_reply_pack,	/* IM_PREEDIT_DONE_REPLY */

	message_reply_pack_nop,		/* 48 */
	message_reply_pack_nop,		/* 49 */

	message_reply_pack_nop,		/* IM_STATUS_START */
	message_simple_ic_reply_pack,	/* IM_STATUS_START_REPLY */
	message_reply_pack_nop,		/* IM_STATUS_DRAW */
	message_simple_ic_reply_pack,	/* IM_STATUS_DRAW_REPLY */
	message_reply_pack_nop,		/* IM_STATUS_DONE */
	message_simple_ic_reply_pack,	/* IM_STATUS_DONE_REPLY */

	message_reply_pack_nop,		/* 56 */
	message_reply_pack_nop,		/* 57 */
	message_reply_pack_nop,		/* 58 */
	message_reply_pack_nop,		/* 59 */
	message_reply_pack_nop,		/* 60 */
	message_reply_pack_nop,		/* 61 */
	message_reply_pack_nop,		/* 62 */
	message_reply_pack_nop,		/* 63 */
	message_reply_pack_nop,		/* 64 */
	message_reply_pack_nop,		/* 65 */
	message_reply_pack_nop,		/* 66 */
	message_reply_pack_nop,		/* 67 */
	message_reply_pack_nop,		/* 68 */
	message_reply_pack_nop,		/* 69 */

	message_reply_pack_nop,		/* IM_LOOKUP_CHOICE_START */
	message_simple_ic_reply_pack,	/* IM_LOOKUP_CHOICE_START_REPLY */
	message_reply_pack_nop,		/* IM_LOOKUP_CHOICE_DRAW */
	message_simple_ic_reply_pack,	/* IM_LOOKUP_CHOICE_DRAW_REPLY */
	message_reply_pack_nop,		/* IM_LOOKUP_CHOICE_DONE */
	message_simple_ic_reply_pack,	/* IM_LOOKUP_CHOICE_DONE_REPLY */
	message_reply_pack_nop,		/* IM_LOOKUP_CHOICE_PROCESS */
	message_simple_ic_reply_pack,	/* IM_LOOKUP_CHOICE_PROCESS_REPLY */

	message_reply_pack_nop,		/* 78 */
	message_reply_pack_nop,		/* 79 */
	message_reply_pack_nop,		/* 80 */
	message_reply_pack_nop,		/* 81 */
	message_reply_pack_nop,		/* 82 */
	message_reply_pack_nop,		/* 83 */
	message_reply_pack_nop,		/* 84 */
	message_reply_pack_nop,		/* 85 */
	message_reply_pack_nop,		/* 86 */
	message_reply_pack_nop,		/* 87 */
	message_reply_pack_nop,		/* 88 */
	message_reply_pack_nop,		/* 89 */

	message_reply_pack_nop,		/* IM_AUX_START */
	message_aux_simple_reply_pack,	/* IM_AUX_START_REPLY */
	message_reply_pack_nop,		/* IM_AUX_DRAW */
	message_aux_simple_reply_pack,	/* IM_AUX_DRAW_REPLY */
	message_reply_pack_nop,		/* IM_AUX_DONE */
	message_aux_simple_reply_pack,	/* IM_AUX_DONE_REPLY */
	message_reply_pack_nop,		/* IM_AUX_SETVALUES */
	message_aux_simple_reply_pack,	/* IM_AUX_SETVALUES_REPLY */
	message_reply_pack_nop,		/* IM_AUX_GETVALUES */
	message_aux_value_reply_pack,	/* IM_AUX_GETVALUES_REPLY */

	message_reply_pack_nop,		/* 100 */
	message_reply_pack_nop,		/* 101 */
	message_reply_pack_nop,		/* 102 */
	message_reply_pack_nop,		/* 103 */
	message_reply_pack_nop,		/* 104 */
	message_reply_pack_nop,		/* 105 */
	message_reply_pack_nop,		/* 106 */
	message_reply_pack_nop,		/* 107 */
	message_reply_pack_nop,		/* 108 */
	message_reply_pack_nop,		/* 109 */
	message_reply_pack_nop,		/* 110 */
	message_reply_pack_nop,		/* 111 */
	message_reply_pack_nop,		/* 112 */
	message_reply_pack_nop,		/* 113 */
	message_reply_pack_nop,		/* 114 */
	message_reply_pack_nop,		/* 115 */
	message_reply_pack_nop,		/* 116 */
	message_reply_pack_nop,		/* 117 */
	message_reply_pack_nop,		/* 118 */
	message_reply_pack_nop,		/* 119 */
	message_reply_pack_nop,		/* 120 */
	message_reply_pack_nop,		/* 121 */
	message_reply_pack_nop,		/* 122 */
	message_reply_pack_nop,		/* 123 */
	message_reply_pack_nop,		/* 124 */
	message_reply_pack_nop,		/* 125 */
	message_reply_pack_nop,		/* 126 */
	message_reply_pack_nop		/* 127 */
};


IIIMF_status
iiimf_request_reply(
    IIIMF_im *		im,
    IIIMF_ic *		ic,
    IIIMP_message *	message_original)
{
    IIIMF_status	status;
    uchar_t *		message;
    size_t		nbyte;
    int			opcode;
    IIIMP_message	message_dummy;

    opcode = iiimf_opcode_reply_internal(message_original->opcode);
    if (IM_NOP == opcode) return IIIMF_STATUS_SUCCESS;

    message_dummy.opcode = opcode;
    message_dummy.length = 8;
    message_dummy.im_id = message_original->im_id;
    message_dummy.ic_id = message_original->ic_id;
    status = iiimf_message_sequence(im, ic, &message_dummy,
				    IIIMF_MESSAGE_ATTR_SEND);
    if (IIIMF_STATUS_SUCCESS != status) {
	if (IIIMF_STATUS_SEQUENCE_REQUEST == status) {
	    return IIIMF_STATUS_SUCCESS;
	} else {
	    return status;
	}
    }

    message = message_reply_pack_func[opcode](im, ic, opcode, message_original,
					      &nbyte);
    if (NULL == message) return IIIMF_STATUS_FAIL;

    status = im->stream->proc_write(im->stream->private_data, message, nbyte);

    free(message);

    return status;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
