<?php

require_once 'include/i18n.php';

function SetupStyle()
{
  print '<link href="'.Config::AbsLoc('style.css').'" rel="stylesheet" type="text/css">';

}

// Parse a provided URL and add the extra arguments given as an assoc. array
function appendURLArguments($baseURL, $newargs)
{
	preg_match('/^([^?]+)\??(.*)$/', $baseURL, $matches);
	$URL = $matches[1];
	parse_str($matches[2], $argarray);
	foreach ($newargs as $f => $v)
	{
		$argarray[$f] = $v;
	}

	// Now reassemble
	$args = array();
	foreach ($argarray as $f => $v)
	{
		$args[] = urlencode($f)."=".urlencode($v);
	}
	
	return $URL . "?" . join('&', $args);
}

function commonHeader($title) 
{
	global $IRMName, $bgcd, $bgcl;

	$LOGO = Config::Get('logo');
	if (Config::Get('sendexpire')) {
		header("Expires: Fri, Jun 12 1981 08:20:00 GMT\nPragma: no-cache");
	}
	PRINT "<!-- IRM is (c) 1999-2004 Yann Ramin, Keith Schoenefeld, and others -->\n";
	PRINT "<!-- Yann Ramin atrus@atrustrivalie.org -->\n";
	PRINT "<!-- Keith Schoenefeld keith-p@schoenefeld.org -->\n";
	PRINT "<!-- Some code is (c) 1999 Brandon Neill bneill@learn2.com	-->\n";
	PRINT "<!-- http://www.stackworks.net/irm/ -->\n";
	PRINT "<HTML>\n";
	PRINT "<HEAD>\n";
	PRINT "<TITLE>IRM: $title</TITLE>\n";
	if (Config::Get('sendexpire'))
	{
		PRINT "<META HTTP-EQUIV=\"Expires\" CONTENT=\"Fri, Jun 12 1981 08:20:00 GMT\">\n";
		PRINT "<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">\n";
		PRINT "<META HTTP-EQUIV=\"Cache-Control\" CONTENT=\"no-cache\">\n";
	}
	SetupStyle();
	PRINT "</HEAD>\n";
	PRINT "<BODY>\n";

	PRINT "<!-- Main Information -->\n";
	PRINT "<BR>\n";
	PRINT "<TABLE CELLSPACING=0 BORDER=0 WIDTH=100%>\n";
	PRINT "<TR HEIGHT=20 $bgcd>";

	$user = new User($IRMName);
	$usertype = $user->getType();

	$userbase = Config::AbsLoc('users');

	PRINT '<TD class="nav">';
	if($usertype == "tech" || $usertype == "admin")
	{
		PRINT "<A HREF=\"$userbase/computers-index.php\">";
		PRINT _("Computers")."</A> |";
		PRINT "<A HREF=\"$userbase/networking-index.php\">";
		PRINT _("Networking")." </A> | <A HREF=\"$userbase/software-index.php\">";
		PRINT _("Software")."</A> | ";
	}
	PRINT "<A HREF=\"$userbase/tracking-index.php\">"._("Tracking")."</A> | ";
	if($usertype == "tech" || $usertype == "admin")
	{
		if(Config::Get('fasttrack'))
		{
			PRINT "<A HREF=\"$userbase/tracking-fasttrack-autofill.php\">";
			PRINT _("FastTrack")."</A> | ";
		}
		PRINT "<A HREF=\"$userbase/reports-index.php\">";
		PRINT _("Reports")."</A> | ";
	}
	PRINT "<A HREF=\"$userbase/helper.php\">";
	PRINT "		"._("Request Help")."</A> |";
	if ($usertype == "tech" || $usertype == "admin")
	{
		PRINT "<A HREF=\"$userbase/setup-index.php\">";
		PRINT "		"._("Setup")."</A> | <A HREF=\"$userbase/prefs-index.php\">";
		PRINT "		"._("Preferences")."</A> | ";
		if(Config::Get('knowledgebase'))
		{
			PRINT "<A HREF=\"$userbase/knowledgebase-index.php\">";
			PRINT _("Knowledge Base")."</A> | ";
		}
	}
	if (Config::Get('knowledgebase'))
	{
		PRINT "<A HREF=\"$userbase/faq-index.php\">";
		PRINT _("FAQ")."</A> | ";
	}
	PRINT "<A HREF=\"$userbase/logout.php\">";
	PRINT _("Logout")."</A></TD>";
	PRINT '<TD ALIGN="right" class="nav">';
	$datetime = date("M d H:i");
	PRINT $datetime;
	PRINT " </TD>\n";
	PRINT "</TR>\n";
	PRINT "</TABLE>\n";
	PRINT "  <A HREF=\"$userbase/index.php\">";
	PRINT '<IMG SRC="'.Config::AbsLoc($LOGO).'" BORDER=0 align=right class=graphic></A><BR>';
	PRINT "<h3> $title</h3>\n";
	PRINT "<HR NOSHADE>\n";
}

function commonFooter() 
{
?>
	<HR NOSHADE>
	<BR>
	</FONT>	
	<?php print "<i>"._("IRM Version")." <b>"; echo Config::Version(); ?></b>&nbsp;&nbsp;
	<A HREF="http://www.stackworks.net/irm/"><?php __("Website"); ?></A><BR />
<?php
	__("Distribution of IRM is permitted under the terms of the GNU GPL Version 2");
	__("Copyright &copy; 1999-2005 Yann Ramin, Keith Schoenefeld, and others");
?>
	</A>
	</BODY>
	</HTML>
<?php
}

function AuthCheck($authtype) 
{
	$username = @$_SESSION['_sess_username'];

	if (!$username)
	{
		$webroot = Config::AbsLoc('');
		$relpath = urlencode(ereg_replace("^$webroot", '', $_SERVER['REQUEST_URI']));
		$dest = Config::AbsLoc('index.php?auth=sess&redirect='.$relpath);
		header("Location: $dest");
		__("Session expired.  Returning you to the login page.");
		PRINT "(<a href=\"$dest\">$dest</a>)";
		exit;
	}
	
	$user = new User($username);
	$authorised = $user->permissionCheck($authtype);
	$type = $user->getType();
	
	if (!$authorised)
	{
		// If we got here, the user's level is lower than the required level.
		commonHeader(_("Permission Denied"));
		printf(_("You (%s) only have %s level privileges, but to access this function you need %s privileges.  Sorry."),
			$username, $type, $authtype);
		commonFooter();
		exit();
	}
}

function Dropdown($table,$myname) 
{
	if (!preg_match('/^[a-zA-Z0-9_]+$/', $table))
	{
		printf(_("ERROR: Illegal table name %s"), $table);
		echo "<br/>\n";
		return;
	}
	
	$DB = Config::Database();
	if (!preg_match('/^[a-zA-Z0-9_]+$/', $table))
	{
		trigger_error(sprintf(_("Dropdown(): Invalid table name: %s"), $table), E_USER_ERROR);
	}
	else
	{
		$result = $DB->getAll("SELECT * FROM $table ORDER BY name");
		PRINT "<SELECT NAME=\"$myname\" SIZE=1>";

		foreach ($result as $row)
		{
			$output = $row["name"];
			PRINT "<OPTION VALUE=\"$output\">$output</OPTION>";
		}

		PRINT "</SELECT>\n";
	}
}

function Dropdown_groups($table,$myname) 
{
	if (!preg_match('/^[a-zA-Z0-9_]+$/', $table))
	{
		trigger_error(sprintf(_("Dropdown_groups(): Illegal table name %s"), $table), E_USER_ERROR);
		return;
	}
	
	$DB = Config::Database();
	$result = $DB->getAll("SELECT * FROM $table ORDER BY name");
	PRINT "<SELECT NAME=\"$myname\" SIZE=1>";

	foreach ($result as $row)
	{
		$label = $row["name"];
		$key = $row['ID'];
		PRINT "<OPTION VALUE=\"$key\">$label</OPTION>";
	}

	PRINT "</SELECT>\n";
}

function Dropdown_value($table,$myname, $value) 
{
	if (!preg_match('/^[a-zA-Z0-9_]+$/', $table))
	{
		trigger_error(sprintf(_("Dropdown_groups(): Illegal table name %s"), $table), E_USER_ERROR);
		return;
	}
	
	$DB = Config::Database();
	$result = $DB->getAll("SELECT * FROM $table ORDER BY name");
	PRINT "<SELECT NAME=\"$myname\" SIZE=1>";

	foreach ($result as $row)
	{
		$label = $row["name"];
		if ($label == $value)
		{
			PRINT "<OPTION VALUE=\"$label\" SELECTED>$label</OPTION>";
		}
		else
		{
			PRINT "<OPTION VALUE=\"$label\">$label</OPTION>";
		}
	}

	PRINT "</SELECT>\n";
}

function showComputer($ID, $expand) 
{
	global $bgcd, $bgcl;
	$DB = Config::Database();
	
	$qID = $DB->getTextValue($ID);
	$query = "SELECT * FROM computers WHERE (ID = $qID)";

	$result = $DB->getRow($query);
    
	$name = $result["name"];
	$type = $result["type"];
	$os = $result["os"];
	$osver = $result["osver"];
	$processor = $result["processor"];
	$processor_speed = $result["processor_speed"];
	$location = $result["location"];
	$serial = $result["serial"];
	$otherserial = $result["otherserial"];
	$ramtype = $result["ramtype"];
	$ram = $result["ram"];
	$network = $result["network"];
	$ip = $result["ip"];
	$mac = $result["mac"];
	$hdspace = $result["hdspace"];
	$comments = $result["comments"];
	$contact = $result["contact"];
	$contact_num = $result["contact_num"];
	$date_mod = $result["date_mod"];
	$flags_server = $result["flags_server"];
	$flags_surplus = $result["flags_surplus"];
	
	$new_date = date("Y-m-d H:i:s");
	$comments = stripslashes($comments);

	$userbase = Config::AbsLoc('users');

	PRINT "<TABLE WIDTH=100% BORDER=1 noshade>
		<form method=post action=\"$userbase/computers-update.php\">
		<input type=hidden name=ID value=\"$ID\">
		<tr $bgcd><td colspan=2>
		<FONT face=\"Arial, Helvetica\">";
	
	if (Config::Get('snmp'))
	{
		if (Config::Get('snmp_ping'))
		{
			if ($ip != "" OR $ip != "DHCP" OR $ip != "dhcp")
			{
				$out = exec(EscapeShellCmd("ping -c 1 -n -i 1 -w 3 $ip"),$dummy_array, $ping_return);
			}
			if ($ping_return == 2)
			{
				$hstatus = "| "._("Host:")." <FONT COLOR=red>"._("DOWN")."</FONT>";
			}
			else if ($ping_return == 0)
			{
				$hstatus = "| "._("Host:")." <FONT COLOR=green>"._("UP")."</FONT>";
			}
			else
			{
				$hstatus = "| "._("Host: UNKNOWN ERROR");
			}
		}
		else
		{
			$hstatus = "| "._("Ping disabled");
		}
		$snmp_link = " | <A HREF=\"$userbase/snmp-stat.php?ID=$ID\">"._("Runtime Information (SNMP)")."</A> $hstatus";
	}
	else
	{
		$snmp_link = '';
	}
	if ($expand == 1)
		{
			PRINT "<strong>$name ($ID)</strong> 
		<A HREF=\"$userbase/helper-add.php?ID=$ID&is_group=no\">"._("Add Tracking")."</A>$snmp_link";
		} else if ($expand == 0) {
			PRINT "<strong><A HREF=\"$userbase/computers-info.php?ID=$ID\">$name 
		($ID)</strong></A> 
		<A HREF=\"$userbase/tracking-add-form.php?ID=$ID\">"._("Add Tracking")."</A>$snmp_link";
		}
	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Name:")."<BR><input type=text name=name value=\"$name\" 
		size=24></FONT></TD><TD><FONT face=\"Arial, Helvetica\">
		Type:<BR>";
	Dropdown_value("dropdown_type", "type", $type);
	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">"._("Location").":<BR>";
	Dropdown_value("dropdown_locations", "location", $location);
	PRINT "</FONT></TD><TD><FONT face=\"Arial, Helvetica\">"._("OS:")."<BR>";
	Dropdown_value("dropdown_os", "os", $os);
	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("OS Version").":<BR><input type=text size=5 name=osver 
		value=\"$osver\"></FONT></TD><TD><FONT face=\"Arial, 
		Helvetica\">"._("Processor").":<BR>";
	Dropdown_value("dropdown_processor", "processor", $processor);
	
	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Processor Speed").":<BR><input type=text name=processor_speed 
		size=4 value=\"$processor_speed\"></FONT></TD><TD>
		<FONT face=\"Arial, Helvetica\">"._("Serial Number").":<BR>
		<input type=text name=serial size=35 value=\"$serial\">
		</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Other Serial Number").":<BR><input type=text size=25 
		name=otherserial value=\"$otherserial\"></FONT></TD>
		<TD><FONT face=\"Arial, Helvetica\">"._("Hard Drive Space 
		(in gigabytes):")."<BR><input type=text name=hdspace size=5 
		value=\"$hdspace\"></FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">"._("RAM Type").":<BR>";
	Dropdown_value("dropdown_ram", "ramtype", $ramtype);
	PRINT "</FONT></TD><TD><FONT face=\"Arial, Helvetica\">".
		_("RAM Amount (in MB)").":<BR><input type=text name=ram 
		value=\"$ram\" size=5></FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Network Card Brand/Type").":<BR>";
	Dropdown_value("dropdown_network", "network", $network);
	PRINT "</FONT></TD><TD><FONT face=\"Arial, Helvetica\">".
		_("IP Address").":<BR><input type=text name=ip value=\"$ip\" 
		size=16></FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("MAC/Network Address").":<BR><input type=text name=mac 
		value=\"$mac\"></FONT></TD><TD>"._("Comments").":<BR><textarea 
		cols=20 rows=5 name=comments wrap=soft>$comments</textarea>
		</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Contact Person").":<BR><input type=text name=contact size=20 
		value=\"$contact\"></FONT></TD><TD><FONT face=\"Arial, 
		Helvetica\">"._("Contact Number").":<BR><input type=text 
		name=contact_num value=\"$contact_num\"></FONT></TD></TR>";
	PRINT "<tr $bgcl ><td colspan=2><FONT face=\"Arial, Helvetica\">
			Flags: ";
	if ($flags_server == 1) {
		PRINT "<INPUT TYPE=CHECKBOX NAME=flags_server VALUE=yes CHECKED>";
	} else {
		PRINT "<INPUT TYPE=CHECKBOX NAME=flags_server VALUE=yes>";
	}
	
	PRINT " "._("Server (constantly running)")."</FONT></TD></TR>";

	PRINT "<tr bgcolor=#DDDDDD><td colspan=2><font face=\"Arial, Helvetica\">
								Flags: ";
if ($flags_surplus == 1) {
				PRINT "<input type=checkbox name=flags_surplus value=yes CHECKED>";
	} else {
				PRINT "<input type=checkbox name=flags_surplus value=yes>";
	}
	PRINT " "._("Surplus")."</font></td></tr>";

	PRINT "<TR BGCOLOR=#DDDDD0><td colspan=2 align=center><FONT 
		face=\"Arial, Helvetica\">"._("Last Updated:")." $date_mod 
		<input type=hidden name=date_mod value=\"$new_date\"></TD>
		</TR>";
	PRINT "<tr $bgcd><TD><input type=submit value=\""._("Update")."\"></form>
		<form method=post action=\"$userbase/computers-del.php\">
		<input type=hidden name=ID value=$ID></TD><TD>
		<input type=submit value=\""._("Delete")."\"></form></TD></TR></TABLE>";
	PRINT "<BR>";
}


/* Added March 12th, 2001 (micajc)
 * This function attempts to find an lID of an unassigned 
 * license for the passed software ID. Remember
 * to lock the inst_software table if your going to use this
 * to assign a license.
 */
function find_license($ID, $lcnt_needed) {
	$DB = Config::Database();

	$qID = $DB->getTextValue($ID);

	$q = "SELECT software_licenses.ID AS lID,
		     (IF(software_licenses.entitlement,software_licenses.entitlement,0)
		       - IF(SUM(inst_software.lCnt),SUM(inst_software.lCnt),0))
		       AS available
		   FROM inst_software RIGHT JOIN software_licenses
		   		ON software_licenses.ID=inst_software.lID
		   WHERE software_licenses.sID=$qID
		   GROUP BY software_licenses.ID";

	$license_info = $DB->getAll($q);

	foreach ($license_info as $ld)
	{
		if ($ld['available'] >= $lcnt_needed)
		{
			return $ld['lID'];
		}
	}

	return NULL;
}

/* Modifyed March 8th, 2001 to reflect removal of some data items.
 * (micajc)
 */
function showSoftware($ID) 
{
	global $bgcl, $bgcd;
	$DB = Config::Database();

	$qID = $DB->getTextValue($ID);
	$query = "SELECT * FROM software WHERE (ID = $qID)";

	$result = $DB->getRow($query);
  	$name = $result["name"];
  	$platform = $result["platform"];
  	$package = $result['install_package'];
  	$comments = $result["comments"];
	$class = $result["class"];

	$comments = stripslashes($comments);
	PRINT "<TABLE WIDTH=100% BORDER=1 noshade>";
	PRINT '<form method=post action="'.Config::AbsLoc('users/software-update.php').'">';
	PRINT "<input type=hidden name=ID value=\"$ID\">
		<input type=hidden name=class value=\"$class\">
		<tr $bgcd><td colspan=2><FONT face=\"Arial, Helvetica\" size=+1>";

  PRINT "$class: $name ($ID)";
  PRINT "</FONT></TD></TR>";
  PRINT "<tr $bgcl ><TD><FONT face=\"Arial, 
		Helvetica\">"._("Name:")."<BR><input type=text name=name 
		value=\"$name\" size=24></FONT>
		<BR>".
		_("Location").":<BR>
		<input type=text name=package value=\"$package\" size=20></TD>
		<TD><FONT face=\"Arial, Helvetica\">"._("Platform:")."<BR>";

  Dropdown_value("dropdown_os", "platform", $platform);

  PRINT "</FONT></TD></TR>";

  PRINT "<tr $bgcl ><td VALIGN=TOP>Licenses: ";
  $licensed = Count_licenses($ID);
  $installed = Count_installations($ID);
  $remaining = $licensed - $installed;
  if ($remaining <= 0) {
		$remaining =  "<FONT COLOR=red>$remaining</FONT>";
  } 
	PRINT "<TABLE>
		<TR><TD>"._("Licenses:")."</TD><TD><B>$licensed</B></TD></TR>
		<TR><TD>"._("Installed:")."</TD><TD><B>$installed</b></TD></TR>
		<TR><TD>"._("Remaining:")."</TD><TD><B>$remaining</B></TD></TR>
		</TABLE>";

  PRINT "<TD><FONT face=\"Arial, 
		Helvetica\">"._("Comments").":<BR><textarea cols=80 rows=5 
		name=comments wrap=soft>$comments</textarea></FONT></TD></TR>";
  PRINT "<tr $bgcd><TD>
		<input type=submit value=\""._("Update")."\"></form></TD><TD>";
  PRINT '<form method=post action="'.Config::AbsLoc('users/software-del.php').'">';
  PRINT "<input type=submit value=\""._("Delete")."\" valign=top>
		<input type=hidden name=ID value=$ID>
		</form></TD></TR></TABLE>";
  PRINT "<BR>";
}


function showBundled($ID) { 
	global $bgcl, $bgcd;
	print "<B>"._("Software Bundle Information (\$numRows)")." </B>
				 <TABLE WIDTH=100% BORDER=1>
				<TR $bgcd><TD>"._("Software ID")."</TD><TD>"._("Name")."</TD></TR>
				<Form method=post  action=software-bundle-add-software.php>
				<input type=hidden name=bID value=$ID>
				<TR $bgcl><TD><input type=submit value=\""._("Add")."\"></TD><TD>"; 
		SoftwareDropdown("WHERE class!='Application Bundle'");
		print "</TD></TR></form>";

	$DB = Config::Database();

	$qID = $DB->getTextValue($ID);
	$query = "SELECT software_bundles.*,software.name FROM software_bundles
					LEFT JOIN software ON software.ID=sID
					WHERE software_bundles.bID=$qID ORDER by software.name";


	$data = $DB->getAll($query);

	foreach ($data as $result)
	{
		$sID=$result['sID'];
		$name=$result['name'];
		print "<TR $bgcl><TD>$sID</TD><TD>$name</TD></TR>";
	}

	print "</TABLE><BR>";
}

function showLicenses($ID) {
	global $bgcl, $bgcd;
	$DB = Config::Database();

	$qID = $DB->getTextValue($ID);
	$query = "SELECT * FROM software_licenses WHERE (sID = $qID) ORDER BY licensekey";

	$data = $DB->getAll($query);

	print "<TABLE WIDTH=100% BORDER=1>
		<TR $bgcd><TD><B>ID</B></TD>
			<TD><B>"._("License Key")."</B></TD>
			<TD><B>"._("Entitlement")."</B></TD>
			<TD><B>"._("Oem Sticker")."</B></TD></TR>";
	print "<TR $bgcl><Form method=post action=license-add.php>
		<input type=hidden name=sID value=$ID>
		<TD><input type=submit value=\""._("Add")."\"></TD>
		<TD><input type=text name=licensekey size=40></TD>
		<TD><input type=text name=entitlement size=4></TD>
		<TD><input type=checkbox name=oem_sticker></TD></TR>
		</form>
		<Form method=post action=license-del.php>";

	foreach ($data as $result)
	{
		$sID = $result['sID'];
		$lID = $result['ID'];
		$licensekey = $result['licensekey'];
		$entitlement = $result['entitlement'];
		$oem_sticker = $result['oem_sticker'];

		print "<TR $bgcl ><TD>
			<input type=radio name=lID value=$lID>$lID</TD>
			<TD>$licensekey</TD>
			<TD>$entitlement</TD>
			<TD>$oem_sticker</TD></TR>";
	}
	print "</TABLE>
	<input type=submit value=\""._("Del")."\"></form>";
}

function showNetworking($ID)
{
	global $bgcd, $bgcl;

	$DB = Config::Database();

	$qID = $DB->getTextValue($ID);
	$query = "SELECT * FROM networking WHERE (ID = $qID)";

	$result = $DB->getRow($query);

  	$name = $result["name"];
  	$type = $result["type"];
  	$ram = $result["ram"];
  	$serial = $result["serial"];
  	$otherserial = $result["otherserial"];
  	$location = $result["location"];
  	$ip = $result["ip"];
  	$mac = $result["mac"];
  	$datemod = $result["datemod"];
  	$contact = $result["contact"];
  	$contact_num = $result["contact_num"];
  	$comments = $result["comments"];

	$comments = stripslashes($comments);
	PRINT "<TABLE WIDTH=100% BORDER=1 noshade>";
	PRINT '<form method=post action="'.Config::AbsLoc('users/networking-update.php').'">';
	PRINT "<input type=hidden name=ID value=\"$ID\"><tr $bgcd>";
	PRINT '<td colspan=2><FONT face="Arial, Helvetica">';

	PRINT "<strong>$name ($ID)</strong>";
	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial,
		Helvetica\">"._("Name:")."<BR><input type=text name=name
		value=\"$name\" size=24></FONT></TD><TD><FONT face=\"Arial,
		 Helvetica\">"._("Type").":<BR>";

	Dropdown_value("dropdown_type", "type", $type);

	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Location").":<BR>";

	Dropdown_value("dropdown_locations", "location", $location);

	PRINT "</FONT></TD><TD>"._("RAM Amount (in MB)").": <BR><input type=text name=ram
		value=\"$ram\" size=5>";
	PRINT "</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD><FONT face=\"Arial, Helvetica\">".
		_("Serial Number").":<BR><input type=text name=serial size=35
		value=\"$serial\"></FONT></TD><TD><FONT face=\"Arial,
		Helvetica\">"._("Other Serial Number").":<BR><input type=text
		size=25 name=otherserial value=\"$otherserial\">
		</FONT></TD></TR>";
	PRINT "<tr $bgcl ><TD>IP:<BR><input type=text name=ip value=\"$ip\"
		size=20></TD><TD>"._("MAC/Network Address").":<BR><input type=text size=20 name=mac value=\"$mac\"></TD></TR>";
	PRINT "<tr $bgcl ><TD>"._("Contact:")."<BR><input type=text name=contact
		value=\"$contact\" size=20>";

	PRINT "</TD>";
	PRINT "<TD>"._("Contact Number").":<BR><input type=text name=contact_num size=20 value=\"$contact_num\"></TD></TR>";
	PRINT "<tr $bgcl ><td colspan=2><FONT face=\"Arial,
		Helvetica\">"._("Comments").":<BR><textarea cols=40 rows=5
		name=comments wrap=soft>$comments</textarea></FONT></TD></TR>";
	PRINT "<tr $bgcd ><TD><input type=submit value=\""._("Update")."\"></form>";
	PRINT '<form method=post action="'.Config::AbsLoc('users/networking-del.php').'">';
	PRINT "<input type=hidden name=ID value=$ID></TD><TD>
		<input type=submit value=\""._("Delete")."\"></form></TD></TR></TABLE>";
	PRINT "<BR>";
	showPortsOnDevice($ID, 2);
}

function Count_Installations($sID)
{
	$DB = Config::Database();
	
	$sID = $DB->getTextValue($sID);
	$query = "SELECT count(ID) AS cnt FROM inst_software 
		  WHERE (sID=$sID)";

	return $DB->getOne($query);
}

function Count_licenses($sID) 
{
	$DB = Config::Database();
	$sID = $DB->getTextValue($sID);
	$query = "SELECT SUM(entitlement) FROM software_licenses WHERE (sID = $sID)";

	return $DB->getOne($query);
}

function Checked($field)
{
  if (($field == "yes") || ($field == 1))
  {
    return("checked");
  } else
  {
    return("");
  }
}

function computerListView($compquery, $sort, $phrasetype) 
{
	global $IRMName, $field, $goto, $contains, $style, $bgcl, $bgcd;

	$DB = Config::Database();
	$uname = $DB->getTextValue($IRMName);

	$query = "SELECT * FROM prefs WHERE (user = $uname)";

	$result = $DB->getRow($query);
  	$stype = $result["type"];
  	$sos = $result["os"];
	$sosver = $result["osver"];
	$sprocessor = $result["processor"];
	$sprocessor_speed = $result["processor_speed"];
	$slocation = $result["location"];
	$sserial = $result["serial"];
	$sotherserial = $result["otherserial"];
	$sramtype = $result["ramtype"];
	$snetwork = $result["network"];
	$sram = $result["ram"];
	$sip = $result["ip"];  				
	$smac = $result["mac"];
	$shdspace = $result["hdspace"];  
	$scontact = $result["contact"];
	$scontact_num = $result["contact_num"];
	$scomments = $result["comments"];
	$sdate_mod = $result["date_mod"];

	$stype = Checked($stype);
	$sos = Checked($sos);
	$sosver = Checked($sosver);
	$sprocessor = Checked($sprocessor);
	$sprocessor_speed = Checked($sprocessor_speed);
	$slocation = Checked($slocation);
	$sserial = Checked($sserial);
	$sotherserial = Checked($sotherserial);
	$sramtype = Checked($sramtype);
	$sram = Checked($sram);
	$snetwork = Checked($snetwork);
	$sip = Checked($sip);
	$smac = Checked($smac);
	$shdspace = Checked($shdspace);
	$scontact = Checked($scontact);
	$scontact_num = Checked($scontact_num);
	$scomments = Checked($scomments);
	$sdate_mod = Checked($sdate_mod);
	
	PRINT "<TABLE BORDER=1 WIDTH=100%><tr $bgcd>";
	
	PRINT "<th>"._("Name")."</th>";
	  
	if ($stype == "checked") 
	{
		PRINT "<th>"._("Type")."</th>";
	}
	if ($sos == "checked") 
	{
		PRINT "<th>"._("Operating System")."</th>";
	}
	if ($sosver == "checked") 
	{
		PRINT "<th>"._("OS Version")."</th>";
	}
	if ($sprocessor == "checked") 
	{
		PRINT "<th>"._("Processor")."</th>";
	}
	if ($sprocessor_speed == "checked") 
	{
		PRINT "<th>"._("Processor Speed")."</th>";
	}
	if ($slocation == "checked") 
	{
		PRINT "<th>"._("Location")."</th>";
	}
	if ($sserial == "checked") 
	{
		PRINT "<th>"._("Serial Number")."</th>";
	}
	if ($sotherserial == "checked") 
	{
		PRINT "<th>"._("Other Serial")."</th>";
	}
	if ($sramtype == "checked") 
	{
		PRINT "<th>"._("RAM Type")."</th>";
	}
	if ($sram == "checked") 
	{
		PRINT "<th>"._("RAM")."</th>";
	}
	if ($snetwork == "checked") 
	{
		PRINT "<th>"._("Network")."</th>";
	}
	if ($sip == "checked")
	{
		PRINT "<th>"._("IP")."</th>";
	}
	if ($smac == "checked")
	{
		PRINT "<th>"._("MAC/Network Address")."</th>";
	}
	if ($shdspace == "checked") 
	{
		PRINT "<th>"._("HD Space")."</th>";
	}
	if ($scontact == "checked") 
	{
		PRINT "<th>"._("Contact Person")."</th>";
	}
	if ($scontact_num == "checked") 
	{
		PRINT "<th>"._("Contact Num.")."</th>";
	}
	if ($scomments == "checked") 
	{
		PRINT "<th>"._("Comments")."</th>";
	}
	if ($sdate_mod == "checked") 
	{
		PRINT "<th>"._("Date Modified")."</th>";
	}
		
	PRINT "</TR>";

	$data = $DB->getAll($compquery);
	// Chop off any records we want to skip
	$data = array_slice($data, $goto);
	if (count($data) > 25)
	{
		$nextpage = true;
		$data = array_slice($data, 0, 25);
	}
	else
	{
		$nextpage = false;
	}
	
	foreach ($data as $result)
	{
	    	$ID = $result["ID"];
	    	$name = $result["name"];
	    	$type = $result["type"];
	    	$os = $result["os"];
    		$osver = $result["osver"];
		$processor = $result["processor"];
	    	$processor_speed = $result["processor_speed"];
	    	$location = $result["location"];
	    	$serial = $result["serial"];
	    	$otherserial = $result["otherserial"];
	    	$ramtype = $result["ramtype"];
	    	$ram = $result["ram"];
	    	$network = $result["network"];
	    	$ip = $result["ip"];
	    	$mac = $result["mac"];
	    	$hdspace = $result["hdspace"];
	    	$comments = $result["comments"];
	    	$date_mod = $result["date_mod"];
	    	$contact = $result["contact"];
	    	$contact_num = $result["contact_num"];	
	    	$comments = $result['comments'];

	    	PRINT '<TR BGCOLOR=#DDDDDD><TD>';
	    	PRINT '<A HREF="'.Config::AbsLoc("users/computers-info.php?ID=$ID").'">';
		PRINT "$name ($ID)</A></TD>";
			
	    	if ($stype == "checked")
	    	{
		      	PRINT "<TD>$type</TD>";
    		}
	    	if ($sos == "checked")
	    	{
		      	PRINT "<TD>$os</TD>";
    		}
	    	if ($sosver == "checked")
	    	{
		      	PRINT "<TD>$osver</TD>";
	    	}
	    	if ($sprocessor == "checked") 
	    	{
		      	PRINT "<TD>$processor</TD>";
	    	}
	    	if ($sprocessor_speed == "checked")
	    	{
		      	PRINT "<TD>$processor_speed</TD>";
	    	}
	    	if ($slocation == "checked") 
	    	{
		      	PRINT "<TD>$location</TD>";
	    	}
	    	if ($sserial == "checked") 
	    	{
		      	PRINT "<TD>$serial</TD>";
    		}
	    	if ($sotherserial == "checked")
	    	{
		      	PRINT "<TD>$otherserial</TD>";
	    	}
	    	if ($sramtype == "checked") 
	    	{
		      	PRINT "<TD>$ramtype</TD>";
	    	}
	    	if ($sram == "checked") 
	    	{
		      	PRINT "<TD>$ram</TD>";
	    	}
	    	if ($snetwork == "checked") 
	    	{
		      	PRINT "<TD>$network</TD>";
	    	}
	    	if ($sip == "checked") 
	    	{
		      	PRINT "<TD>$ip</TD>";
	    	}
	    	if ($smac == "checked")
	    	{ 
	      		PRINT "<TD>$mac</TD>";
	    	}
	    	if ($shdspace == "checked")
	    	{
	      		PRINT "<TD>$hdspace</TD>";
	    	}
	    	if ($scontact == "checked") 
	    	{
	      		PRINT "<TD>$contact</TD>";
	    	}
	    	if ($scontact_num == "checked") 
	    	{
	      		PRINT "<TD>$contact_num</TD>";
	    	}
	    	if ($scomments == "checked") 
	    	{
	      		PRINT "<TD>$comments</TD>";
	    	}
	    	if ($sdate_mod == "checked") 
	    	{
	      		PRINT "<TD>$date_mod</TD>";
	    	}
				
    		PRINT "</TR>";
	}

	$backgoto = $goto - 25;
	$forgoto = $goto + 25;
	PRINT "</TABLE>";
	PRINT "<TABLE BORDER=0><TR><TD>";
	if ($backgoto > -1)
	{
		PRINT "<form><input type=hidden name=sort value=\"$sort\">
			<input type=hidden name=phrasetype value=\"$phrasetype\"> 
			<input type=hidden name=field value=\"$field\">
			<input type=hidden name=contains value=\"$contains\">
			<input type=hidden name=style value=\"$style\">
			<input type=hidden name=goto value=$backgoto>
			<input type=submit value=\""._("Previous 25")."\"></form>";
	}
	PRINT "</TD><TD>";

	if ($nextpage)
	{		
		PRINT "<form><input type=hidden name=sort value=\"$sort\">
			<input type=hidden name=phrasetype value=\"$phrasetype\"> 
			<input type=hidden name=field value=\"$field\">
			<input type=hidden name=contains value=\"$contains\">
			<input type=hidden name=style value=\"$style\">
			<input type=hidden name=goto value=$forgoto>
			<input type=submit value=\""._("Next 25")."\"></form>";
	}
	PRINT "</TD></TR></TABLE>";
}

function templcompsoftShow($showID)
{
	global $bgcl, $bgcd;

	$DB = Config::Database();
	$showID = $DB->getTextValue($showID);
	$query = "SELECT * FROM templ_inst_software WHERE (cID = $showID)";

	$data = $DB->getAll($query);

	PRINT "<TABLE BORDER=1 WIDTH=100%><TR $bgcd><th colspan=2>"._("Installed Software")."</th></TR>";
	foreach ($data as $result)
	{
		$sID = $result["sID"];
		$ID = $result["ID"];
		$qID = $DB->getTextValue($sID);
		$query = "SELECT * FROM software WHERE (ID = $qID)";
		$result2 = $DB->getRow($query);
		$name = $result2["name"];

		PRINT "<tr $bgcl ><TD><i>";
		PRINT '<A HREF="'.Config::AbsLoc("users/software-info.php?ID=$sID").'">';
		PRINT "$name</A></i></TD><td WIDTH=10%>";
		PRINT '<A HREF="'.Config::AbsLoc("users/setup-templates-software-del.php?ID=$ID").'">['._("Delete").']</A></TD></TR>';
	}
	
	PRINT "<tr $bgcd><TD>";
	PRINT '<form method=post action="'.Config::AbsLoc('users/setup-templates-software-add.php').'">';
	PRINT "<input type=hidden name=cID value=$showID>"._("Add software:");
	SoftwareDropdown();
	PRINT " "._("to template.")."</TD><TD><input type=submit value=\""._("Add")."\"></form></TD></TR>";
	PRINT "</TABLE>";
}

function compsoftShow($showID) 
{
	global $bgcl, $bgcd;
	$DB = Config::Database();

	$qID = $DB->getTextValue($showID);
	$query = "SELECT inst_software.ID AS ID,
			inst_software.sID AS sID,
			inst_software.lCnt AS lCnt,
			software.name AS name,
			software_licenses.ID AS lID,
			software_licenses.licensekey AS licensekey
			FROM (inst_software
				INNER JOIN software
					ON inst_software.sID=software.ID)
				LEFT JOIN software_licenses
					ON inst_software.lID=software_licenses.ID
			WHERE (inst_software.cID = $qID)
			ORDER BY software.class, software.name";

	$data = $DB->getAll($query);

	PRINT "<TABLE BORDER=1 WIDTH=100%>\n<TR BGCOLOR=#BBBBB>\n<th colspan=3>"._("Installed Software")."</th>\n</TR>\n";
		
	foreach ($data as $result)
	{
		$sID = $result["sID"];
		$ID = $result["ID"];
		$lID = $result['lID'];
		$slots = $result["lCnt"];
		$name = $result['name'];
		$key = $result['licensekey'];
		
		if ($lID === NULL)
		{
			$key = '<font color="red">'._("license key not found").'</font>';
		}
		
		PRINT "<tr $bgcl>\n<TD><i>";
		PRINT '<A HREF="'.Config::AbsLoc("users/software-info.php?ID=$sID").'">';
		PRINT "$name</A></i>, ".sprintf(_("%s license(s)."), $slots)."</TD>\n";
		PRINT "<td>$key</td>\n";
		PRINT "<td WIDTH=10%>";
		PRINT '<A HREF="'.Config::AbsLoc("users/computers-software-del.php?ID=$ID")."\">["._("Delete")."]</A></TD>\n</TR>\n";
	}
	PRINT "<tr $bgcd>\n<TD COLSPAN=2>";
	PRINT '<form method=post action="'.Config::AbsLoc('users/computers-software-add.php').'">';
	PRINT "<input type=hidden name=cID value=$showID>"._("Add software")." ";
	SoftwareDropdown();
	PRINT " "._("to computer, using")." <input type=\"text\" name=\"reqdliccnt\" size=\"3\" value=\"1\"> "._("license(s).")."</TD><TD><input type=submit value=\""._("Add")."\"></form></TD></TR>";
	PRINT "</TABLE>";
}

function SoftwareDropdown($where = "")
{
	$query = "SELECT name,ID FROM software $where ORDER BY name";

	$DB = Config::Database();
	$data = $DB->getAll($query);

	PRINT "<SELECT NAME=sID SIZE=1>\n";

	foreach ($data as $result) 
	{
		$name = $result["name"];
		$sID = $result["ID"];
		PRINT "<OPTION VALUE=$sID>$name</OPTION>\n";
	}
	PRINT "</SELECT>\n";
}

function Tech_list($value, $myname, $readonly = false) 
{
	$query = "SELECT * FROM users WHERE (type = 'admin' || type = 'tech') ORDER BY name";

	$DB = Config::Database();
	$data = $DB->getAll($query);

	$techlist[''] = '[ Nobody ]';
	foreach ($data as $result)
    	{
    		$techlist[$result['name']] = $result['fullname'];
	}

	if ($readonly)
	{
		echo $techlist[$value]."\n";
	}
	else
	{
	  	PRINT "<SELECT NAME=\"$myname\" SIZE=1>";

	  	foreach ($techlist as $v => $l)
	  	{
	  		if ($v == $value)
	  		{
	  			$sel = ' selected';
			}
			else
			{
				$sel = '';
			}

	  		PRINT "<OPTION VALUE=\"$v\"$sel>$l</OPTION>\n";
	    	}
	  	PRINT "</SELECT>";
	}
}

function showPortsOnDevice($device, $device_type)
{
	$DB = Config::Database();

	$qdevice = $DB->getTextValue($device);
	$qdevice_type = $DB->getTextValue($device_type);
	$query = "SELECT * FROM networking_ports WHERE (device_on = $qdevice AND device_type = $qdevice_type) ORDER BY logical_number";

	$data = $DB->getAll($query);

	# 1 is computer, 2 networking device
	$numRows = count($data);

	PRINT "<TABLE BORDER=1 WIDTH=100%>";
	PRINT "<TR><th>"._("Port #")."</th><th>"._("Name")."</th><th>"._("Interface")."</th><th>"._("IP Address")."</th><th>"._("MAC/Network Address")."</th><th>"._("Connected to...")."</th></TR>";
	
	$userbase = Config::AbsLoc('users');
	if ($numRows < 1) 
	{
		PRINT "<TR><td colspan=6>"._("Looks like a lonely device to me.  No ports found.")."</TD></TR>";
	}
	else
	{
		foreach ($data as $result)
		{
			$ID = $result["ID"];
			$name = $result["name"];
			$logical_number = $result["logical_number"];
			$iface = $result["iface"];
			$ifaddr = $result["ifaddr"];
			$ifmac = $result["ifmac"];

			$qID = $DB->getTextValue($ID);
			$wquery = "SELECT * FROM networking_wire WHERE (end1 = $qID OR end2 = $qID)";
			$wire = $DB->getRow($wquery);
			if (count($wire) > 0) 
			{
				$wID = $wire["ID"];
				$wend1 = $wire["end1"];
				$wend2 = $wire["end2"];
				if ($wend1 == $ID) 
				{
					$qend = $DB->getTextValue($wend2);
				}
				else
				{
					$qend = $DB->getTextValue($wend1);
				}
				
				$pquery = "SELECT * FROM networking_ports WHERE (ID = $qend)";
				$farend = $DB->getRow($pquery);
					
				$pID = $farend["ID"];
				$pNum = $farend["logical_number"];
				$pOn = $farend["device_on"];
				$pType = $farend["device_type"];
				$qOn = $DB->getTextValue($pOn);
				if ($pType == 1) 
				{
					$nquery = "SELECT ID,name FROM computers WHERE (ID = $qOn)";
				} else if ($pType == 2) {
					$nquery = "SELECT ID,name FROM networking WHERE (ID = $qOn)";
				}
				$nresult = $DB->getRow($nquery);
				$nname = $nresult["name"];
				$nID = $nresult["ID"];
				$found = 1;
			}
			else
			{
				$found = 0;
				$pType = 0;
			}
		
			PRINT "<TR><TD><A HREF=\"$userbase/networking-port.php?ID=$ID\">$logical_number</A></TD><TD>$name</TD><TD>$iface</TD><TD>$ifaddr</TD><TD>$ifmac</TD>";
			PRINT "<TD>";
			if ($pType == 1) 
			{
				PRINTF ("Port %1\$s on computer %2\s", "<A HREF=\"$userbase/networking-port.php?ID=$pID\">$pNum</A>", "<A HREF=\"$userbase/computers-info.php?ID=$nID\">$nname ($nID)</A>");
				PRINT " | <A HREF=\"$userbase/networking-port-discon.php?ID=$ID\">"._("Disconnect")."</A>.";
			}
			else if ($pType == 2) 
			{
				PRINTF ("Port %1\s on network device %2\s","<A HREF=\"$userbase/networking-port.php?ID=$pID\">$pNum</A>","<A HREF=\"$userbase/networking-info.php?ID=$nID\">$nname ($nID)</A>");
				PRINT " | <A HREF=\"$userbase/networking-port-discon.php?ID=$ID\">"._("Disconnect")."</A>.";
			}
			else if ($found != 1) 
			{
				PRINT _("Nothing Connected.")." <A HREF=\"$userbase/networking-connecter.php?ID=$ID\">"._("Connect")."</A>";
			}
			PRINT "</TD></TR>";
			$found = 0;
			$pType=0;
		}
	}

	PRINT "<TR><td colspan=6 align=right><A HREF=\"$userbase/networking-port-add-form.php?device=$device&device_type=$device_type\">"._("Add Port")."</A></TD></TR>";
	PRINT "</TABLE><BR>";
}

function logevent($item, $itemtype, $level, $service, $event)
{
	if ($level <= Config::Get('minloglevel')) 
	{
		$vals = array(
			'item' => $item,
			'itemtype' => $itemtype,
			'date' => date('Y-m-d H:i:s'),
			'service' => $service,
			'level' => $level,
			'message' => $event
			);
		$DB = Config::Database();
		$DB->InsertQuery('event_log', $vals);
	}
}

function show_events($events)
{
	if (!count($events))
	{
		PRINT "<p>"._("No events")."<BR>";
		return;
	}
	PRINT "<TABLE WIDTH=100% BORDER=1>";
	PRINT "<TR><th>"._("Item")."</th><th>"._("Date")."</th><th>"._("Service")."</th><th WIDTH=5%>"._("Level")."</th><th WIDTH=70%>"._("Message")."</th></TR>";
	foreach ($events as $result)
	{
		$ID = $result["ID"];
		$item = $result["item"];
		$itemtype = $result["itemtype"];
		$date = $result["date"];
		$service = $result["service"];
		$level = $result["level"];
		$message = $result["message"];
		PRINT "<TR><TD>$itemtype: $item</TD><TD>$date</TD><TD>$service</TD><TD>$level</TD><TD>$message</TD></TR>";
	}
	PRINT "</TABLE>";
}

function kbdisplaycategories($parentID=0)
{
	$query = "select * from kbcategories where (parentID = $parentID) order by name asc";

	$DB = Config::Database();
	$data = $DB->getAll($query);
	if(count($data) > 0)
	{	
		PRINT "<ul>\n";
		foreach ($data as $result)
		{
			$name = $result["name"];
			PRINT "<li><B>$name</B>\n";
			$ID = $result["ID"];
	  		kbdisplayarticles($ID);
			kbdisplaycategories($ID);
		}
		PRINT "</ul>\n";
	} 
}

function kbdisplayarticles($parentID)
{
	$query = "select * from kbarticles where (categoryID = $parentID) order by question asc";

	$DB = Config::Database();
	$data = $DB->getAll($query);
	PRINT "<ul>\n";

	foreach ($data as $result)
	{
		$ID = $result["ID"];
		kbdisplayarticle($ID);
	}
	PRINT "</ul>\n";
}

function kbdisplayarticle($ID)
{
	$query = "select * from kbarticles where (ID=$ID)";

	$DB = Config::Database();
	$result = $DB->getRow($query);
	$question = $result["question"];
	PRINT '<li><A HREF="'.Config::AbsLoc("users/knowledgebase-detail.php?ID=$ID").'">';
	PRINT "$question</A>\n";
}

function kbdisplayfullarticle($ID)
{
	$query = "select * from kbarticles where (ID=$ID)";

	$DB = Config::Database();
	$result = $DB->getRow($query);
	$question = $result["question"];
	$categoryID = $result["categoryID"];
	$fullcategoryname = kbcategoryname($categoryID);
	PRINT "<H2>".sprintf(_("Question (%s):"), $fullcategoryname)."</H2>$question\n";
	PRINT "<HR>\n";
	PRINT "<H2>"._("Answer:")."</H2>\n";
	$answer = nl2br($result["answer"]);
	PRINT "$answer";
}

function kbcategoryList($current=0)
{
	PRINT "<SELECT NAME=categorylist size=1>\n";
	PRINT "<OPTION VALUE=0>Main</OPTION>\n";
	kbcategoryListSelect($current, 0, "Main\\");
	PRINT "</SELECT>\n";
}
function kbisfaq($ID)
{
	$query = "select * from kbarticles where (ID=$ID)";
	
	$DB = Config::Database();
	$result = $DB->getRow($query);

	PRINT "<BR><HR>";
	$isFAQ = $result["faq"];
	if($isFAQ == "yes")
	{
		PRINT _("This Knowledge Base entry is part of the FAQ.");
	}
	else
	{
		PRINT _("This Knowledge Base entry is not part of the FAQ.");
	}

	PRINT "<BR><BR>\n";
	PRINT "<TABLE BORDER=0 WIDTH=100%>\n";
	PRINT "<TR>\n";
	if($isFAQ == "yes")
	{
		PRINT "<TD ALIGN=left WIDTH=\"33%\"><H4>";
		PRINT '<A HREF="'.Config::AbsLoc("users/knowledgebase-detail.php?ID=$ID&removefromfaq=yes").'">'._("Remove Article from the FAQ").'</A></H4></TD>';
	}
	else
	{
		PRINT "<TD ALIGN=left WIDTH=\"33%\"><H4>";
		PRINT '<A HREF="'.Config::AbsLoc("users/knowledgebase-detail.php?ID=$ID&addtofaq=yes").'">'._("Add Article to the FAQ").'</A></H4></TD>';
	}
	PRINT "<TD ALIGN=left WIDTH=\"34%\"><H4>";
	PRINT '<A HREF="'.Config::AbsLoc("users/knowledgebase-article-modify.php?ID=$ID").'">'._("Modify Article").'</A></H4></TD>';
	PRINT "<TD ALIGN=left WIDTH=\"33%\"><H4>";
	PRINT '<A HREF="'.Config::AbsLoc("users/knowledgebase-article-delete.php?ID=$ID").'">';
	PRINT _("Delete Article")."</A>";
	PRINT "		</H4></TD></TR>\n";
	PRINT "</TABLE>\n";
	PRINT "<BR>";
}

function kbcategoryListSelect($current, $parentID=0, $categoryname="")
{
	$query = "select * from kbcategories where (parentID = $parentID) order by name desc";

	$DB = Config::Database();
	$data = $DB->getAll($query);
	foreach ($data as $result)
	{
		$ID = $result["ID"];
		$name = $categoryname . $result["name"];
		PRINT "<OPTION VALUE=$ID";
		if($current == $ID)
		{
			PRINT " SELECTED";
		}
		PRINT ">$name</OPTION>\n";
		$name = $name . "\\";
		kbcategoryListSelect($current, $ID, $name);
	}
}

function kbcategoryname($ID, $wholename="")
{
	$query = "select * from kbcategories where (ID = $ID)";
	$DB = Config::Database();
	$result = $DB->getRow($query);
	if(count($result) > 0)
	{
		$parentID = $result["parentID"];
		if($wholename == "")
		{
			$name = $result["name"];
		} else
		{
			$name = $result["name"] . "\\";
		}
		$name = kbcategoryname($parentID, $name) . $name;
		if($parentID == 0)
		{
			$name = "Main\\" . $name;
		}
	}
	return (@$name);
}

function getFAQCategories()
{
	$query = "select * from kbarticles where (faq = 'yes')";

	$DB = Config::Database();
	$data = $DB->getAll($query);
	$catNumbers = array();
	foreach ($data as $result)
	{
		getFAQParentCategories($result["categoryID"], $catNumbers);
		#	$catNumbers[] = $result["categoryID"];
	}

	return($catNumbers);
}	

function getFAQParentCategories($ID, &$catNumbers)
{
	$query = "select * from kbcategories where (ID = '$ID')";

	$DB = Config::Database();
	$result = $DB->getRow($query);
	if(count($result) > 0)
	{
		$parentID = $result["parentID"];
		if(!in_array($parentID, $catNumbers))
		{
			getFAQParentCategories($parentID, $catNumbers);
		}
		if(!in_array($ID, $catNumbers))
		{
			$szecatNumbers = sizeof($catNumbers);
			$catNumbers[$szecatNumbers] = $ID;
		}
	}
}

function faqdisplaycategories($parentID=0)
{
	$catNumbers = getFAQCategories();
	$query = "select * from kbcategories where (parentID = $parentID) order by name asc";

	$DB = Config::Database();
	$data = $DB->getAll($query);
	if(count($data) > 0)
	{
		PRINT "<ul>\n";

		foreach ($data as $result)
		{
			$name = $result["name"];
			$ID = $result["ID"];
			if(in_array($ID, $catNumbers))
			{
				PRINT "<li><B>$name</B>\n";
	  			faqdisplayarticles($ID);
				faqdisplaycategories($ID);
			}
		}
		PRINT "</ul>\n";
	} 
}

function faqdisplayarticles($parentID)
{
	$query = "select * from kbarticles where (categoryID = $parentID) and (faq = 'yes') order by question asc";

	$DB = Config::Database();
	$data = $DB->getAll($query);
	PRINT "<ul>\n";
	foreach ($data as $result)
	{
		$ID = $result["ID"];
		faqdisplayarticle($ID);
	}
	PRINT "</ul>\n";
}

function faqdisplayarticle($ID)
{
	$query = "select * from kbarticles where (ID=$ID)";

	$DB = Config::Database();
	$result = $DB->getRow($query);
	$question = $result["question"];
	PRINT '<li><A HREF="'.Config::AbsLoc("users/faq-detail.php?ID=$ID").'">';
	PRINT "$question</A>\n";
}

function kbaddtofaq($ID)
{
	$DB = Config::Database();
	$DB->query("UPDATE kbarticles SET faq='yes' WHERE ID=$ID");
}

function kbremovefromfaq($ID)
{
	$DB = Config::Database();
	$ID = $DB->getTextValue($ID);
	$DB->query("UPDATE kbarticles SET faq='no' WHERE ID=$ID");
}

function computerInGroup($ID)
{
	$query = "select COUNT(*) from comp_group where (comp_id = $ID)";
	$DB = Config::Database();
	return $DB->getOne($query);
}

function namepriority($priority, $html = true)
{
	switch ($priority)
	{
		case 5:
			$colour = 'red';
			$name = _('Very High');
			break;

		case 4:
			$colour = 'purple';
			$name = _('High');
			break;

		case 3:
			$colour = 'black';
			$name = _('Normal');
			break;

		case 2:
			$colour = 'blue';
			$name = _('Low');
			break;

		case 1:
			$colour = 'green';
			$name = _('Very Low');
			break;

		default:
			$colour = 'pink';
			$name = _('Unknown');
	}

	if ($html)
	{
		return "<FONT COLOR=\"$colour\">$name</FONT>";
	}
	else
	{
		return $name;
	}
}

/** Return a series of <option value="x">label</option> type lines
 * $opts is an assoc. array of value => label pairs.  If $selected is
 * given, it should be a scalar containing the value (not label!) you
 * want to be marked as 'selected' in the option set.
 */
function select_options($opts, $selected = NULL)
{
	$rv = '';
	
	foreach ($opts as $v => $l)
	{
		if ($v == $selected)
		{
			$sel = ' selected';
		}
		else
		{
			$sel = '';
		}
		
		$rv .= "<option value=\"$v\"$sel>$l</option>\n";
	}

	return $rv;
}

class Followup
{
	
	var $ID;
	var $TrackingID;
	var $Author;
	var $FollowupInfo;
	var $DateEntered;
	var $Public;

	function Followup($ID=0)
	{
		$this->Public = 0;
		if($ID != 0)
		{
			$this->setID($ID);
			$this->retrieve();
		}
	}
	
	function retrieve()
	{
		$query = "select * from followups where(ID=$this->ID) ORDER BY date";
		$DB = Config::Database();
		$result = $DB->getRow($query);
		$this->setID($this->ID);
		$this->setTrackingID($result['tracking']);
		$this->setAuthor($result['author']);
		$this->setFollowupInfo($result['contents']);
		$this->setDateEntered($result['date']);
		$this->setPublic($result['public']);
	}

	function add()
	{
		if($this->ID != 0)
		{
			PRINT _("Error adding Followup, ") . _("ID != 0")."<BR>\n";
		}
		if($this->TrackingID == 0)
		{
			PRINT _("Error adding Followup, ") . _("trackingID is invalid")."<BR>\n";
		}
		if($this->Author == "")
		{
			PRINT _("Error adding Followup, ") . _(" author not specified")."<BR>\n";
		}
		if($this->FollowupInfo == "")
		{
			PRINT _("Error adding Followup, ") . _("followupInfo not added")."<BR>\n";
		}
		$this->resetDateEntered();
		$vals = array(
			'tracking' => $this->TrackingID,
			'date' => $this->DateEntered,
			'author' => $this->Author,
			'contents' => $this->FollowupInfo,
			'public' => $this->Public
			);
		$DB = Config::Database();
		$DB->InsertQuery('followups', $vals);
	}

	function displayAddForm()
	{
		global $IRMName;
		PRINT "<TR BGCOLOR=#BBBBBB>
			<TD>
				<FONT COLOR=\"yellow\">"._("Add Followup")."</FONT>
			</TD>
			<TD>
				<FONT FACE=\"Arial, Helvetica\">$IRMName</FONT>
			</TD>
			<TD>
				<FONT FACE=\"Arial, Helvetica\">
					<TEXTAREA COLS=40 ROWS=3 NAME=newfollowup WRAP=soft></TEXTAREA>
					<BR /><INPUT TYPE=checkbox name=public value=1 checked>"._("Public followup").
				"</FONT>
			</TD>
			</TR>";
				
	}
	
	function delete()
	{
		$DB = Config::Database();
		$id = $DB->getTextValue($this->ID);
		$query = "DELETE FROM followups WHERE (ID=$id)";
		$DB->query($query);
	}

	function getID()
	{
		return($this->ID);
	}

	function getTrackingID()
	{
		return($this->TrackingID);
	}

	function getAuthor()
	{
		return($this->Author);
	}

	function getFollowupInfo()
	{
		return($this->FollowupInfo);
	}

	function getDateEntered()
	{
		return($this->DateEntered);
	}

	function setID($sID)
	{
		$this->ID = $sID;
	}

	function setTrackingID($tID)
	{
		$this->TrackingID = $tID;
	}

	function setAuthor($sAuthor)
	{
		$this->Author = $sAuthor;
	}

	function setFollowupInfo($sFI)
	{
		$this->FollowupInfo = $sFI;
	}

	function setDateEntered($DE)
	{
		$this->DateEntered = $DE;
	}

	function setPublic($p)
	{
		$this->Public = $p ? 1 : 0;
	}

	function resetDateEntered()
	{
		$this->DateEntered = date("Y-m-d H:i:s");
	}

	function displayHeader()
	{
		PRINT "<TABLE style=\"border: 1px solid;\" WIDTH=100%><TR><th colspan=3>"._("Followups")."</th></TR><TR BGCOLOR=#DDCCBB><TD><b>"._("Date")."</b></TD><TD><b>"._("Author")."</b></TD><TD><b>"._("Description")."</b></TD></TR>";
	}

	function displayFooter()
	{
		PRINT "</TABLE>";
	}

	function display()
	{
		global $bgcd, $IRMName;

		$user = new User($IRMName);
		$type = $user->getType();
		
		if ($type == 'tech' || $type == 'admin' || $this->Public)
		{
			$contents = nl2br($this->FollowupInfo);
			PRINT "<TR $bgcd>";
			PRINT "<TD><FONT face=\"Arial, Helvetica\">";
			if (!$this->Public)
			{
				print "<b>"._("Private Note")."</b><br>";
			}
			list($year,$month,$day,$hour,$minute,$second) = split("([^0-9])", $this->DateEntered);
			$timestamp = mktime($hour,$minute,$second,$month,$day,$year);
			$dateopened = date("h:iA - F j, Y", $timestamp);
			PRINT "$dateopened</FONT></TD><TD><FONT face=\"Arial, ";
			PRINT "Helvetica\">$this->Author</FONT></TD><TD><FONT ";
			PRINT "face=\"Arial, Helvetica\">$contents</FONT></TD>";
			PRINT "</TR>";
		}
	}

	function commit()
	{
		if($this->ID == 0)
		{
			PRINT _("Error committing Followup, ") . _("ID = 0. Use \"add\" to add new ");
			PRINT _("Followups and \"commit\" to commit changes to Followups")."<BR>\n";
			return (0);
		}
		if($this->TrackingID == 0)
		{
			PRINT _("Error committing Followup, ") . _("tracking ID is invalid")."<BR>\n";
			return (0);
		}
		if($this->Author == "")
		{
			PRINT _("Error committing Followup, ") . _("author not specified")."<BR>\n";
			return (0);
		}
		if($this->FollowupInfo == "")
		{
			PRINT _("Error committing Followup, ") . _("followupInfo not added")."<BR>\n";
			return (0);
		}
		$vals = array(
			'tracking' => $this->TrackingID,
			'date' => $this->DateEntered,
			'author' => $this->Author,
			'contents' => $this->FollowupInfo,
			'public' => $this->Public
			);
		$DB = Config::Database();
		$ID = $DB->getTextValue($this->ID);
		
		$DB->UpdateQuery('followups', $vals, "ID=$ID");
	}
	
	function getByTrackingID($tID)
	{
		$DB = Config::Database();

		$parms = array('tracking='.$DB->getTextValue($tID));
		
		global $IRMName;
		$user = new User($IRMName);
		if ($user->getType() != 'tech' && $user->getType() != 'admin')
		{
			$parms[] = "public=1";
		}

		$query = "select ID from followups where " . join(' AND ', $parms) . " ORDER BY date";

		return $DB->getCol($query);
	}

	function mailBody()
	{
		list($year,$month,$day,$hour,$minute,$second) = split("([^0-9])", $this->DateEntered);
		$timestamp = mktime($hour,$minute,$second,$month,$day,$year);
		$dateopened = date("h:iA - F j, Y", $timestamp);
		
		$mail = _("Followup added on:")." $dateopened\n";
		$mail .= _("Followup added by:")." $this->Author\n";
		$mail .= _("Followup information:")." $this->FollowupInfo\n\n";

		return $mail;
	}
}

class Tracking
{
	var $ID;
	var $DateEntered;
	var $CloseDate;
	var $Status;
	var $Assign;
	var $ComputerID;
	var $WorkRequest;
	var $Priority;
	var $IsGroup;
	var $Author;
	var $AuthorEmail;
	var $EmailUpdatesToAuthor;
	var $Followups;
	var $newFollowups;
	var $OtherEmails;

	function Tracking($ID=0)
	{
		if($ID != 0)
		{
			$this->setID($ID);
			$this->retrieve();
		}
	}
	
	function retrieve()
	{
		$DB = Config::Database();
		$qID = $DB->getTextValue($this->ID);
		
		$query = "SELECT * FROM tracking WHERE (ID=$qID)";
		$result = $DB->getRow($query);
		$this->setDateEntered($result['date']);
		$this->setCloseDate($result['closedate']);
		$this->setStatus($result['status']);
		$this->setAssign($result['assign']);
		$this->setComputerID($result['computer']);
		$this->setWorkRequest($result['contents']);
		$this->setPriority($result['priority']);
		$this->setIsGroup($result['is_group']);
		$this->setAuthor($result['author']);
		$this->setAuthorEmail($result['uemail']);
		$this->setEmailUpdatesToAuthor($result['emailupdates']);
		$this->setOtherEmails($result['other_emails']);
		$this->setFollowups();
	}

	function setFollowups()
	{
		if($this->ID == 0)
		{
			PRINT _("Error setting followup information in Tracking Class:")." ";
			PRINT _("Tracking ID has not been set yet")."\n";
		}
		$fol = new Followup();
		$FollowupIDs = $fol->getByTrackingID($this->ID);
		foreach ($FollowupIDs as $id)
		{
			if ($id != 0)
			{
				$this->Followups[] = new Followup($id);
			}
			else
			{
				trigger_error(_("Got zero ID for followup"), E_USER_WARNING);
			}
		}
	}

	function setDateEntered($DE)
	{
		$this->DateEntered = $DE;
	}

	function setCloseDate($CD)
	{
		$this->CloseDate = $CD;
	}

	function setStatus($Stat)
	{
		$this->Status = $Stat;
		$DB = Config::Database();
		if ($DB->getOne("SELECT closed FROM tracking_status WHERE status=".$DB->getTextValue($Stat)))
		{
			$this->setCloseDate(date('Y-m-d H:i:s'));
		}
	}

	function setAssign($As)
	{
		if (!$this->Assign && $As && $this->Status == 'new')
		{
			$this->Status = 'assigned';
		}
		$this->Assign = $As;
	}

	function setComputerID($CompID)
	{
		$this->ComputerID = $CompID;
	}

	function setWorkRequest($WR)
	{
		$this->WorkRequest = $WR;
	}

	function setPriority($Pri)
	{
		$this->Priority = $Pri;
	}

	function setIsGroup($IG)
	{
		$this->IsGroup = $IG;
	}

	function setAuthor($Auth)
	{
		$this->Author = $Auth;
	}

	function setAuthorEmail($AE)
	{
		$this->AuthorEmail = $AE;
	}

	function setEmailUpdatesToAuthor($EUTA)
	{
		$this->EmailUpdatesToAuthor = $EUTA;
	}

	function setOtherEmails($OE)
	{
		$this->OtherEmails = $OE;
	}

	function setID($Ident)
	{
		$this->ID = $Ident;
	}

	function getID()
	{
		return($this->ID);
	}

	function getDateEntered()
	{
		return($this->DateEntered);
	}

	function getCloseDate()
	{
		return($this->CloseDate);
	}

	function getStatus()
	{
		return($this->Status);
	}

	function getAssign()
	{
		return($this->Assign);
	}

	function getComputerID()
	{
		return($this->ComputerID);
	}

	function getWorkRequest()
	{
		return($this->WorkRequest);
	}

	function getPriority()
	{
		return($this->Priority);
	}

	function getIsGroup()
	{
		return($this->IsGroup);
	}

	function getAuthor()
	{
		return($this->Author);
	}

	function getAuthorEmail()
	{
		return($this->AuthorEmail);
	}

	function getEmailUpdatesToAuthor()
	{
		return($this->EmailUpdatesToAuthor);
	}

 	function getOtherEmails()
 	{
 		return $this->OtherEmails;
 	}
 
	function getNotClosed($Advanced, $Show, $Order = 'date ASC', $username = NULL)
	{
		// Disallow potentially damaging sort specifications
		if (!preg_match('/^[ _0-9A-Za-z]+$/', $Order))
		{
			trigger_error("Tracking::getNotClosed(): "._("Invalid sort string:")." $Order", E_USER_ERROR);
			exit;
		}

		// Prefix the sort field by it's table
		if (substr($Order, 0, 8) == 'location')
		{
			$Order = "computers.$Order";
		}
		else
		{
			$Order = "tracking.$Order";
		}

		global $IRMName;
	
		if($username === NULL)
		{
			$username = $IRMName;
		}

		$DB = Config::Database();
		$username = $DB->getTextValue($username);

		$sort = "ORDER BY $Order";

		if ($Advanced == "yes")
		{
	  		if($Show == "individual")
  			{
  				$where = "WHERE (tracking_status.closed = 0)
  					AND (tracking_status.status=tracking.status)
					AND (tracking.assign = $username)";
	  		}
			else if ($Show == "unassigned")
	  		{
  				$where = "WHERE (tracking_status.closed = 0)
  					AND (tracking_status.status=tracking.status)
					AND ((tracking.assign is null)
						OR (tracking.assign = ''))";
	  		}
	  		else
	  		{
  				$where = "WHERE (tracking_status.closed = 0)
  					AND (tracking_status.status=tracking.status)";
			}
		}
		else
		{
			$where = "WHERE (tracking_status.closed = 0)
				AND (tracking_status.status=tracking.status)";
		}

		$query = "SELECT tracking.ID
				FROM tracking LEFT JOIN computers
					ON tracking.computer=computers.ID,
				    tracking_status
				$where
				$sort";

		return $DB->getCol($query);
	}

	function getNotClosedBy($Order, $username = NULL)
	{
		global $IRMName;
	
		if($username === NULL)
		{
			$username = $IRMName;
		}

		$DB = Config::Database();
		$username = $DB->getTextValue($username);

		$sort = '';
		if (strtolower($Order) == 'asc')
		{
			$sort = "ORDER BY date";
		}
		else if (strtolower($Order) == 'desc')
		{
			$sort = "ORDER BY date DESC";
		}
		
	  	$query = "SELECT ID FROM tracking,tracking_status
					WHERE tracking_status.closed = 0
	  					AND tracking_status.status=tracking.status
						AND (author = $username)
					$sort";

		return $DB->getCol($query);
	}

	function display($withFollowups = false)
	{
		global $IRMName;
		if($this->ID == 0)
		{
			PRINT _("Error displaying Tracking: ") . _("ID is not set.")."<BR>\n";
		}

		if($this->DateEntered == 0)
		{
			PRINT _("Error displaying Tracking: ") . _("DateEntered is not set.")."<BR>\n";
		}

		if($this->Status == "")
		{
			PRINT _("Error displaying Tracking: ") . _("Status is not set.")."<BR>\n";
		}

		if($this->Author == "")
		{
			PRINT _("Error displaying Tracking: ") . _("Author is not set.")."<BR>\n";
		}

		if($this->ComputerID == 0)
		{
			PRINT _("Error displaying Tracking: ") . _("ComputerID is not set.")."<BR>\n";
		}

		if($this->WorkRequest == "")
		{
			PRINT _("Error displaying Tracking: ") . _("WorkRequest is not set.")."<BR>\n";
		}

		if($this->Priority == 0)
		{
			PRINT _("Error displaying Tracking: ") . _("Priority is not set.")."<BR>\n";
		}

		if($this->IsGroup == "")
		{
			PRINT _("Error displaying Tracking: ") . _("IsGroup is not set.")."<BR>\n";
		}

		if($this->AuthorEmail == "")
		{
			PRINT _("Error displaying Tracking: ") . _("AuthorEmail is not set.")."<BR>\n";
		}

		if($this->EmailUpdatesToAuthor == "")
		{
			PRINT _("Error displaying Tracking: ") . _("EmailUpdatesToAuthor is not set.")."<BR>\n";
		}

		$user = new User();
		$authExists = $user->exists($this->Author);
		if($authExists)
		{
			$user2 = new User($this->Author);
			$authorfullname = $user2->getFullname();
		} else
		{
			$authorfullname = $this->Author;
		}

		$assignExists = $user->exists($this->Assign);
		if($assignExists)
		{
			$user2 = new User($this->Assign);
			$assignfullname = $user2->getFullname();
		} else
		{
			$assignfullname = $this->Assign;
		}

		$DB = Config::Database();
		$qID = $DB->getTextValue($this->ComputerID);
		
		if($this->IsGroup == "yes")
		{
			$query = "SELECT name FROM groups WHERE (ID = $qID)";
		} else
		{
			$query = "SELECT name,location FROM computers WHERE (ID = $qID)";
		}

		$DB = Config::Database();
		$result = $DB->getRow($query);
		$computername = $result["name"];
		$location = @$result['location'];
		if ($location == '')
		{
			$location = '&nbsp;';
		}
		
		PRINT "<TR BGCOLOR=#EEEEEE><TD><B>$this->ID</B></TD>\n";
		if($this->Status == "new")
		{
			PRINT "<TD><FONT COLOR=\"blue\"><B>"._("NEW")."</B></FONT></TD>\n";
		}
		else if($this->Status == "wait")
		{
			PRINT "<TD><FONT COLOR=\"red\"><B>"._("WAIT")."</B></FONT></TD>\n";
		}
		else if ($this->Status == "active")
		{
			PRINT "<TD><FONT COLOR=\"green\"><B>"._("ACTIVE")."</B></FONT></TD>\n";
		}
		else if ($this->Status == "assigned")
		{
			PRINT "<TD><FONT COLOR=\"purple\"><B>"._("ASSIGNED")."</B></FONT></TD>\n";
		}
		else if ($this->Status == "old")
		{
			PRINT "<TD><B>"._("OLD")."</B></TD>";
		}
		else if ($this->status == "complete")
		{
			PRINT "<TD><B>"._("COMPLETE")."</B></TD>";
		}
		else
		{
			PRINT "<TD><B>"._("UNKNOWN!")."</B></TD>";
		}

		if (($this->Status != "old") && ($this->Status != "complete"))
		{
			list($year,$month,$day,$hour,$minute,$second) = split("([^0-9])", $this->DateEntered);
			$timestamp = mktime($hour,$minute,$second,$month,$day,$year);
			$dateopened = date("h:iA n/j/y", $timestamp);
	
			PRINT "<TD><FONT FACE=\"Arial, Helvetica\"><B>"._("Opened:")." $dateopened</B></FONT></TD>";
		} else
		{
			list($year,$month,$day,$hour,$minute,$second) = split("([^0-9])", $this->DateEntered);
			$timestamp = mktime($hour,$minute,$second,$month,$day,$year);
			$dateopened = date("h:iA n/j/y", $timestamp);
			list($year,$month,$day,$hour,$minute,$second) = split("([^0-9])", $this->CloseDate);
			$timestamp = mktime($hour,$minute,$second,$month,$day,$year);
			$dateclosed = date("h:iA n/j/y", $timestamp);
			PRINT "<TD><FONT FACE=\"Arial, Helvetica\"><B>"._("Opened:")." $dateopened <BR>"._("Closed:")." $dateclosed</B></FONT></TD>";
		}

		$userbase = Config::AbsLoc('users');

		$priorityname = namepriority($this->Priority);
		PRINT "<TD><FONT FACE=\"Arial, Helvetica\"><B>$priorityname</B></FONT></TD>";
		PRINT "<TD><FONT FACE=\"Arial, Helvetica\"><B>";
		if($authExists)
		{
			PRINT "<A HREF=\"$userbase/users-info.php?ID=$this->Author\">\n";
		}
		PRINT "$authorfullname";
		if($authExists)
		{
			PRINT "</A>";
		}

		if((Config::Get('userupdates')) && ($this->EmailUpdatesToAuthor == "yes"))
		{
			PRINT "(U)";
		}

		PRINT "</B></FONT></TD>";

		if($this->Assign == "")
		{
			PRINT "<TD>["._("Nobody")."]</TD>";
		}
		else
		{
			PRINT "<TD><B>\n";
			if($assignExists)
			{
				PRINT "<A HREF=\"$userbase/users-info.php?ID=$this->Assign\">\n";
			}
			PRINT "$assignfullname";
			if($assignExists)
			{
				PRINT "</B></TD>";
			}
		}

		PRINT "<TD><FONT FACE=\"Arial, Helvetica\">";
		if($this->IsGroup != "yes")
		{
		PRINT "<A HREF=\"$userbase/computers-info.php?ID=$this->ComputerID\">";
		}
		PRINT "<B>$computername</B>";
		if($this->IsGroup != "yes")
		{
			PRINT "</A>\n";
		}

		PRINT "</FONT></TD>";

		PRINT "<TD><FONT FACE=\"sans-serif\">$location</FONT></TD>";
		
		PRINT "<TD WIDTH=\"70%\"><FONT face=\"Arial, Helvetica\">";
		$numFollowups = sizeof($this->Followups);
		if(($withFollowups) && ($numFollowups > 0))
		{
			PRINT "<TABLE BORDER=0 WIDTH=\"100%\">\n";
			PRINT "<TR><TD>\n";
		}	
		$text = nl2br($this->WorkRequest);

		PRINT "<B>$text</B>";
		
		if (!$withFollowups && $numFollowups > 0)
		{
			PRINT "<div style=\"border: 1px solid\">";
			PRINT _("Last Followup:")."<br />";
			PRINT $this->Followups[$numFollowups-1]->getFollowupInfo();
			PRINT "</div>";
		}
		
		if(($withFollowups) && ($numFollowups > 0))
		{
			PRINT "</TR>\n";
			PRINT "<TR><TD>";
			Followup::displayHeader();
			for($i=0; $i < $numFollowups; $i++)
			{
				$this->Followups[$i]->display();
			}
			Followup::displayFooter();
			PRINT "</TD></TR></TABLE></TD>\n";
		}


		PRINT "<TD><A HREF=\"$userbase/tracking-followups.php?ID=$this->ID\">";
		PRINT _("More Info")."</A> ".sprintf(_("(%s followup(s))"), $numFollowups)."</TD>";
		PRINT "</TR>";
	}
	
	function displayDetail($readonly = true)
	{
		if (!$this->ComputerID)
		{
			PRINT "<B>"._("This Tracking Entry Does Not Exist, or is missing critical details.")."</B><BR />";
			return;
		}
		PRINT "<TABLE BORDER=1 WIDTH=100%><TR><TH COLSPAN=2>"._("Job Number")." ";
		PRINT "$this->ID</TH></TR>";
		PRINT "<TR BGCOLOR=#DDDDDD><TD WIDTH=50%><B>"._("Status:")."</B><BR>";
		$status_list = array('active' => _('Active'),
				     'assigned' => _('Assigned'),
				     'complete' => _('Complete'),
				     'new' => _('New'),
				     'old' => _('Old'),
				     'wait' => _('Wait'));
		
		if ($readonly)
		{
			echo $status_list[$this->Status];
		}
		else
		{
			PRINT "<SELECT NAME=status SIZE=1>";
			foreach ($status_list as $v => $l)
			{
				if ($this->Status == $v)
				{
					$sel = " selected";
				}
				else
				{
					$sel = "";
				}
				
				echo "<OPTION VALUE=\"$v\"$sel>$l</OPTION>";
			}

			PRINT "</SELECT>";
		}
		
		list($year,$month,$day,$hour,$minute,$second) = split("([^0-9])", $this->DateEntered);
		$timestamp = mktime($hour,$minute,$second,$month,$day,$year);
		$dateopened = date("h:iA - F j, Y", $timestamp);

		PRINT "</td><td><B>"._("Date Opened:")."</B><br>$dateopened<BR>";
		if(($this->CloseDate != "0000-00-00 00:00:00") && ($this->CloseDate != ""))
		{
			PRINT "<BR><B>"._("Date Closed:")."</B><br>$this->CloseDate";

			$query = "SELECT SEC_TO_TIME(UNIX_TIMESTAMP('$this->CloseDate') - UNIX_TIMESTAMP('$this->DateEntered'))";
			$DB = Config::Database();
			$opentime = $DB->getOne($query);

			PRINT "<br>"._("This job was open for:")." $opentime";
		}
		PRINT "</td></tr>";

		$user = new User();
		$authExists = $user->exists($this->Author);
		if($authExists)
		{
			$user2 = new User($this->Author);
			$fullname = $user2->getFullname();
		} else
		{
			$fullname = $this->Author;
		}

		if($this->IsGroup == "yes")
		{
			$query = "select * from groups where (ID=$this->ComputerID)";
		} else
		{
			$query = "select * from computers where (ID=$this->ComputerID)";
		}

		$DB = Config::Database();
		$result = $DB->getRow($query);
		$computername = $result["name"];

		$userbase = Config::AbsLoc('users');
		$priorityname = namepriority($this->Priority);
		PRINT "<tr bgcolor=#DDDDDD><td><B>"._("Priority:")."</B><br>\n";
		$options = array(5 => _('Very High'),
				4 => _('High'),
				3 => _('Normal'),
				2 => _('Low'),
				1 => _('Very Low')
				);
		if ($readonly)
		{
			echo $options[$this->Priority]."\n";
		}
		else
		{
			PRINT '<SELECT name="priority" size="1">';
			foreach ($options as $v => $l)
			{
				if ($v == $this->Priority)
				{
					$sel = ' selected';
				}
				else
				{
					$sel = '';
				}
			
				PRINT "<option value=\"$v\"$sel>$l</option>\n";
			}
			PRINT '</SELECT>';		
		}
		
		PRINT "</td>";
		PRINT "<td><B>"._("Author:")."</B><br><a href=\"$userbase/users-info.php?";
		PRINT "ID=$this->Author\">$fullname</a></td></tr>";
		PRINT "<tr bgcolor=#DDDDDD><td><B>\n";
		if($this->IsGroup != "yes")
		{
			PRINT _("Computer") . ":";
		} else
		{
			PRINT _("Group") . ":";
		}
		PRINT "</B><br>";
		if($this->IsGroup != "yes")
		{
			PRINT "<a href=\"$userbase/computers-info.php?ID=$this->ComputerID\">";
		}
			PRINT "$computername ($this->ComputerID)";
		if($this->IsGroup != "yes")
		{
			PRINT "</a>";
		}
		if (!$readonly)
		{
			print "&nbsp; <input type=\"text\" name=\"ComputerID\" value=\"$this->ComputerID\" size=\"3\">";
		}
		PRINT "</td><td><B>"._("Assigned to:")."</B><br>";

		Tech_list($this->Assign, "user", $readonly);

		PRINT "</td></tr>";
		PRINT "<tr bgcolor=#DDDDDD><td colspan=2><B>"._("Problem Description:")."</B><br>";
		if ($readonly)
		{
			echo nl2br(htmlspecialchars($this->WorkRequest));
		}
		else
		{
			$text = htmlspecialchars($this->WorkRequest);
			PRINT "<TEXTAREA NAME=\"workrequest\" ROWS=\"10\" COLS=\"60\">$text</TEXTAREA>";
		}
		echo "</td></tr>";
		PRINT "</table>";
		$numFollowups = sizeof($this->Followups);
		Followup::displayHeader();
		if($numFollowups > 0)
		{
			for($i=0; $i < $numFollowups; $i++)
			{
				$this->Followups[$i]->display();
			}
		} else
		{
			PRINT "<TR><TD COLSPAN=3>"._("No Followups on this request")."</TD></TR>\n";
		}
		Followup::displayAddForm();
		Followup::displayFooter();
	}
	
	function displayHeader($sortable = true)
	{
		PRINT '<CENTER><TABLE BORDER=1 WIDTH="100%" STYLE="border: 1px solid">';
		PRINT '<TR BGCOLOR=#DDDDDD>';
		PRINT '<TH>'._("ID").'</TH>';
		PRINT '<TH>'._("Status").'</TH>';
		if ($sortable)
		{
			PRINT '<TH><a href="?sort=date">'._("Date").'</a></TH>';
			PRINT '<TH><a href="?sort=priority">'._("Pri").'</a></TH>';
			PRINT '<TH><a href="?sort=author">'._("Author").'</a></TH>';
			PRINT '<TH><a href="?sort=assign">'._("Assigned").'</a></TH>';
			PRINT '<TH><a href="?sort=computer">'._("Computer").'</a></TH>';
			PRINT '<TH><a href="?sort=location">'._("Location").'</a></TH>';
		}
		else
		{
			PRINT '<TH>'._("Date").'</TH>';
			PRINT '<TH>'._("Pri").'</TH>';
			PRINT '<TH>'._("Author").'</TH>';
			PRINT '<TH>'._("Assigned").'</TH>';
			PRINT '<TH>'._("Computer").'</TH>';
			PRINT '<TH>'._("Location").'</TH>';
		}
		PRINT '<TH COLSPAN=2 WIDTH=70%>'._("Description").'</TH></TR>';
	}

	function displayFooter()
	{
		PRINT "</TABLE></CENTER>";
	}

	function search($type, $information)
	{
		$DB = Config::Database();
		$info = $DB->getTextValue("%$information%");

		if ($type == 'tracking')
		{
			$query = "SELECT ID FROM tracking WHERE (contents LIKE $info) ORDER BY date DESC";
		}
		else if ($type == 'followups')
		{
			$query = "SELECT DISTINCT tracking.ID AS ID
				FROM tracking INNER JOIN followups ON tracking.ID=followups.tracking
				WHERE followups.contents LIKE $info
				ORDER BY tracking.date DESC";
		}
		else
		{
			$query = "SELECT DISTINCT tracking.ID AS ID
				FROM tracking LEFT JOIN followups ON tracking.ID=followups.tracking
				WHERE followups.contents LIKE $info
					OR tracking.contents LIKE $info
				ORDER BY tracking.date DESC";
		}

		return $DB->getCol($query);
	}

	function commit()
	{
		global $IRMName;
		if($this->ID == 0)
		{
			PRINT _("Error committing Work Request. ") . _("ID has not
				been set. Use \"add()\" to add new Work
				Requests and \"commit\" to commit changes to
				Work Requests")."<BR>\n";
			return (0);
		}
		if($this->DateEntered == "")
		{
			PRINT _("Error committing Work Request. ") . _("DateEntered has not been set.")."<BR>\n";
			return (0);
		}
		if($this->Status == "")
		{
			PRINT _("Error committing Work Request. ") . _("Status has not been set.")."<BR>\n";
			return (0);
		}
		if($this->ComputerID == 0)
		{
			PRINT _("Error committing Work Request. ") . _("ComputerID has not been set.")."<BR>\n";
			return (0);
		}
		if($this->WorkRequest == "")
		{
			PRINT _("Error committing Work Request. ") . _("WorkRequest has not been set.")."<BR>\n";
			return (0);
		}
		if($this->Priority == 0)
		{
			PRINT _("Error committing Work Request. ") . _("Priority has not been set.")."<BR>\n";
			return (0);
		}
		if($this->IsGroup == "")
		{
			PRINT _("Error committing Work Request. ") . _("IsGroup has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->Author))
		{
			PRINT _("Error committing Work Request. ") . _("Author has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->AuthorEmail))
		{
			PRINT _("Error committing Work Request. ") . _("AuthorEmail has not been set.")."<BR>\n";
			return (0);
		}
		if($this->EmailUpdatesToAuthor == "") 
		{
			PRINT _("Error committing Work Request. ") . _("EmailUpdatesToAuthor has not been set.")."<BR>\n";
			return (0);
		}

		if(($this->Status == "complete") || ($this->Status == "old"))
		{
			$tempCloseDate = date("Y-m-d H:i:s");
			$this->setCloseDate($tempCloseDate);
		}

		$vals = array(
			'date' => $this->DateEntered,
			'closedate' => $this->CloseDate,
			'status' => $this->Status,
			'assign' => $this->Assign,
			'computer' => $this->ComputerID,
			'contents' => $this->WorkRequest,
			'priority' => $this->Priority,
			'is_group' => $this->IsGroup,
			'author' => $this->Author,
			'uemail' => $this->AuthorEmail,
			'emailupdates' => $this->EmailUpdatesToAuthor,
			'other_emails' => $this->OtherEmails
			);
		$DB = Config::Database();
		$ID = $DB->getTextValue($this->ID);
		$DB->UpdateQuery('tracking', $vals, "ID=$ID");
	
		$numFollowups = sizeof($this->Followups);
		for($i=0;$i<$numFollowups;$i++)
		{
			$tempVal = $this->Followups[$i]->getID();
			if($tempVal > 0)
			{
				$this->Followups[$i]->commit();
			} else
			{
				$this->Followups[$i]->setTrackingID($this->ID);
				$this->Followups[$i]->add();
			}
		}	
	
		$this->sendEmail("yes");	
	}
	
	/* Send e-mail to all people interested in this ticket.
	 * If $mod is 'yes', then this is a notification of a change to an
	 * existing ticket.  Otherwise, we're sending notification of a new
	 * ticket being created.
	 */
	function sendEmail($mod="no")
	{
		global $IRMName;

		if(!Config::Get('notifyassignedbyemail')
		    && !Config::Get('userupdates')
		    && !Config::Get('notifynewtrackingbyemail'))
		{
			return;
		}

		/* First, work out who's going to get this missive
		 */
		$recipients = array();

		// Assignee
		if(Config::Get('notifyassignedbyemail')
		   && $this->Assign != $IRMName)
		{
			$assignUser = new User($this->Assign);
			if ($assignUser->getEmail())
			{
				$recipients[] = $assignUser->getEmail();
			}
		}

		// Author
		if(Config::Get('userupdates')
		   && $this->EmailUpdatesToAuthor == "yes"
		   && $this->AuthorEmail != ""
		   && $IRMName != $this->Author)
		{
			$recipients[] = $this->AuthorEmail;
		}

		// E-mail addresses that get copies of all tracking e-mails
		if(Config::Get('notifynewtrackingbyemail'))
		{
			$recipients = array_merge($recipients, split('[^a-zA-Z0-9@_\.]+', Config::Get('newtrackingemail')));
		}

		// People who have signed on to get info on this ticket
		$recipients = array_merge($recipients, split('[^a-zA-Z0-9_\.@]', $this->OtherEmails));

		// Who do we send it from?
		$currentUser = new User($IRMName);
		$sender = $currentUser->getEmail();

		// What are we going to tell them?
		$body = $this->mailBody();

		if($mod == "no")
		{
			$subject = sprintf(_("IRM: New Job %s has been added to the work request system."), $this->ID);
		}
		else
		{
			$subject = sprintf(_("IRM: Job %s has been modified by %s"), $this->ID, $IRMName);
		}

		foreach ($recipients as $r)
		{
			if ($r)
			{
				mail($r, $subject, $body, "From: $sender\n");
			}
		}
	}

	/* Generate an e-mail body suitable for transmission.
	 */
	function mailBody()
	{
		$priorityname = namepriority($this->Priority, false);

		$body = _("Tracking job information:")."\n";
		$body .= _("Tracking ID:")." $this->ID\n";
		$body .= _("Status:")." $this->Status\n";
		$body .= _("Priority:")." $priorityname\n\n";
		$body .= _("Work Request:")."\n $this->WorkRequest\n\n";

		$numFollowups = sizeof($this->Followups);

		if($numFollowups == 0)
		{
			$body .= _("No Followups have been added.")."\n";
		}
		else
		{
			$body .= _("Followups:")."\n";
			foreach ($this->Followups as $fup)
			{
				$body .= $fup->mailBody();
			}
		}

		$body .= "================================================================\n";
		$body .= _("Modify this tracking item:")."\n";
		$body .= "  http://"
				.$_SERVER['SERVER_NAME']
				.Config::AbsLoc("users/tracking-followups.php?ID=$this->ID")
				."\n";
		$body .= "================================================================\n\n";
		
		return $body;
	}
	
	function add()
	# FIXME duplicate see commit()
	{
		if(isset($this->ID))
		{
			PRINT _("Error committing Work Request. ") . _("ID has not
				been set. Use \"add()\" to add new Followups
				and \"commit\" to commit changes to
				Followups")."<BR>\n";
		}
		if(!isset($this->DateEntered))
		{
			PRINT _("Error committing Work Request. ") . _("DateEntered has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->Status))
		{
			PRINT _("Error committing Work Request. ") . _("Status has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->ComputerID))
		{
			PRINT _("Error committing Work Request. ") . _("  ComputerID has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->WorkRequest))
		{
			PRINT _("Error committing Work Request. ") . _(" WorkRequest has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->Priority))
		{
			PRINT _("Error committing Work Request. ") . _("Priority has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->IsGroup))
		{
			PRINT _("Error committing Work Request. ") . _("IsGroup has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->Author))
		{
			PRINT _("Error committing Work Request. ") .  _("Author has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->AuthorEmail))
		{
			PRINT _("Error committing Work Request. ") . _("AuthorEmail has not been set.")."<BR>\n";
			return (0);
		}
		if(!isset($this->EmailUpdatesToAuthor))
		{
			PRINT _("Error committing Work Request. ") . _(" EmailUpdatesToAuthor has not been set.")."<BR>\n";
			return (0);
		}

		$DB = Config::Database();
		$this->ID = $DB->nextId('tracking__ID');
		$vals = array(
			'ID' => $this->ID,
			'date' => $this->DateEntered,
			'closedate' => $this->CloseDate,
			'status' => $this->Status,
			'author' => $this->Author,
			'assign' => $this->Assign,
			'computer' => $this->ComputerID,
			'contents' => $this->WorkRequest,
			'priority' => $this->Priority,
			'is_group' => $this->IsGroup,
			'uemail' => $this->AuthorEmail,
			'emailupdates' => $this->EmailUpdatesToAuthor,
			'other_emails' => $this->OtherEmails
			);
			
		$DB->InsertQuery('tracking', $vals);
		
		$numFollowups = sizeof($this->Followups);
		for($i=0;$i<$numFollowups;$i++)
		{
			$this->Followups[$i]->setTrackingID($this->ID);
			$this->Followups[$i]->add();
		}

		$this->sendEmail();
	}

	function addFollowup($newFollowup)
	{
		$this->newFollowups = 1;
		$numFollowups = sizeof($this->Followups);
		$this->Followups[$numFollowups] = $newFollowup;
	}

	function getFollowupsInfo()
	{
		$numFollowups = sizeof($this->Followups);
		$returnVal = "";
		for($i=0; $i<$numFollowups; $i++)
		{	
			$returnVal = $returnVal . $this->Followups[$i]->getFollowupInfo();
		}
		return($returnVal);
	}

	function delete()
	{
		$numFollowups = sizeof($this->Followups);
		for($i=0;$i<$numFollowups;$i++)
		{
			$this->Followups[$i]->delete();
		}
		$DB = Config::Database();
		$id = $DB->getTextValue($this->ID);
		$query = "DELETE FROM tracking WHERE (ID = $id)";
		$DB->query($query);
	}

	function getByComputerID($cID)
	{
		$DB = Config::Database();
		$cID = $DB->getTextValue($cID);
		$query = "SELECT ID FROM tracking WHERE (computer = $cID) and (is_group != 'yes')";
		return $DB->getCol($query);
	}

	function getByGroupID($gID)
	{
		$DB = Config::Database();
		$gID = $DB->getTextValue($gID);
		$query = "SELECT ID FROM tracking WHERE (computer = $gID) and (is_group = 'yes')";
		return $DB->getCol($query);
	}

	function isStatus($status)
	{
		if($this->Status == $status)
		{
			return(TRUE);
		} else
		{
			return(FALSE);
		}
	}

	function isAssign($assign)
	{
		if($this->Assign == $assign)
		{
			return(TRUE);
		} else
		{
			return(FALSE);
		}
	}
}

class Configuration
{
	var $notifyassignedbyemail;
	var $notifynewtrackingbyemail;
	var $newtrackingemail;
	var $groups;
	var $usenamesearch;
	var $userupdates;
	var $sendexpire;
	var $showjobsonlogin;
	var $minloglevel;
	var $logo;
	var $snmp;
	var $snmp_rcommunity;
	var $snmp_ping;
	var $knowledgebase;
	var $fasttrack;
	var $version;
	var $build;

	function Configuration()
	{
	}
}

function array_diff_for_real($full, $remove)
{
	$new = array();
	foreach ($full as $f)
	{
		$found = false;
		
		foreach ($remove as $r)
		{
			if ($f == $r)
			{
				$found = true;
				continue;
			}
		}
		
		if (!$found)
		{
			$new[] = $f;
		}
	}
	
	return $new;
}
