/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Enum;

/**
 * This is used to specify the start positon for seek operations
 */
public class VFSSeekPosition extends Enum {

    static final private int _START = 0;

    static final public VFSSeekPosition START = new VFSSeekPosition(_START);

    static final private int _CURRENT = 1;

    static final public VFSSeekPosition CURRENT = new VFSSeekPosition(_CURRENT);

    static final private int _END = 2;

    static final public VFSSeekPosition END = new VFSSeekPosition(_END);

    static final private VFSSeekPosition[] theInterned = new VFSSeekPosition[] {
            START, CURRENT, END }

    ;

    static private java.util.Hashtable theInternedExtras;

    static final private VFSSeekPosition theSacrificialOne = new VFSSeekPosition(
            0);

    static public VFSSeekPosition intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSSeekPosition already = (VFSSeekPosition) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSSeekPosition(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSSeekPosition(int value) {
        value_ = value;
    }

    public VFSSeekPosition or(VFSSeekPosition other) {
        return intern(value_ | other.value_);
    }

    public VFSSeekPosition and(VFSSeekPosition other) {
        return intern(value_ & other.value_);
    }

    public VFSSeekPosition xor(VFSSeekPosition other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSSeekPosition other) {
        return (value_ & other.value_) == other.value_;
    }

}