/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MOZ_PROGRESS_LISTENER_H__
#define __KZ_MOZ_PROGRESS_LISTENER_H__

#include "kz-mozembed.h"
#include "kz-mozdownloader.h"

#include <nsIWebProgressListener.h>
#include <nsWeakReference.h>
#include <nsIObserver.h>
#include <nsIWebBrowserPersist.h>
#ifdef HAVE_NSITRANSFER_H
#include <nsITransfer.h>
#else
#include <nsIDownload.h>
#endif

#define KZ_DOWNLOAD_CID                \
{ /* d2a2f743-f126-4f1f-1234-d4e50490f112 */         \
	0xd2a2f743,                                      \
	0xf126,                                          \
	0x4f1f,                                          \
	{0x12, 0x34, 0xd4, 0xe5, 0x04, 0x90, 0xf1, 0x12} \
}

#define KZ_DOWNLOAD_CLASSNAME "Kazehakase's Download Progress Listener"

class KzMozProgressListener : 
#ifdef HAVE_NSITRANSFER_H
  			      public nsITransfer	
#else
  			      public nsIWebProgressListener,	
                              public nsIDownload
#endif
{
 public:
	KzMozProgressListener();
	virtual ~KzMozProgressListener();

	NS_DECL_ISUPPORTS
	NS_DECL_NSIWEBPROGRESSLISTENER
	NS_DECL_NSITRANSFER
#ifndef HAVE_NSITRANSFER_H
	NS_DECL_NSIDOWNLOAD
#endif

#ifdef HAVE_NSITRANSFER_H
	nsresult GetMIMEInfo (nsIMIMEInfo **aMIMEInfo);
	nsresult GetTargetFile (nsILocalFile **aFile);
	nsresult GetSource(nsIURI * *aSource);
	nsresult GetPercentComplete(PRInt32 *aPercentComplete);

#endif
	nsresult Cancel();

	PRInt32 mPercentComplete;
	PRInt32 mTotalProgress;
	PRInt32 mCurrentProgress;

 private:
	nsCOMPtr<nsIWebBrowserPersist> mPersist;
	nsCOMPtr<nsIObserver> mObserver;
	KzMozDownloader *mDownloader;
};


#endif /* __KZ_MOZ_PROGRESS_LISTENER_H__ */
