/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// own header
#include "parmpropdlg.h"

// qt includes
#include <qlayout.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>

// local includes
#include "../classifier.h"
#include "../interface.h"
#include "../umldoc.h"
#include "dialog_utils.h"

ParmPropDlg::ParmPropDlg(QWidget * parent, UMLDoc * doc, UMLAttribute * a)
  : KDialogBase(Plain, i18n("Parameter Properties"), Help | Ok | Cancel , Ok, parent, "_PARMPROPDLG_", true, true)
{
	m_pUmldoc = doc;
	m_pAtt = a;
	QString type, text, name, initialValue;
	if(!a) {
		type = text = name = initialValue = "";
	} else {
		type = a -> getTypeName();
		name = a -> getName();
		initialValue = a -> getInitialValue();
		text = a -> getDoc();
	}
	int margin = fontMetrics().height();
	setMinimumSize(300, 400);
	//disableResize();
	QVBoxLayout * topLayout = new QVBoxLayout(plainPage());
	topLayout -> setSpacing(10);
	topLayout -> setMargin(margin);

	m_pParmGB = new QGroupBox(i18n("Properties"), plainPage());
	topLayout -> addWidget(m_pParmGB);

	QGridLayout * propLayout = new QGridLayout(m_pParmGB, 4, 2);
	propLayout -> setSpacing(10);
	propLayout -> setMargin(margin);

	m_pTypeL = new QLabel(i18n("&Type:"), m_pParmGB);
	propLayout -> addWidget(m_pTypeL, 0, 0);

	m_pTypeCB = new QComboBox(m_pParmGB);
	propLayout -> addWidget(m_pTypeCB, 0, 1);
	m_pTypeL->setBuddy(m_pTypeCB);

	Dialog_Utils::makeLabeledEditField( m_pParmGB, propLayout, 1,
					    m_pNameL, i18n("&Name:"),
					    m_pNameLE, name );

	Dialog_Utils::makeLabeledEditField( m_pParmGB, propLayout, 2,
					    m_pInitialL, i18n("&Initial value:"),
					    m_pInitialLE, initialValue );

	Dialog_Utils::makeLabeledEditField( m_pParmGB, propLayout, 3,
					    m_pStereoTypeL, i18n("&Stereotype name:"),
					    m_pStereoTypeLE, m_pAtt->getStereotype() );

	m_pKind =  new QButtonGroup(i18n("Kind"), plainPage());
	m_pKind->setExclusive(true);

	QHBoxLayout * kindLayout = new QHBoxLayout( m_pKind );
	kindLayout->setMargin(margin);

	m_pIn =  new QRadioButton( "in", m_pKind );
	kindLayout->addWidget( m_pIn );

	m_pInOut =  new QRadioButton( "inout", m_pKind );
	kindLayout->addWidget( m_pInOut );

	m_pOut =  new QRadioButton( "out", m_pKind );
	kindLayout->addWidget( m_pOut );

	topLayout -> addWidget(m_pKind);

	m_pDocGB = new QGroupBox(i18n("Documentation"), plainPage());
	QHBoxLayout * docLayout = new QHBoxLayout(m_pDocGB);
	docLayout -> setMargin(margin);

	m_pDoc = new QMultiLineEdit(m_pDocGB);
	///////////
	m_pDoc->setWordWrap(QMultiLineEdit::WidgetWidth);
	//////////
	m_pDoc -> setText(text);
	docLayout -> addWidget(m_pDoc);
	topLayout -> addWidget(m_pDocGB);

	// Check the proper Kind radiobutton.
	if (a) {
		Uml::Parameter_Kind kind = a->getParmKind();
		if (kind == Uml::pk_Out)
			m_pOut->setChecked(true);
		else if (kind == Uml::pk_InOut)
			m_pInOut->setChecked(true);
		else
			m_pIn->setChecked(true);
	} else
		m_pIn->setChecked(true);

	//add some standard attribute types to combo box
	QString types[] ={i18n("int"), i18n("long"), i18n("bool"), i18n("string"), i18n("double"), i18n("float"), i18n("date")};
	for (int i=0; i<7; i++) {
		m_pTypeCB->insertItem(types[i]);
	}

	m_pTypeCB->setDuplicatesEnabled(false);//only allow one of each type in box
	m_pTypeCB->setEditable(true);
	m_pTypeCB->setAutoCompletion(false);

	//now add the Concepts
	UMLClassifierList namesList( m_pUmldoc->getConcepts() );
	UMLClassifier * obj;
	for(obj=namesList.first(); obj!=0 ;obj=namesList.next()) {
		m_pTypeCB->insertItem( obj->getName() );
	}
	UMLInterfaceList interfaceList( m_pUmldoc->getInterfaces() );
	UMLInterface* pInterface = 0;
	for(pInterface=interfaceList.first(); pInterface!=0 ;pInterface=interfaceList.next()) {
		m_pTypeCB->insertItem( pInterface->getName() );
	}

	//work out which one to select
	int typeBoxCount = 0;
	bool foundType = false;
	while (typeBoxCount < m_pTypeCB->count() && foundType == false) {
		QString typeBoxString = m_pTypeCB->text(typeBoxCount);
		if ( typeBoxString == type ) { //getTypeName()
			foundType = true;
			m_pTypeCB->setCurrentItem(typeBoxCount);
		} else {
			typeBoxCount++;
		}
	}

	if (!foundType) {
		m_pTypeCB->insertItem( type, 0 );
		m_pTypeCB->setCurrentItem(0);
	}

	m_pNameLE->setFocus();
}

Uml::Parameter_Kind ParmPropDlg::getParmKind() {
	Uml::Parameter_Kind pk = Uml::pk_In;
	if (m_pOut->isChecked())
		pk = Uml::pk_Out;
	else if (m_pInOut->isChecked())
		pk = Uml::pk_InOut;
	return pk;
}

void ParmPropDlg::slotOk() {
	if (m_pAtt != NULL) {
		m_pAtt->setParmKind( getParmKind() );
		m_pAtt->setStereotype( m_pStereoTypeLE->text() );
	}
	accept();
}

ParmPropDlg::~ParmPropDlg() {}

