/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qfontmetrics.h>
#include <qstring.h>
#include <qpainter.h>

#include "DCanvasPos.h"
#include "DCanvasItem.h"
#include "settings.h"

DCanvasPos::DCanvasPos(QCanvas* canvas, DCanvasItem* parent) : QCanvasRectangle(canvas)
{
    m_parent = parent;
    m_size = 64; // non-zero value
    setSize( m_size, m_size );
}

DCanvasPos::~DCanvasPos()
{
}

void DCanvasPos::drawShape(QPainter &p)
{
    // +1 is to avoid displaying "0"
    QString text = QString::number(m_parent->numChild()+1);

    // draw the ellipse
    p.setPen( QPen(Qt::NoPen) );
    p.setBrush( QColor(Qt::yellow) );
    p.drawEllipse( rect() );

    // now draw the text
    //p.setPen( QPen(SolidLine) );
    p.setPen( QColor(Qt::black) );

    QFont font( m_parent->control()->m_canvasFont );
    p.setFont(font);

    QFontMetrics fm = QFontMetrics( font );
    int twidth = fm.width(text);
    int theight = fm.height();

    p.drawText( ((int) x()) + (m_size-twidth)/2, ((int) y()) + m_size - theight/2, text );
}

int DCanvasPos::Id()
{
    return m_parent->Id();
}

void DCanvasPos::updatePos()
{
    QFontMetrics fm = QFontMetrics( m_parent->control()->m_canvasFont );
    m_size = fm.width("ABC");
    setSize(m_size, m_size);

    update();
}

int DCanvasPos::rtti() const
{
    return Rtti_DCanvasPos;
}

