/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qevent.h>
#include <qtooltip.h> 

#include <kdebug.h>
#include <klocale.h>

#include "aux.h"
#include "DDataItem.h"
#include "DDataControl.h"
#include "DTreeListView.h"
#include "settings.h"
#include "DTreeListItem.h"

    DTreeListItem::DTreeListItem(DTreeListView *parent, int id)
: KListViewItem(parent),  DGuiItem(parent, id)
{
    if (!data())
    {
	kdWarning()<<"Bug in DTreeListItem ctor"<<endl;
	return;
    }

    setOpen(true);
    KListViewItem::setText(0, data()->dispmsg());
    setDragEnabled(true);
    setDropEnabled(true);
}

DTreeListItem::~DTreeListItem()
{
}

/*
   void DTreeListItem::dropped( QDropEvent * e )
   {
   kdWarning()<<"DTreeListItem::dropped"<<endl;
   e->accept();
   }

   bool DTreeListItem::acceptDrop( const QMimeSource * ) const
   {
   return true;
   }
   */

void DTreeListItem::update()
{
    if (!data())
    {
	kdWarning()<<"Bug in DTreeListItemText::update"<<endl;
	return;
    }

    KListViewItem::setText(0, data()->dispmsg()); 
    setPixmap(0, data()->m_pixtb);

    enforceSortOrder();
}

int DTreeListItem::compare(QListViewItem* i, int, bool) const
{
    DTreeListItem *item = (DTreeListItem*) i;
    if (!item)
	return 1;

    return m_parent->dataTree()->compare(item->Id(), Id());
}

void DTreeListItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
    QColorGroup cg2(cg);

    if (!  ((DTreeListView*)listView())->dataTree()->m_reverseVideo )
    {
	cg2.setBrush( QColorGroup::Base, data()->fillColor() );
	cg2.setBrush( QColorGroup::HighlightedText, QColor(Qt::white) );
	cg2.setBrush( QColorGroup::Highlight, data()->fillColor().dark() );
    }
    else
    {
	cg2.setBrush( QColorGroup::HighlightedText, QColor(Qt::black) );
	cg2.setBrush( QColorGroup::Highlight, data()->fillColor().dark() );
    
	cg2.setBrush( QColorGroup::Text, data()->fillColor() );
	cg2.setBrush( QColorGroup::Base, QColor(Qt::black) );
    }
    
    QListViewItem::paintCell(p, cg2, column, width, align);
}

QString DTreeListItem::tipText()
{
    return "<html>"+data()->dispmsg()+"</html>";
}

