/* @(#) comms.c 1.11 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDCOMMS_C "@(#) nitehawk@winghove.1ststep.net|lib/basecommand/comms.c|20001105031356|30753 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "memory.h"
#include "llist.h"
#include "log.h"
#include "kparser.h"

/* Handler for 'say' command */
koalaerror do_say(pdescriptor desc, argument *arglist[])
{
	char linemods[] = " says, ''\r\n";
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	char *sayline;
	char *linecur;
	int len = LINELENSTEP;
	koalaerror kerr;
	int saylen;
	char *output;

	/* Read the line from the buffer */
	sayline = kmalloc(len, ALLOC_TEMP);
	if (sayline == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for line");
		return KENOMEM;
	}
	linecur = sayline;

	/* Loop until we have the entire line */
	while ((kerr = buffer_readline(desc, linecur, LINELENSTEP)) == KENOMEM)
	{
		linecur = krealloc(sayline, len + LINELENSTEP, ALLOC_TEMP);
		if (sayline == NULL)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line");
			return KENOMEM;
		}
		sayline = linecur;
		linecur = sayline + len;
		len += LINELENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* No data buffered, fall out */
		kmfree(sayline, ALLOC_TEMP);
		return KESUCCESS;
	}

	/* Did we actually get something to say? */
	if (strlen(sayline) == 0)
	{
		kmfree(sayline, ALLOC_TEMP);
		buffer_queue(desc, "What do you want to say?\r\n",
				strlen("What do you want to say?\r\n"));
		return KESUCCESS;
	}

	/* Figure out how much space we need in the string we are sending out */
	saylen = strlen(linemods) + 30 /*(max player name)*/
		+ strlen(sayline);

	/* Allocate memory for the output string */
	output = kmalloc(saylen + 2, ALLOC_TEMP);
	if (output == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for line");
		return KENOMEM;
	}

	/* Get master list head */
	tmplist = getdescriptorlist();
	for (; tmplist; tmplist = listnextnode(tmplist))
	{
		tmpdesc = tmplist->data.desc;

		if (tmpdesc == desc)
		{
			/* Prepare output string */
			snprintf(output, saylen + 1, "You say, '%s'\r\n",
					sayline);
		}
		else
		{
			/* Prepare output string */
			snprintf(output, saylen + 1, "%s says, '%s'\r\n",
					desc->data.character->name, sayline);
		}

		if (tmpdesc->type != DESCRIPTOR_PLAYER)
		{
			continue;
		}

		/* This descriptor is a player, send the message to them */
		buffer_queue(tmpdesc, output, saylen);
	}

	kmfree(output, ALLOC_TEMP);
	kmfree(sayline, ALLOC_TEMP);

	return KESUCCESS;
}
