/*******************************************************************************
**                     profilemngrinterface.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef PROFILEMNGRINTERFACE_H
#define PROFILEMNGRINTERFACE_H

// QT includes
#include <qptrlist.h>

// KDE includes

// My includes
#include "backupprofile.h"

class Subject;

////////////////////////////////////////////////////////////////////////////////
///////                  class ProfileMngrInterface                      ///////
////////////////////////////////////////////////////////////////////////////////

class ProfileMngrInterface
{
public:
    ProfileMngrInterface()
        : mpInsertedByMe( 0L ),
          mpTheSubject( 0L )
        {
            /* NOOP */
        }
    virtual ~ProfileMngrInterface()
        {
        /* NOOP */
        }

    void setSubject( Subject* subject );

    // Those three will be called by Subject
    void _inserted( BackupProfile* original, BackupProfile *b );
    void _changed(  BackupProfile* original, BackupProfile *b );
    void _removed( QString s );

    // Those three must be overwritten
    virtual void inserted( BackupProfile * );
    virtual void changed( BackupProfile * );
    virtual void removed( QString s );

protected:
    // Use the following methods to do something
    void insert( BackupProfile *b );
    void change( BackupProfile *b );
    void remove( QString s );
    bool exists( QString s );
    void restore( QString s );

private:
    BackupProfile *mpInsertedByMe;
    QString        msDeletedByMe;
    Subject       *mpTheSubject;
};

/////////////////////////////////////////////////////////////////////////////
//////////               class Subject                              /////////
/////////////////////////////////////////////////////////////////////////////

class Subject
{
public:
    Subject() {
        /* NOOP */
    }
    virtual ~Subject() {
        /* NOOP */
    };

    void addObserver( ProfileMngrInterface* p );
    void removeObserver( ProfileMngrInterface *p );

    void _insertCalled( BackupProfile *b );
    void _changeCalled( BackupProfile *b );
    void _removeCalled( QString s );
    bool _exists( QString s );
    void _restore( QString s );

private:
    virtual void insertCalled( BackupProfile *b ) = 0;
    virtual void changeCalled( BackupProfile *b ) = 0;
    virtual void removeCalled( QString s ) = 0;
    virtual bool existsCalled( QString s ) = 0;
    virtual void restoreCalled( QString s ) = 0;

protected:
    void _evilHack_SaveBackupProfile( BackupProfile* b );

private:
    QPtrList<ProfileMngrInterface> mTheProfileMngrInterfaces;
};
#endif
