/***************************************************************************
                          autocqdlg.cpp  -  description
                             -------------------
    begin                : Sat Aug 5 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <stdio.h>

#include "autocqdlg.h"
#include "globals.h"

autoCQdlg::autoCQdlg(QWidget *parent, const char *name, bool modal) : QSemiModal (parent,name,modal)
{
	setWFlags (WDestructiveClose);
	setCaption (i18n("Auto CQ"));
	seconds = 12;
  sec = 0;

	QHBoxLayout* hbox = new QHBoxLayout (this, 5);
	hbox->addSpacing (5);
	hbox->setSpacing (5);
	QLabel* l = new QLabel (this);
	l->setText (i18n ("Seconds until next Call: "));
	hbox->addWidget (l);
	text = new QLabel (this);
	text->setMinimumWidth (25);
	hbox->addWidget (text);
	QPushButton* b = new QPushButton (this);
	b->setText (i18n ("Cancel"));
	b->setDefault (true);
	b->setFocus();

  hbox->addWidget (b);
  hbox->addSpacing (5);

	QObject::connect (b, SIGNAL (clicked()), this, SLOT (close()));
	QTimer* timer = new QTimer(this);
	QObject::connect( timer, SIGNAL(timeout()), SLOT(slotCQTimeout()));
  timer->start (1000, false);
	slotCQTimeout();
}

autoCQdlg::~autoCQdlg()
{
}

void autoCQdlg::slotCQTimeout()
{
	if (kpsk->rxinfo.ptt == 0) {
		QString str;
		str.setNum (sec);
		sec = sec - 1;
		text->setText (str);
		if (sec < 0) {
			sec = seconds;
			kpsk->slotCQ();
		}
	}
}
