/***************************************************************************
                          personalsdlg.cpp  -  description
                             -------------------
    begin                : Tue Sep 26 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "personalsdlg.h"
#include "globals.h"
#include "myqlineedit.h"
#include <klocale.h>
#include <qlabel.h>
#include <qlayout.h>

personalsDlg::personalsDlg(QWidget *parent)
						 : KDialogBase(parent, "personalsDlg", true, i18n("Personals"), Ok|Cancel, Ok, true) {

	setWFlags (WDestructiveClose);
	QWidget* w;
	QLabel* l;
	QGridLayout* grid;

	w = new QWidget (this);
	setMainWidget (w);
	grid = new QGridLayout (w, 4, 2, 5, 5);
	upperValidator* validator = new upperValidator();

	callEdit = new QLineEdit (w);
	callEdit->setValidator (validator);
	callEdit->setFixedWidth (75);
  l = new QLabel( callEdit, i18n ("&Call:"), w);
	grid->addWidget (l, 0, 1, Qt::AlignRight);
	grid->addWidget (callEdit, 0, 2, Qt::AlignLeft);

	nameEdit = new QLineEdit (w);
  l = new QLabel( nameEdit, i18n ("&Name:"), w);
	grid->addWidget (l, 1, 1, Qt::AlignRight);
	grid->addWidget (nameEdit, 1, 2/*, Qt::AlignLeft*/);

	qthEdit = new QLineEdit (w);
  l = new QLabel( qthEdit, i18n ("&QTH:"), w);
	grid->addWidget (l, 2, 1, Qt::AlignRight);
	grid->addWidget (qthEdit, 2, 2/*, Qt::AlignLeft*/);

	locEdit = new QLineEdit (w);
	locEdit->setValidator (validator);
	locEdit->setFixedWidth(75);
  l = new QLabel( locEdit, i18n ("&Locator:"), w);
	grid->addWidget (l, 3, 1, Qt::AlignRight);
	grid->addWidget (locEdit, 3, 2, Qt::AlignLeft);

	setInitialSize (QSize(200, sizeHint().height()), true);

	/* and set the values */
	callEdit->setText (config.personals.call);
	locEdit->setText (config.personals.loc);
	qthEdit->setText (config.personals.qth);
	nameEdit->setText (config.personals.name);

}

personalsDlg::~personalsDlg()
{
}

void personalsDlg::slotOk()
{
	config.personals.call = callEdit->text();
	config.personals.loc = locEdit->text();
	config.personals.qth = qthEdit->text();
	config.personals.name = nameEdit->text();
  kpsk->reInit();
	KDialogBase::slotOk();
}
