/***************************************************************************
                          numberdialog.cpp  -  description
                             -------------------
    begin                : Don Apr 24 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "numberdialog.h"
#include "batchrenamer.h"

// Qt includes
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtooltip.h>

// KDE includes
#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>
#include <kpushbutton.h>

void KMyIntSpinBox::keyPressEvent( QKeyEvent* e )
{
    if( e->key() == Key_Return )
        emit returnPressed();
}

NumberDialog::NumberDialog(QValueList<int> n,QWidget *parent )
    : KDialogBase( KDialogBase::Plain, "KRename",
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent, 0, true, true )
{
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );

    QVBoxLayout* layout = new QVBoxLayout( plainPage(), 6, 6 );

    QGroupBox* group1 = new QGroupBox( plainPage() );
    group1->setTitle( i18n("&Numbering") );
    group1->setColumnLayout(0, Qt::Vertical );
    group1->layout()->setSpacing( 6 );
    group1->layout()->setMargin( 11 );
    QVBoxLayout* group1Layout = new QVBoxLayout( group1->layout() );
    group1Layout->setAlignment( Qt::AlignTop );
    
    spinIndex = new KIntNumInput( group1 );
    spinIndex->setMaxValue( SPINMAX );
    spinIndex->setLabel( i18n( "Start &index:" ), AlignLeft | AlignVCenter );

    spinStep = new KIntNumInput( spinIndex, 1, group1 );
    spinStep->setRange( -SPINMAX, SPINMAX, 1, false );
    spinStep->setValue( 1 );
    spinStep->setLabel( i18n( "Step &by:" ), AlignLeft | AlignVCenter );

    //checkResetCounter = new QCheckBox( i18n("&Reset counter for every directory"), group1 );
    
    QGroupBox* group2 = new QGroupBox( plainPage() );
    group2->setTitle( i18n("S&kip Numbers") );
    group2->setColumnLayout(0, Qt::Horizontal );
    group2->layout()->setSpacing( 6 );
    group2->layout()->setMargin( 11 );
    QHBoxLayout* group2Layout = new QHBoxLayout( group2->layout() );
    group2Layout->setAlignment( Qt::AlignTop );

    listNumbers = new KListBox( group2 );

    buttonAdd = new KPushButton( group2 );
    buttonAdd->setText( i18n( "&Add Number" ) );

    buttonRemove = new KPushButton( group2 );
    buttonRemove->setText( i18n( "&Remove Number" ) );

    spinNumber = new KMyIntSpinBox( group2 );
    spinNumber->setMaxValue( SPINMAX );
    spinNumber->setMinValue( -SPINMAX );
    spinNumber->setValue( 0 );
    spinNumber->setFocus();

    QVBoxLayout* layout2 = new QVBoxLayout( 0, 6, 6 );
    layout2->addWidget( buttonAdd );
    layout2->addWidget( buttonRemove );
    layout2->addWidget( spinNumber );
    layout2->addItem( spacer );
                                                                
    group1Layout->addWidget( spinIndex );
    group1Layout->addWidget( spinStep );
    //group1Layout->addWidget( checkResetCounter );
    
    group2Layout->addWidget( listNumbers );
    group2Layout->addLayout( layout2 );
    
    layout->addWidget( group1 );
    layout->addWidget( group2 );

    QToolTip::add( spinIndex, i18n( "Number of the first file.<br>The files are always numbered the same way as they are shown in the result list." ) );
    QToolTip::add( spinStep, i18n( "The counter is increased/decreased by this value." ) );
    QToolTip::add( listNumbers, i18n("Add all numbers that should be skipped by krename during the rename process.<br>"
    "E.g.: If 2 is skipped files will be numbered: file0, file1, file3, ...") );
    /*
    QToolTip::add( checkResetCounter, i18n("<qt>The counter is set to the start index in every directory. "
                                           "This setting applies to all used counters.</qt>" ) );
    */
    connect( buttonAdd, SIGNAL( clicked() ), this, SLOT( addNumber() ) );
    connect( buttonRemove,SIGNAL( clicked() ), this, SLOT( removeNumber() ) );
    connect( spinNumber, SIGNAL( returnPressed()), this, SLOT( addNumber() ) );
    
    for( unsigned int i = 0; i < n.count(); i++ )
            listNumbers->insertItem( QString("%1").arg(n[i]), -1 );

    update();
}

NumberDialog::~NumberDialog()
{
}

void NumberDialog::addNumber()
{
    QString tmp = QString("%1").arg(spinNumber->value());
    for( unsigned int i = 0; i < listNumbers->count(); i++ )
        if( listNumbers->text(i) == tmp )
            return;
    listNumbers->insertItem( tmp, -1 );
    sort();
}

void NumberDialog::removeNumber()
{
    unsigned int i = 0;
    do {
        if(listNumbers->isSelected( i )) {
            listNumbers->removeItem( i );
            listNumbers->setSelected( i-1, true );
            return;
        } else
            i++;
    } while( i < listNumbers->count() );
}

QValueList<int> NumberDialog::getList()
{
    QValueList<int> skip;
    for( unsigned int i = 0; i < listNumbers->count(); i++ )
        skip.append( listNumbers->text(i).toInt() );

    return skip;
}

void NumberDialog::sort()
{
    // Not very fast, but I hope it won't be used on ot big lists ;)
    if( listNumbers->count() < 1 )
        return;

    for( unsigned int i = 0; i < listNumbers->count()-1; i++) {
        if( listNumbers->text(i).toInt() > listNumbers->text(i+1).toInt() ) {
            QString tmp = listNumbers->text(i);
            listNumbers->removeItem(i);
            listNumbers->insertItem( tmp, i+1 );
            i = 0;
        }
    }
}
