<?php
/*
 * $Horde: kronolith/workweek.php,v 1.9.2.6 2005/01/03 11:25:58 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/WeekView.php';

$week = Horde::getFormData('week');
$year = Horde::getFormData('year');
if ($timestamp = Horde::getFormData('timestamp')) {
    $year = date('Y', $timestamp);
    $week = Kronolith::weekOfYear(date('d', $timestamp), date('m', $timestamp), $year);
}

$weekOb = new Kronolith_WeekView($week, $year, 0, 4);
$title = sprintf(_("Week %d"), $weekOb->week);
$js_onLoad = null;

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require KRONOLITH_TEMPLATES . '/javascript/print.inc';
} else {
    $print_link = Kronolith::addParameter('workweek.php', 'week=' . $week);
    $print_link = Kronolith::addParameter($print_link, 'year=' . $year);
    $print_link = Kronolith::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        include KRONOLITH_TEMPLATES . '/javascript/open_print_win.js';
    }

    require KRONOLITH_BASE . '/menu.php';
}

$weekOb->html(KRONOLITH_TEMPLATES);

require KRONOLITH_TEMPLATES . '/common-footer.inc';
