/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeconfiguration.h"
#include "xeobject.h"
#include <kstandarddirs.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <qdir.h>
#include <qlibrary.h>

#include <stdlib.h>

#define ENABLE_FINAL


XEConfiguration::XEConfiguration(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xSetEngineConfiguration(this);
	
	xReset();
}


XEConfiguration::~XEConfiguration()
{
}


#include "xeconfiguration.moc"


/*!
    \fn XEConfiguration::xReset()
 */
void XEConfiguration::xReset()
{

	ActiveConfiguration.Version=KXDOCKERVERSION;
	ActiveConfiguration.Icons.Size=32;
	ActiveConfiguration.Icons.SizeBig=128;
	ActiveConfiguration.Icons.Separation=5;
	ActiveConfiguration.Icons.Raise=-50;
	ActiveConfiguration.Icons.Horiz=32;
	ActiveConfiguration.Icons.EnableThumbnail=0;
	
	
	ActiveConfiguration.Window.borderLeft=200;
	ActiveConfiguration.Window.borderTop=200;
	ActiveConfiguration.Window.Width=1024;
	ActiveConfiguration.Window.Height=300;
	ActiveConfiguration.Window.Top=100;
	ActiveConfiguration.Window.Left=0;
	ActiveConfiguration.Window.HeightDesktop=40;
	ActiveConfiguration.Window.LeftForce=0;
	ActiveConfiguration.Window.TopForce=0;
	
	ActiveConfiguration.Window.HideTimeout=0;
	ActiveConfiguration.Window.HideMouseEdge=1;
	
	
	ActiveConfiguration.Window.SendToForgroundTimeout=500;
	ActiveConfiguration.Window.RaiseOnEvents=0;
	
	
	ActiveConfiguration.Engine.SmoothTimeout=200;
	//strcpy(ActiveConfiguration.Engine.XMLConf,"kxdocker_conf.xml");
	KConfig *cfg=KGlobal::config();
	//cfg->setGroup("");
	ActiveConfiguration.Engine.XMLConf=cfg->readEntry("KXDockerXMLConf","kxdocker/kxdocker_conf.xml");
	if(ActiveConfiguration.Engine.XMLConf=="" 
		||ActiveConfiguration.Engine.XMLConf==NULL
		||ActiveConfiguration.Engine.XMLConf==QString::null)
	{
		ActiveConfiguration.Engine.XMLConf="kxdocker/kxdocker_conf.xml";
	}
	ActiveConfiguration.Engine.XMLConf=::locate("data",ActiveConfiguration.Engine.XMLConf);
#ifndef ENABLE_FINAL
	qWarning(ActiveConfiguration.Engine.XMLConf);
#endif
	QFile a(ActiveConfiguration.Engine.XMLConf);
	if(!a.exists() || ActiveConfiguration.Engine.XMLConf==QString::null)
	{
		QString cfgPath="kxdocker/kxdocker_conf.xml";
		ActiveConfiguration.Engine.XMLConf=::locate("data",cfgPath);
		if(ActiveConfiguration.Engine.XMLConf==NULL)
		{
			KFileDialog fd(QString::null,QString::null,0,"openXMLConf",true);
			cfgPath=fd.getOpenFileName(QString::null,QString::null,0,"Open KXDocker XML Configuration");
			ActiveConfiguration.Engine.XMLConf=::locate("data",cfgPath);
			if(ActiveConfiguration.Engine.XMLConf==NULL)
			{
				qWarning("cannot find kxdocker_conf.xml");
				exit(1);
			}
		}
		cfg->writeEntry("KXDockerXMLConf",ActiveConfiguration.Engine.XMLConf);
	}
	
	// checkout if resources are correctly installed
	QString ResourcesPath=QString("kxdocker/kxdocker_resources-%1").arg(KXDOCKERNEED);
	ResourcesPath=::locate("data",ResourcesPath);
	if(!a.exists() || ResourcesPath==QString::null)
	{
		qWarning("You may need to update or reinstall KXDocker resources, checkout http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download#resources");
	}
	
	ActiveConfiguration.Engine.SleepFPS=100;
	ActiveConfiguration.Engine.SleepThreads=1000;
	ActiveConfiguration.Engine.SleepAnimations=1000;
//	ActiveConfiguration.Engine.StaticIconsShowed=0;
	ActiveConfiguration.Engine.MaxIconsShowed=MAX_ICONS;
	ActiveConfiguration.Engine.AndZoomCache=0;
	
	
	ActiveConfiguration.Matrix.Design="realosx";
//	strcpy(ActiveConfiguration.Window.Align,"bottom");
	ActiveConfiguration.Window.Align="bottom";

	QString backgroundPath="kxdocker/themes/bar/default/";
	ActiveConfiguration.Theme.ArrowsPath="kxdocker/themes/arrows/";
	
	ActiveConfiguration.Theme.BackgroundPath=::locate("data",backgroundPath);
	if(ActiveConfiguration.Theme.BackgroundPath==NULL)
	{
#ifndef ENABLE_FINAL
		qWarning("Cannot find background themes!");
#endif
		ActiveConfiguration.Theme.BackgroundPath="kxdocker/themes/bar/default";
	}
	ActiveConfiguration.Theme.Background.Tiled=1;
	ActiveConfiguration.Theme.Background.imgBackgroundCenter="background-center.png";
	ActiveConfiguration.Theme.Background.imgBackgroundLeft="background-left.png";
	ActiveConfiguration.Theme.Background.imgBackgroundRight="background-right.png";
	ActiveConfiguration.Theme.Background.imgBackgroundOver="background-over.png";
	
	ActiveConfiguration.Plugins.PluginsPaths.clear();
	
#ifdef ENABLE_SPECIALENGINE2
	ActiveConfiguration.Engine.InterpolationValue=2;
#endif
	ActiveConfiguration.Window.SendToBackground=1;
	
	ActiveConfiguration.ConfigurationsPaths.clear();
	ActiveConfiguration.ConfigurationsPaths.append("kxdocker/xml/");
}


/*!
    \fn XEConfiguration::xGetConfiguration()
 */
XSConfigurations * XEConfiguration::xGetConfiguration()
{
	return &ActiveConfiguration;
}


/*!
    \fn XEConfiguration::xCfgDefault()
 */
void XEConfiguration::xCfgDefault()
{
    /// @todo implement me
}


/*!
    \fn XEConfiguration::xSetup()
 */
void XEConfiguration::xSetup()
{
    /// @todo implement me
}


/*!
    \fn XEConfiguration::iconRemove(int)
 */
void XEConfiguration::iconRemove(int icon)
{
	// removing all dead info
	ActiveConfiguration.ObjectsIcons.remove(icon);
	return;
}


/*!
    \fn XEConfiguration::xLoadModules();
 */
void XEConfiguration::xLoadModules()
{
	for(unsigned int i=0;i<ActiveConfiguration.ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration.ObjectsIcons.at(i)->Info.className!="GIcon")
		{
			QObject *GClass
				=
				XEObject::xFindObject(
					ActiveConfiguration.ObjectsIcons.at(i)->Info.className
				);
			if(GClass==NULL)
			{
#ifndef ENABLE_FINAL
				qWarning("xeconfiguration.cpp:194 Module not found, try to load it...");
#endif
				xLoadModule(ActiveConfiguration.ObjectsIcons.at(i)->Info.className);
			}
			else
			{
#ifndef ENABLE_FINAL
				qWarning("xeconfiguration.cpp:199 Module FOUND!");
#endif
			}
		}
	}
}

typedef QObject *(*pPluginGenerator)(QObject *parent);

/*!
    \fn XEConfiguration::xLoadModule(const QString moduleName)
 */
void XEConfiguration::xLoadModule(const QString moduleName)
{
#ifndef ENABLE_FINAL
	qWarning("xeconfiguration.cpp:212 try to loading a new module");
	qWarning(moduleName);
#endif
	for(unsigned int i=0; i<ActiveConfiguration.Plugins.PluginsPaths.count();i++)
	{
		pPluginGenerator PluginGenerator;
		
		if (ActiveConfiguration.Plugins.PluginsPaths[i]
			[ActiveConfiguration.Plugins.PluginsPaths[i].length()-1]!='/')
				ActiveConfiguration.Plugins.PluginsPaths[i]=
				ActiveConfiguration.Plugins.PluginsPaths[i]+"/";

		QString SOName=::locate("data",ActiveConfiguration.Plugins.PluginsPaths[i]);
		SOName=SOName+moduleName+
		//ActiveConfiguration.Plugins.SOName;
		".so";
#ifndef ENABLE_FINAL
		qWarning(SOName);
#endif
PluginGenerator=(pPluginGenerator)QLibrary::resolve(SOName,"xeplugin_register");
		if(PluginGenerator)
		{
#ifndef ENABLE_FINAL
			qWarning("found the right so, now running it");
#endif
			//QObject *LoadedModule=PluginGenerator(parent());
			//QObject *LoadedModule=PluginGenerator(XEObject::xGetDocker());
			QObject *LoadedModule=PluginGenerator(XEObject::xGetRoot());
			if(LoadedModule)
			{
#ifndef ENABLE_FINAL
qWarning("yea i've loaded it!!");
qWarning(LoadedModule->name());
#endif
			XEObject::xPluginAdd(LoadedModule);
			}
			return;
		}
		else
		{
#ifndef ENABLE_FINAL
			qWarning("NOT found the right so");
#endif
		}
	}
}


/*!
    \fn XEConfiguration::pluginRemove(const QString)
 */
void XEConfiguration::pluginRemove(const QString removeName)
{
	for(int k=0;k<ActiveConfiguration.Plugins.Plugin.count();k++)
	{
		if(ActiveConfiguration.Plugins.Plugin.at(k)->Info.Name=removeName)
		{
			ActiveConfiguration.Plugins.Plugin.remove(k);
			return;
		}
	}
}


/*!
    \fn XEConfiguration::pluginAdd(const QString)
 */
void XEConfiguration::pluginAdd(const QString newName)
{
	XSGObjectPlugin	*newPlugin=new XSGObjectPlugin();
	newPlugin->Info.Name=newName;

			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			newPlugin->xmlConfiguration=fakeRoot.childNodes();//fa	
	

	ActiveConfiguration.Plugins.Plugin.append(newPlugin);
}
