/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LADCCA_EVENT_H__
#define __LADCCA_EVENT_H__

#include <uuid/uuid.h>

#include <ladcca/ladcca.h>

#ifdef __cplusplus
extern "C" {
#endif

cca_event_t * cca_event_new           (void);
cca_event_t * cca_event_new_with_type (enum CCA_Event_Type type);
cca_event_t * cca_event_new_with_all  (enum CCA_Event_Type type, const char * string);
void          cca_event_destroy       (cca_event_t * event);

enum CCA_Event_Type  cca_event_get_type      (const cca_event_t * event);
const char *         cca_event_get_string    (const cca_event_t * event);
const char *         cca_event_get_project   (const cca_event_t * event);
void                 cca_event_get_client_id (const cca_event_t * event, uuid_t id);
 
void cca_event_set_type      (cca_event_t * event, enum CCA_Event_Type type);
void cca_event_set_string    (cca_event_t * event, const char * string);
void cca_event_set_project   (cca_event_t * event, const char * project);
void cca_event_set_client_id (cca_event_t * event, uuid_t id);

/* set the type to CCA_Alsa_Client_ID, and the string to { <id>, '\0' } */
void cca_event_set_alsa_client_id (cca_event_t * event, unsigned char alsa_id);
unsigned char cca_event_get_alsa_client_id (const cca_event_t * event);

void cca_str_set_alsa_client_id (char * str, unsigned char alsa_id);
unsigned char cca_str_get_alsa_client_id (const char * str);

#ifdef __cplusplus
}
#endif

#endif /* __LADCCA_EVENT_H__ */
