/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <ladcca/ladcca.h>
#include <ladcca/internal_headers.h>

#include "server_event.h"

void
server_event_init (server_event_t * event)
{
  event->type      = 0;
  event->conn_id   = 0;
  event->data.cca_event = NULL;
}

static void
server_event_free_data (server_event_t * event)
{
  if (event->data.cca_event)
    {
      switch (event->type)
        {
        case Client_Connect:
          cca_connect_params_destroy (event->data.cca_connect_params);
          break;
        case Client_Event:
          cca_event_destroy (event->data.cca_event);
          break;
        case Client_Config:
          cca_config_destroy (event->data.cca_config);
          break;
        case Client_Comm_Event:
          cca_comm_event_destroy (event->data.cca_comm_event);
      }
      event->data.cca_event = NULL;
    }
}

void
server_event_free (server_event_t * event)
{
  server_event_free_data (event);
  event->type      = 0;
  event->conn_id   = 0;
}

server_event_t *
server_event_new ()
{
  server_event_t * event;
  event = cca_malloc (sizeof (server_event_t));
  server_event_init (event);
  return event;
}

void
server_event_destroy (server_event_t * event)
{
  server_event_free (event);
  free (event);
}

void
server_event_set_type (server_event_t * event, enum Server_Event_Type type)
{
  event->type = type;
}

void
server_event_set_conn_id   (server_event_t * event, unsigned long id)
{
  event->conn_id = id;
}

void
server_event_set_cca_event (server_event_t * event, cca_event_t * cca_event)
{
  server_event_free_data (event);
  
  event->type = Client_Event;
  event->data.cca_event = cca_event;
}

void
server_event_set_cca_config (server_event_t * event, cca_config_t * cca_config)
{
  server_event_free_data (event);
  
  event->type = Client_Config;
  event->data.cca_config = cca_config;
}


void
server_event_set_cca_comm_event (server_event_t * event, cca_comm_event_t * cca_comm_event)
{
  server_event_free_data (event);
  
  event->type = Client_Comm_Event;
  event->data.cca_comm_event = cca_comm_event;
}

void
server_event_set_cca_connect_params (server_event_t *event, cca_connect_params_t * params)
{
  server_event_free_data (event);

  event->type = Client_Connect;
  event->data.cca_connect_params = params;
}

cca_event_t *
server_event_take_cca_event (server_event_t * event)
{
  cca_event_t * cca_event;
  cca_event = event->data.cca_event;
  event->data.cca_event = NULL;
  return cca_event;
}

cca_config_t *
server_event_take_cca_config (server_event_t * event)
{
  cca_config_t * cca_config;
  cca_config = event->data.cca_config;
  event->data.cca_config = NULL;
  return cca_config;
}

cca_comm_event_t *
server_event_take_cca_comm_event (server_event_t * event)
{
  cca_comm_event_t * cca_comm_event;
  cca_comm_event = event->data.cca_comm_event;
  event->data.cca_comm_event = NULL;
  return cca_comm_event;
}

cca_connect_params_t *
server_event_take_cca_connect_params (server_event_t * event)
{
  cca_connect_params_t * params;
  params = event->data.cca_connect_params;
  event->data.cca_connect_params = NULL;
  return params;
}

/* EOF */

