/***************************************************************************
                          lbutton.cpp  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <lineak/lbutton.h>

LButton::LButton() : LObject(snull, PRESS, BUTTON) {
	button = 0;
}
LButton::~LButton() {}
LButton::LButton(string name, unsigned int ibutton) : LObject(name, PRESS, BUTTON), button(ibutton) {
}
void LButton::print(ostream&out)  {
   if (name != snull) {
   	out << "Object: " << name << endl;
	out << "   event_type = " << getEventTypeString() << endl;
	out << "   type = " << getTypeString() << endl;
	out << "   button = " << button << endl;
	//out << "   modifier = " << getModifierString() << endl;
	//out << "   modifier numeric = " << modifier << endl;
	if (!isToggle()) {
		out << "   toggle = false" << endl;
	        for (map<unsigned int,LCommand>::iterator i = commands.begin(); i!= commands.end(); i++) {
			out << "   modifier = " << LObject::getModifierString((i->first));
			out << " and command = " << commands[(i->first)];
			out << "   and display name = " << commandDisplayNames[(i->first)] << endl; 
		}
		//out << "   and command = " << commands[name] << endl;
	}
	else {
		out << "   toggle = true" << endl;
		for (map<string,LCommand>::const_iterator i = tog_commands.begin(); i != tog_commands.end(); i++) {
			out << "    for togglename = " << i->first << " command = " << i->second << endl;
		        out << "    and display name = " << tog_commandDisplayNames[i->first] << endl;
		}
		//out << "   and command = " << commands[name] << endl;
	}
        out << endl;
   } else
      cerr << "Attempting to output an empty button!" << endl;
}

ostream & operator<<(ostream &out, LButton &rhs) {
   rhs.print(out);
   return out;
}
