/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JT44CardReceive_H
#define	JT44CardReceive_H

#include "JT44Receive.h"
#include "JT44Levels.h"
#include "JT44Message.h"

class CJT44CardReceive : public CJT44Receive {

    public:
	CJT44CardReceive(CSoundDev* soundDev);
	virtual ~CJT44CardReceive();

	virtual void openSoundDevice();

	virtual CSoundDev* getSoundDevice()
	{
		wxASSERT(m_soundDev != NULL);
		return m_soundDev;
	}

	virtual void closeSoundDevice();

	virtual bool getEndTime();

	virtual void recordAudio(const wxString& id, double* audioData, int length) const;
	virtual void showLevels(CJT44Levels* levels) const;
	virtual void receiveMessage(CJT44Message* message) const;

	virtual wxString createId();

	virtual void error(const wxString& text);

    private:
	CSoundDev* m_soundDev;
};

#endif
