/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44MessageEvent.h"

CJT44MessageEvent::CJT44MessageEvent(CJT44Message* message, wxEventType type, int id) :
wxEvent(id, type),
m_message(message)
{
}

CJT44MessageEvent::CJT44MessageEvent(const CJT44MessageEvent& event) :
wxEvent(event),
m_message(event.m_message)
{
}

CJT44MessageEvent::~CJT44MessageEvent()
{
}

CJT44Message* CJT44MessageEvent::getMessage() const
{
	return m_message;
}

wxEvent* CJT44MessageEvent::Clone() const
{
	return new CJT44MessageEvent(*this);
}
