/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "jt6m/JT6MLookups.h"
#include "jt6m/JT6MDefs.h"

#include "JT6MFoldMessages.h"

CJT6MFoldMessages::CJT6MFoldMessages(int n) :
m_n(n),
m_pos(0),
m_alphabet(NULL)
{
	wxASSERT(n > 0 && (n % 2) == 0);

	m_alphabet = new CAverage[m_n * JT6M_ALPHABET_COUNT];
}

CJT6MFoldMessages::~CJT6MFoldMessages()
{

	delete[] m_alphabet;
}

void CJT6MFoldMessages::addBins(int pos, double* bins)
{
	wxASSERT(bins != NULL);
	wxASSERT(pos >= 0);

	if ((pos % 3) == 2) {	// Sync data
		fprintf(stderr, "Fold message with (pos %% 3) == 2\n");
		return;
	}

	for (int i = 0; i < JT6M_ALPHABET_COUNT; i++)
		m_alphabet[m_pos * JT6M_ALPHABET_COUNT + i].addValue(bins[i]);

	m_pos = (m_pos + 1) % m_n;
}

wxString CJT6MFoldMessages::getMessage()
{
	wxString message;

	for (int pos = 0; pos < m_n; pos++) {
		int   bestLetter = 0;
		double bestValue = m_alphabet[pos * JT6M_ALPHABET_COUNT + 0].getAverage();

		for (int letter = 1; letter < JT6M_ALPHABET_COUNT; letter++) {
			double val = m_alphabet[pos * JT6M_ALPHABET_COUNT + letter].getAverage();

			if (val > bestValue) {
				bestValue  = val;
				bestLetter = letter;
			}
		}

		CJT6MLookups lookups;
		wxChar c = lookups.lookupTone(bestLetter + 1);

		message.Append(c);
	}

	return message;
}
