#
# $Id: Robot.pm,v 1.1 2004/05/24 15:24:34 flacoste Exp $
#
# Copyright (C) 2001 Stichting LogReport Foundation <logreport@logreport.org>
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html or write to the Free Software
#     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
#
package Lire::WWW::Domain::Robot;

use strict;
use vars qw/ $REVISION/;

{
    $REVISION  = '$Id: Robot.pm,v 1.1 2004/05/24 15:24:34 flacoste Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %RobotHash = (
  ".googlebot.com" => "Google (http://www.google.com/)",
  ".sv.av.com" => "Altavista (http://www.altavista.com/)",
  ".fastsearch.net" => "FastSearch (http://www.fastsearch.net/)",
  ".excite.com" => "Excite (http://www.excite.com/)",
  ".inktomi.com" => "Inktomi (http://www.inktomi.com/)",
  ".teoma.com" => "Teoma (http://www.teoma.com/)",
  ".directhit.com" => "DirectHit (http://www.directhit.com/)",
  ".alexa.com" => "Alexa (http://www.alexa.com/)",
);

# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getRobot {
    my ( $domain ) = @_;

    $domain = lc $domain;
    foreach my $robot (keys %RobotHash) {
	return $RobotHash{$robot} if index( $domain, $robot ) >= 0;
    }
    return undef;
}

1;

