//
//  Login.app
// 
//  Copyright (c) 1997, 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _Input_h_
#define _Input_h_

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <iostream.h>
#include "Const.h"
#include "Config.h"
#include "Passwords.h"


class Input
{
public:
    Input();
    ~Input();
    char Key(char ascii, KeySym keysym);
    int GetAction();
    int GetField();
    char* GetName();
    char* GetHiddenPasswd();
    struct passwd* GetPasswdStruct();
    void Reset();

private:
    void Add(char ascii);
    char DeleteLast();
    int Correct();
    int SpecialWanted();
    int SpecialCorrect(int special);

    char NameBuffer[INPUT_MAXLENGTH_NAME];
    char PasswdBuffer[INPUT_MAXLENGTH_PASSWD];
    char HiddenPasswdBuffer[INPUT_MAXLENGTH_PASSWD];
    int Action;
    int Field;
};

#endif

