#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>

#include "err.h"

int
main(int argc,char * argv[]) {

  int l,j,k;
  char *o1,*o,*oe;
  struct stat ss;

  if (argc!=4)
    errret("Usage: %s <file> <old string> <new string>\n");

  if (stat(argv[1],&ss))
    errret("Cannot stat %s\n",argv[1]);

  if ((l=open(argv[1],O_RDWR))<0)
    errret("Cannot open %s\n",argv[1]);
  j=strlen(argv[2]);
  k=strlen(argv[3]);
  
  if (k>j)
     errret("length of old string must be > length of new string\n");
     
  if ((o1=mmap(0,ss.st_size,PROT_READ|PROT_WRITE,MAP_SHARED,l,0))==(char *)-1)
    errret("Cannot mmap %s\n",argv[1]);
  oe=o1+ss.st_size;

  for (o=o1;o<oe && (o=memchr(o,*argv[2],oe-o));o++) {
    
    if (oe-o>=j && !memcmp(o,argv[2],j)) {
      memcpy(o,argv[3],k);
      memset(o+k,0,j-k);
    }
    
  }

  return 0;

}
    
