/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef SNIPES_ENEMIES

#define SNIPES_ENEMIES

#include "snipes.h"
#include "coords.h"

void init_enemies( int color, int probability, int enable_ghosts,
		   int max_enemies );
int get_num_live_enemies( int type );
int get_num_dead_enemies( int type );
void add_enemy( coordinate p, char type );
void show_enemies( screen_coords *sc );
void move_enemies( screen_coords *sc );

#endif // SNIPES_ENEMIES
