// Copyright (c) 2002 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

#ifndef LIBCAPSI_NETWORK_LISTENER_H
#define LIBCAPSI_NETWORK_LISTENER_H

#include <sys/types.h>
     
#include <string>
#include <vector>

class ListenPort;
class Socket;

#define	LISTENQ	1024

class Listener
{
public:
	Listener();
	virtual ~Listener();

	/*
	 * Add a listen port. Returns -1 on failure, 0 on success.
	 */
	int addListenPort(const int port);

	void do_select();
	Socket *findSocket(unsigned int fd);
		
private:
	Socket *newSocket(unsigned int fd);
	void delSocket(Socket *socket);

	fd_set m_fdset;

	std::vector<Socket *> m_sockets;
	std::vector<ListenPort *> m_listenPorts;
};

extern void socketHandler(Socket *, std::string data);

#endif
