/***************************************************************************
 $RCSfile: ctinitializer.cpp,v $
                             -------------------
    cvs         : $Id: ctinitializer.cpp,v 1.1 2003/04/24 01:43:28 aquamaniac Exp $
    begin       : Wed Apr 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif


#include "ctinitializer.h"
#include "libchipcard.h"



CTInitializer::CTInitializer()
  :_isOpen(false)
{
}


CTInitializer::~CTInitializer(){
  _isOpen=false;
  ChipCard_Fini();
}


int CTInitializer::initialize(const char *cfgfile,
			      const char *section) {
  int rv;

  if (_isOpen)
    return CHIPCARD_SUCCESS;
  rv=ChipCard_Init(cfgfile, section);
  if (rv!=CHIPCARD_SUCCESS)
    return rv;
  _isOpen=true;
  return CHIPCARD_SUCCESS;
}




