/* $Id: stubs.c,v 1.1 2002/11/28 18:35:12 cegger Exp $
******************************************************************************

   Wmh extension stubs.

   Copyright (C) 1999 Andreas Beck - becka@ggi-project.org
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>

#include <ggi/internal/wmh.h>

/* Move the current window to position x,y on the root window.
 */
int ggiWmhMove		(ggi_visual_t vis,int x,int y)
{	return LIBGGI_WMHEXT(vis)->move(vis,x,y); }

/* Get the current position of the window on the root window
 */
int ggiWmhGetPos	(ggi_visual_t vis,int *x,int *y)
{	return LIBGGI_WMHEXT(vis)->getpos(vis,x,y); }

/* Resize the window. Note, that this _does_not_ resize the visual.
 */
int ggiWmhResize	(ggi_visual_t vis,int x,int y)
{	return LIBGGI_WMHEXT(vis)->resize(vis,x,y); }

/* Get the current window size as given by the window system.
 */
int ggiWmhGetSize	(ggi_visual_t vis,int *x,int *y)
{	return LIBGGI_WMHEXT(vis)->getsize(vis,x,y); }

/* Set the window title.
 */
int ggiWmhSetTitle	(ggi_visual_t vis,const char *title)
{	return LIBGGI_WMHEXT(vis)->settitle(vis,title); }

/* Moving/Resizing the window
 */
int ggiWmhMaximize	(ggi_visual_t vis,int xperc,int yperc)
{	return LIBGGI_WMHEXT(vis)->maximize(vis,xperc,yperc); }

/* Move the window in the window stack
 */
int ggiWmhZOrder	(ggi_visual_t vis,enum ordercmd command)
{	return LIBGGI_WMHEXT(vis)->zorder(vis,command); }



/* Icon stuff.
 */
int ggiWmhIconify	(ggi_visual_t vis,int icon)
{	return LIBGGI_WMHEXT(vis)->iconify(vis,icon); }

int ggiWmhMoveIcon	(ggi_visual_t vis,int x,int y)
{	return LIBGGI_WMHEXT(vis)->moveicon(vis,x,y); }

int ggiWmhSetIconTitle	(ggi_visual_t vis, const char *title)
{	return LIBGGI_WMHEXT(vis)->seticontitle(vis,title); }

int ggiWmhAllowResize	(ggi_visual_t vis,int xmin,int ymin,int xmax,int ymax,int xstep,int ystep)
{	return LIBGGI_WMHEXT(vis)->allowresize(vis,xmin,ymin,xmax,ymax,xstep,ystep); }
