/*
  GNU-Classpath Extensions: JMI
  Copyright (C) 2004 Free Software Foundation, Inc.

  For more information on the GNU Classpathx project please mail:
  classpathx-discuss@gnu.org

  This file is part of GNU JMI

  GNU JMI is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  GNU JMI is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with program; see the file COPYING. If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

package javax.jmi.reflect;

import java.io.Serializable;

public class JmiException extends RuntimeException
  implements Serializable
{
  
  protected Object objectInError;

  protected RefObject elementInError;

  public JmiException()
  {
    super();
  }

  public JmiException(String msg)
  {
    super(msg);
  }

  public JmiException(Object objectInError,
                      RefObject elementInError)
  {
    super();
    this.objectInError = objectInError;
    this.elementInError = elementInError;
  }

  public JmiException(Object objectInError,
                      RefObject elementInError,
                      String msg)
  {
    super(msg);
    this.objectInError = objectInError;
    this.elementInError = elementInError;
  }

  public JmiException(RefObject elementInError)
  {
    super();
    this.elementInError = elementInError;
  }

  public JmiException(RefObject elementInError,
                      String msg)
  {
    super(msg);
    this.elementInError = elementInError;
  }

  public RefObject getElementInError()
  {
    return this.elementInError;
  }

  public Object getObjectInError()
  {
    return this.objectInError;
  }

}
