/************************************************************************
 * $Id: astro.h,v 1.6 2004/09/29 18:39:11 thamer Exp $
 *
 * ------------
 * Description:
 * ------------
 *  Copyright (c) 2003, Arabeyes, Thamer Mahmoud
 *
 *  A full featured Muslim Prayer Times calculator
 *
 *
 * -----------------
 * Revision Details:    (Updated by Revision Control System)
 * -----------------
 *  $Date: 2004/09/29 18:39:11 $
 *  $Author: thamer $
 *  $Revision: 1.6 $
 *  $Source: /home/arabeyes/cvs/projects/itl/libs/prayertime/src/astro.h,v $
 *
 * (www.arabeyes.org - under LGPL license - see COPYING file)
 ************************************************************************/

#ifndef _ASTRO_
#define _ASTRO_

#include "prayer.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Defaults */
#define INVALID_TRIGGER -.999
#define PI 3.1415926535898
#define DEG_TO_10_BASE 1/15.0
#define CENTER_OF_SUN_ANGLE -0.833370
#define ALTITUDE_REFRACTION 0.0347
#define REF_LIMIT 9999999

/* UTILITIES */
#define DEG_TO_RAD(A) (A * (PI/180.0)) 
#define RAD_TO_DEG(A) (A / (PI/180.0))


    typedef struct
    {
        double jd;
        double dec[3];
        double ra[3];
        double sid[3];
        double dra[3];
        double rsum[3];
        
    } Astro ;

    
    void getAstroValuesByDay(double julianDay, const Location* loc, Astro* astro, 
                             Astro* topAstro);
    double getRefraction(const Location* loc, double sunAlt);
    double getJulianDay(const Date* date, double gmt);
    double limitAngle180(double L);
    double limitAngle(double L);
    double limitAngle111(double L);
    double limitAngle180between(double L);
  
#ifdef  __cplusplus
}
#endif

#endif  /* _ASTRO_ */
