/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.soap.web.jetty;

import java.util.Map;

import javax.management.remote.JMXServiceURL;

import mx4j.tools.remote.soap.web.WebContainer;
import org.apache.axis.transport.http.AxisServlet;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.util.MultiException;

/**
 * Jetty's implementation of WebContainer interface
 * @author <a href="mailto:a_taherkordi@users.sourceforge.net">Alireza Taherkordi</a>
 * @version $Revision: 1.3 $
 */
public class JettyWebContainer implements WebContainer
{
   private final Server server;

   public JettyWebContainer() throws Exception
   {
      server = new Server();
   }

   public void start(JMXServiceURL url, Map environment) throws Exception
   {
      server.addListener(":" + url.getPort());
      ServletHttpContext context = (ServletHttpContext)server.getContext("/");

      String path = url.getURLPath();
      String urlPattern = null;
      int lastSlash = path.lastIndexOf('/');
      if (lastSlash < 0)
         urlPattern = "/*";
      else
         urlPattern = path.substring(0, lastSlash + 1) + "*";

      context.addServlet(urlPattern, AxisServlet.class.getName());

      try
      {
         server.start();
      }
      catch (MultiException x)
      {
         x.ifExceptionThrow();
      }
   }

   public void stop() throws Exception
   {
      server.stop();
   }
}
