/***************************************************************************
 $RCSfile: accountparams.h,v $
                             -------------------
    cvs         : $Id: accountparams.h,v 1.12 2002/08/02 09:29:29 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef ACCOUNTPARAMS_H
#define ACCOUNTPARAMS_H

namespace HBCI {
  class accountParams;
}

#include <string>
#include <list>
#include <openhbci/value.h>
#include <openhbci/updjob.h>


namespace HBCI {
/**
 * @short Stores all data sent to us by the bank as account parameters.
 *
 * This class should only be visible inside OpenHBCI -- all external
 * applications are only supposed to use the interface class
 * Acccount.
 *
 * @author Martin Preuss<openhbci@aquamaniac.de> */
class DLLIMPORT accountParams {
friend class SEGUserParameter;
private:
    string _accountNumber;
    string _accountSuffix;
    int _countryCode;
    string _instituteCode;
    string _userId;
    string _name1;
    string _name2;
    string _accountName;
    string _currency;
    char _limitType;
    Value _limitValue;
    int _limitDays;
    list<updJob> _allowedJobs;

    void _fromString(const string &s);

public:
    accountParams();
    accountParams(const accountParams &p);
    accountParams(int c, const string &inst,
                  const string &nr,
                  const string &subid);
    ~accountParams();

    /** obviously the number of your accountParams="Kontonummer" */
    const string &accountNumber() const { return _accountNumber;};
    void setAccountNumber(const string &s) { _accountNumber=s;};

    /** new in HBCI 2.2, only set this field if your institute tells you to */
    const string &accountSuffix() const { return _accountSuffix;};
    void setAccountSuffix(const string &s) { _accountSuffix=s;};

    /** countrycode (280 for Germany) */
    int countryCode() const { return _countryCode;};
    void setCountryCode(int i) { _countryCode=i;};

    /** "Bankleitzahl" */
    const string &instituteCode() const { return _instituteCode;};
    void setInstituteCode(const string &s) { _instituteCode=s;};

    /** the id you institute assigned to you for this accountParams */
    const string &userId() const { return _userId;};
    void setUserId(const string &s) {_userId=s;};

    /** your name */
    const string &name1() const { return _name1;};
    void setName1(const string &s) { _name1=s;};

    /** and an alternative on ;-) */
    const string &name2() const { return _name2;};
    void setName2(const string &s) { _name2=s;};

    /** name of your account, is set by your institute */
    const string &accountName() const { return _accountName;};
    void setAccountName(const string &s) { _accountName=s;};

    /** default currency of your account (DEM, EUR)*/
    const string &currency() const { return _currency;};
    void setCurrency(const string &s) { _currency=s;};

    /** dont know exactly what that is, just ignore it for now */
    char limitType() const { return _limitType;};
    void setLimitType(char c) { _limitType=c;};

    const Value &limitValue() const { return _limitValue;};
    void setLimitValue(const Value &v) { _limitValue=v;};

    int limitDays() const { return _limitDays;};
    void setLimitDays(int i) { _limitDays=i;};

    /** a list of allowed jobs, not used for now */
    const list<updJob> &allowedJobs() const;
    void addJob(const updJob &u);

    string dump() const;

};


} /* namespace HBCI */

#endif


