/* outboxjob.cpp

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"

#include "outboxjob.h"
#include <accountjobs.h>

namespace HBCI {

OutboxJob::OutboxJob(Pointer<Customer> c)
    :_status(HBCI_JOB_STATUS_TODO)
    ,_id(0)
    ,_cust(c)
    ,_result(HBCI_JOB_RESULT_NONE)
{
    _cust.setDescription("OutboxJob::_cust");
    _bank.setDescription("OutboxJob::_bank");
    if (!c.isValid())
        fprintf(stderr,"OutboxJob: invalid customer pointer.\n");
    else {
        _bank=c.ref().user().ref().bank();
    }
}


OutboxJob::~OutboxJob(){
}


void OutboxJob::addSigner(Pointer<Customer> c){
    _signers.push_back(c);
}


void OutboxJob::addSignersToQueue(Pointer<MessageQueue> q) const {
    list<Pointer<Customer> >::const_iterator it;

    for (it=_signers.begin();
         it!=_signers.end();
         it++) {
        q.ref().addSigner(*it);
    } // for
}


list<int> OutboxJob::resultCodesFromJob(const Job& job)
{
  list<int> res;
  list<Job::segResponse> jobres = job.getSegmentResponse();
  for (list<Job::segResponse>::const_iterator it = jobres.begin() ;
       it != jobres.end() ;  it++)
    res.push_back((*it).code);
  return res;
}


void OutboxJob::setMessageReference(const MessageReference &ref) {
  _msgReference=ref;
}


int OutboxJob::segmentForStatusReport() const {
  return -1;
}



} // namespace  HBCI

void HBCI_OutboxJob_delete(HBCI_OutboxJob *j)
{
    delete j;
}
void HBCI_OutboxJob_addSigner(HBCI_OutboxJob *j, const HBCI_Customer *c)
{
    assert(j);
    assert(c);
    HBCI::Pointer<HBCI::Customer> cp = const_cast<HBCI::Customer*>(c);
    cp.setAutoDelete(false);
    j->addSigner(cp);
}
OutboxJob_Status HBCI_OutboxJob_status(const HBCI_OutboxJob *j)
{
    assert(j);
    return j->status();
}
OutboxJob_Result HBCI_OutboxJob_result(const HBCI_OutboxJob *j)
{
    assert(j);
    return j->result();
}
int HBCI_OutboxJob_id(const HBCI_OutboxJob *j)
{
    assert(j);
    return j->id();
}
list_int *HBCI_OutboxJob_resultCodes(const HBCI_OutboxJob *j)
{
    assert(j);
    return new list_int(j->resultCodes());
}
const HBCI_MessageReference *
HBCI_OutboxJob_messageReference(const HBCI_OutboxJob *j)
{
    assert(j);
    return &(j->messageReference());
}
int HBCI_OutboxJob_segmentForStatusReport(const HBCI_OutboxJob *j)
{
    assert(j);
    return j->segmentForStatusReport();
}
JobProgressType HBCI_OutboxJob_type(const HBCI_OutboxJob *j)
{
    assert(j);
    return j->type();
}

