/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef LIBPOLYXMASS_CONFIG_H
#define LIBPOLYXMASS_CONFIG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*
  #define _(String) (String)
  #define N_(String) String
  #define textdomain(GETTEXT_PACKAGE)
  #define bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR)
*/

/* When ready for the gettext step, change lines above with:
 */
// #include <libintl.h>  replace with the wrapper ENABLE_NLS depending one:
#include "gettext.h" // see gettext manual page 111.
#define _(String) gettext (String) 
#define gettext_noop(String) String 
#define N_(String) gettext_noop (String)
/*
 */

/* all the includes */
#include <glib.h>
#include <math.h>
#include <stddef.h>
#include <limits.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include <stdlib.h>
#include <locale.h>

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/tree.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



  gchar *
  libpolyxmass_config_get_system_polyxmass_config_dir (void);

  gchar *
  libpolyxmass_config_get_user_polyxmass_config_dir (void);
  

  /*
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    The /etc/polyxmass/atom-defs/atom-defs-cat and similar files.
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  */
  gchar *
  libpolyxmass_config_get_system_atom_defs_cat_dir (void);

  gchar *
  libpolyxmass_config_get_user_atom_defs_cat_dir (void);



  /*
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    The /etc/polyxmass/polchem-defs/polchem-defs-cat and similar
    files.
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  */
  gchar *
  libpolyxmass_config_get_system_polchem_defs_cat_dir (void);
  
  gchar *
  libpolyxmass_config_get_user_polchem_defs_cat_dir (void);
  
  

  /*
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    The /etc/polyxmass/polchem-defs/polchem-defs-atom-defs-dic and
    similar files.
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  */
  gchar *
  libpolyxmass_config_get_system_polchem_defs_atom_defs_dic_dir (void);
  
  gchar *
  libpolyxmass_config_get_user_polchem_defs_atom_defs_dic_dir (void);
  









#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* ifndef LIBPOLYXMASS_CONFIG_H */

