/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_ELEMCOMPCALC_H
#define PXMCHEM_ELEMCOMPCALC_H

#include "libpolyxmass-globals.h"
#include "pxmchem-oligomer.h"
#include "pxmchem-polchemdef.h"
#include "pxmchem-cleave.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



PxmCompcalcRes
pxmchem_elemcompcalc_polymer (PxmPolymer *polymer,
			      PxmPolchemdef *polchemdef,
			      PxmCalcOpt *calcopt,
			      PxmIonizerule *ionizerule,
			      GPtrArray *acGPA, 
			      gchar **formula);
  

gboolean
pxmchem_elemcompcalc_noncapped_monomer_GPA (GPtrArray *GPA,
					    PxmPolchemdef *polchemdef, 
					    GPtrArray *acGPA, 
					    PxmCalcOpt *calcopt);
  
gboolean
pxmchem_elemcompcalc_polymer_account_caps (GPtrArray *acGPA,
					   PxmCapping cap,
					   PxmPolchemdef *polchemdef);
  
gboolean
pxmchem_elemcompcalc_polymer_account_left_end_modif (PxmPolymer *polymer,
						     GPtrArray *acGPA,
						     PxmPolchemdef *polchemdef);
  
gboolean
pxmchem_elemcompcalc_polymer_account_right_end_modif (PxmPolymer *polymer,
						      GPtrArray *acGPA,
						      PxmPolchemdef *polchemdef);
  
gboolean
pxmchem_elemcompcalc_polymer_account_ionizerule (PxmIonizerule *ionizerule,
						 GPtrArray *atom_refGPA,
						 GPtrArray *acGPA);
  
PxmCompcalcRes
pxmchem_elemcompcalc_oligomer (PxmOligomer *oligomer,
			       PxmPolchemdef *polchemdef,
			       PxmCalcOpt *calcopt,
			       PxmCleaveOpt *cleaveopt,
			       PxmIonizerule *ionizerule,
			       GPtrArray *acGPA,
			       gchar **formula);
  
gboolean
pxmchem_elemcompcalc_oligomer_account_cleaverule (PxmCleaveRule *lr_rule,
						     PxmOligomer *oligomer,
						     GPtrArray *atom_refGPA,
						     GPtrArray *acGPA);
  










#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_ELEMCOMPCALC_H */
