/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_SEARCHMASSOPT_H
#define PXMCHEM_SEARCHMASSOPT_H

#include "libpolyxmass-globals.h"
#include "libpolyxmass-prop.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef struct _PxmSearchmassOpt PxmSearchmassOpt;

  typedef enum _PxmSearchmassOptDup PxmSearchmassOptDup;
  typedef enum _PxmSearchmassOptPropDup PxmSearchmassOptPropup;
  

  struct _PxmSearchmassOpt
  {
    /* Mass type to search for.
     */
    PxmMassType mass_type;
  
    /* Mass to search for.
     */
    gdouble mass;
  
    /* Type of the tolerance: atomic mass unit, percentage, ppm.
     */
    PxmMassTolerance tolerance_type;

    /* Tolerance value.
     */
    gdouble tolerance;

    /* What chemical entities pertaining to monomers should be stored in
       the oligomer? Default: PXMCHEMENT_MNM_NONE.
    */
    PxmMnmChement mnm_chement;

    /* What chemical entities pertaining to the polymer sequence should
       be stored in the oligomer? Default: PXMCHEMENT_PLM_NONE.
    */
    PxmPlmChement plm_chement;

    /* put_sequence indicates if the generated oligomers should have a
       property holding a copy of the parent polymer sequence
       corresponding to the oligomer.
    */
    gboolean put_sequence; 
  };
  
  
  enum _PxmSearchmassOptDup
    {
      PXM_SEARCHMASSOPT_DUP_DEEP_NO = 0,
      PXM_SEARCHMASSOPT_DUP_DEEP_YES,
    };
    
  enum _PxmSearchmassOptPropDup
    {
      PXM_SEARCHMASSOPT_PROP_DUP_DEEP_NO = 0,
      PXM_SEARCHMASSOPT_PROP_DUP_DEEP_YES,
    };
  
  
  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmSearchmassOpt *
  pxmchem_searchmassopt_new (void);
  
  PxmSearchmassOpt *
  pxmchem_searchmassopt_dup (PxmSearchmassOpt *smopt, gint how_dup);
  
  PxmProp *
  pxmchem_searchmassopt_prop_dup (PxmProp * prop, gint how_dup);
  

  /* UTILITY FUNCTIONS
   */
  gboolean
  pxmchem_searchmassopt_set_default (PxmSearchmassOpt *smopt);
  
  
  /* FREE'ING FUNCTIONS
   */
  gboolean
  pxmchem_searchmassopt_free (PxmSearchmassOpt *smopt);

  gint 
  pxmchem_searchmassopt_prop_free (PxmProp *prop);
  




  /* GPtrArray-RELATED FUNCTIONS
   */
  gint
  pxmchem_searchmassopt_GPA_free (GPtrArray *GPA);
  







#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_SEARCHMASSOPT_H */
