#ifndef parens_SERIALIZER_H_INCLUDED
#define parens_SERIALIZER_H_INCLUDED 1

////////////////////////////////////////////////////////////////////////
// data_node_serializers.h: some file parsers for the s11n framework
//
// License: Public Domain
// Author: stephan@s11n.net
////////////////////////////////////////////////////////////////////////

#include "data_node_format.h" // base interfaces
#define PARENS_VERSION "$Revision: 1.1.1.1 $"
#define MAGIC_COOKIE_PARENS "(S11N_NS::parens)"
#define TAB(LEVEL,ECHO) indent = ""; for( size_t i = 0; i < depth + LEVEL; i++ ) { indent += '\t'; if(ECHO) dest << '\t'; }

namespace S11N_NS {
	namespace io {

                namespace sharing {
                        /**
                           Sharing context used by parens_serializer.
                        */
                        struct parens_sharing_context {};
                }


                /**
                   The entity translations map used by parens_serializer.
                 */
                entity_translation_map & parens_serializer_translations();

                /**
                   De/serializes objects from/to a lisp-like grammar.
                */
                template <typename NodeType>
                class parens_serializer : public tree_builder_lexer<NodeType,sharing::parens_sharing_context>
                {
                public:
                        typedef NodeType node_type;

                        typedef parens_serializer<node_type> this_type; // convenience typedef
                        typedef tree_builder_lexer<node_type,sharing::parens_sharing_context> parent_type; // convenience typedef

                        parens_serializer() : parent_type( "parens_data_nodeFlexLexer" ),
                                              m_depth(0)
                        {
                                this->magic_cookie( MAGIC_COOKIE_PARENS );
                        }

                        virtual ~parens_serializer() {}

                        typedef entity_translation_map translation_map;

                        /**
                           Reimplemented to return this type's entity
                           translation map.
                         */
                        virtual const translation_map & entity_translations() const
                        {
                                return parens_serializer_translations();
                        }


                        /**
                           Writes src out to dest.
                        */
                        virtual bool serialize( const node_type & src, std::ostream & dest )
                        {
                                size_t depth = this->m_depth++;
                                if( 0 == depth )
                                {
                                        node_type & meta = this->metadata();
                                        dest << this->magic_cookie() << '\n';
                                        meta.set( "serializer_revision", PARENS_VERSION );
                                        meta.set( "serializer_class", ::classname<this_type>() );
                                        //this->serialize( meta, dest );
                                }


                                std::string indent;
                                // i know this quote check is fairly expensive, but 2 bytes per
                                // object adds up. Consider: 10k objects would take up
                                // 20k bytes just in classname quotes!
                                std::string quote =
                                        (std::string::npos != src.impl_class().find('<'))
                                        ? "\""
                                        : "";
                                dest << src.name() << "=" << this->m_open
                                     << quote << src.impl_class() << quote;

                                bool gotp = (src.begin() != src.end());

                                if( gotp )
                                {
                                        //TAB(1,0);
                                        std::for_each(src.begin(),
                                                      src.end(),
                                                      key_value_serializer<node_type>(
                                                              &(this->entity_translations()),
                                                              dest,
                                                              /* indent + */ ' ' + this->m_open ,
                                                              " ",
                                                              this->m_close + ' ' )
                                                      );
                                }
                                bool gotch = (src.children().begin() != src.children().end());
                                if( gotch )
                                { // got children?
                                        dest << '\n';
                                        TAB(1,0);
                                        std::for_each( src.children().begin(),
                                                       src.children().end(),
                                                       node_child_simple_formatter<this_type>(
                                                                    *this,
                                                                    dest,
                                                                    indent,
                                                                    "" )
                                                       );
                                        TAB(0,1);
                                }

                                dest << this->m_close << '\n';

                                if( 0 == depth )
                                {
                                        dest.flush(); // << std::endl; // else client may be forced to manually flush().
                                }
                                --this->m_depth;
                                return true;
                        }



                private:
                        size_t m_depth;
                        static const std::string m_open;
                        static const std::string m_close;
                };
                template <typename NodeType>
                const std::string parens_serializer<NodeType>::m_open = "(";
                template <typename NodeType>
                const std::string parens_serializer<NodeType>::m_close = ")";

	} // namespace io
} // namespace S11N_NS

#undef TAB

#endif // parens_SERIALIZER_H_INCLUDED
