#ifndef S11N_NS_S11N_H_INCLUDED
#define S11N_NS_S11N_H_INCLUDED 1

////////////////////////////////////////////////////////////////////////
// s11n.h:
// Author: stephan beal <stephan@s11n.net>
// License: Public Domain
//
// This header include "everything most clients would want."
//
//
// The s11n namespace docs go here so doxygen will pick them up nicely.
////////////////////////////////////////////////////////////////////////

/**
   The s11n serialization (s11n) framework is an object serialization
   framework modelled heavily off work by Rusty Ballinger
   (bozo@users.sourceforge.net http://libfunutil.sourceforge.net). As
   far as i know Rusty was the one to coin the phrase "s11n" (short
   for "serialization", in the same way that i18n is short for
   "internationalization").

   In addition to the class documentation, please see the library
   manual, available in the source tree, in the docs subdir.

   The most important places for clients to understand:

   - data_node (or a client-supplied functional equivalent)

   - the serialize() and deserialize() family of free functions.

   - The docs for the registration-related macros: in the source tree
   see lib/node/data_node_serializer.h

*/
namespace S11N_NS
{

        /**
           The Private namespace holds internal library types: these
           should not be used in client code.
        */
        namespace Private
        {

        }

        /**
           The S11N_NS::io namespace defines some i/o-related
           types which conform to the conventions expected by the
           <code>S11N_NS::de/serialize()</code> free
           functions. In theory clients can swap out these types and
           still use the core s11n interface. The core has no
           dependencies on this namespace.
        */
        namespace io {
        }
}

#include "s11n_core.h" // classloader
#include "data_node.h" // reference NodeType implementation
#include "data_node_algo.h" // reference NodeType implementation
#include "data_node_serialize.h" // serialize() and friends

#include "default_registrations.h" // default proxy setups for some common types

#include "data_node_io.h" // i/o-related interfaces

#include "data_node_format.h" // tree_builder and related classes
#include "serializers.h" // default serializers/parsers.

#include "sam_std_containers.h" // default SAMs for std containers
#endif // S11N_NS_S11N_H_INCLUDED
